/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.backend.LEAlarmFactory;
import COM.livingston.backend.LEAlarmMessage;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEAlarmFacility;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;
import java.util.Hashtable;

public class LEMonAlarmsView
extends LEMonitorPanel {
    static int[] s_monitors = null;
    Hashtable m_alarms = new Hashtable();

    public LEMonAlarmsView() {
        this.initialize(1, 1, 5);
        this.setCellJustification(2, 2);
        this.setCellJustification(3, 2);
        this.setCellJustification(4, 2);
        this.m_resetCols = new int[1];
        this.m_resetCols[0] = 4;
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_pms == null) {
            return;
        }
        if (object instanceof LEAlarmMessage) {
            this.updateAlarm(string, (LEAlarmMessage)object);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    void updateAlarm(String string, LEAlarmMessage lEAlarmMessage) {
        String string2 = lEAlarmMessage.getName();
        Integer n = this.getRow(string, string2);
        if (n == null) {
            this.createRow(string, string2, lEAlarmMessage);
            return;
        }
        this.updateRow(n, lEAlarmMessage);
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Message");
        objectArray[n2++] = new String("Severity");
        objectArray[n2++] = new String("Time");
        objectArray[n2++] = new String("Count");
        objectArray[n2++] = new String("State");
    }

    void createRow(String string, String string2, LEAlarmMessage lEAlarmMessage) {
        Object[] objectArray = new Object[this.getNumColumns()];
        int n = 0;
        objectArray[n++] = string;
        objectArray[n++] = lEAlarmMessage.getMessage();
        objectArray[n++] = lEAlarmMessage.getSeverity();
        objectArray[n++] = lEAlarmMessage.getTime();
        objectArray[n++] = new Long(lEAlarmMessage.getCount());
        String string3 = lEAlarmMessage.getState();
        if (string3 == null) {
            string3 = "";
        }
        objectArray[n++] = string3;
        this.addRow(string, string2, objectArray);
    }

    void updateRow(int n, LEAlarmMessage lEAlarmMessage) {
        int n2 = 0;
        int n3 = ++n2;
        this.setCellItem(n, n3, lEAlarmMessage.getMessage());
        int n4 = ++n2;
        this.setCellItem(n, n4, lEAlarmMessage.getSeverity());
        int n5 = ++n2;
        ++n2;
        this.setCellItem(n, n5, lEAlarmMessage.getTime());
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEAlarmMessage.getCount()));
        ++n2;
        String string = lEAlarmMessage.getState();
        if (string != null) {
            this.setCellItem(n, n2++, string);
        }
    }

    int[] getMonitorEntities() {
        if (s_monitors == null) {
            s_monitors = new int[1];
            LEMonAlarmsView.s_monitors[0] = 655360;
        }
        return s_monitors;
    }

    void startMonitoring(LEPortMaster lEPortMaster, String string) {
        if (!lEPortMaster.isConnected()) {
            return;
        }
        LEAlarmFacility lEAlarmFacility = lEPortMaster.getAlarmFacility();
        if (lEAlarmFacility == null) {
            return;
        }
        String string2 = lEPortMaster.getHostname();
        LEVector lEVector = lEAlarmFacility.getAlarms();
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            this.updateAlarm(string2, (LEAlarmMessage)lEVector.elementAt(n2));
            ++n2;
        }
        LEAlarmFactory.GetFactory().addObserver(string2, this);
    }

    void stopMonitoring(LEPortMaster lEPortMaster, String string) {
        String string2 = lEPortMaster.getHostname();
        LEAlarmFactory.GetFactory().deleteObserver(string2, this);
        this.remove(string2);
    }

    String getMonitorName() {
        return "Monitor Alarms";
    }
}

