/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEMonEnvMessage;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.model.LEBoard;
import COM.livingston.model.LEBoards;
import COM.livingston.model.LEMonitorFacility;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEMultiList;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEScrollablePanel;
import COM.livingston.ui.LEStatusDialog;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LEMonStatusView
extends Panel
implements ItemListener,
ActionListener,
LEView,
LEAMObserver {
    public static final String DASH = "-";
    public static final String MANAGER = "4";
    public static final String ETHERNET = "10";
    static LEPortMaster s_pm = null;
    LEPortMaster[] m_pms;
    LEPortMaster m_selPM;
    Panel m_pmPanel;
    Choice m_pmChoice;
    LEMultiList m_boards;
    Label[] m_values;

    public static void Display(LEPortMaster lEPortMaster) {
        s_pm = lEPortMaster;
    }

    public LEMonStatusView() {
        this.setLayout(new BorderLayout(0, 0));
        this.m_pmPanel = new Panel();
        this.m_pmPanel.setLayout(new FlowLayout(1));
        this.m_pmChoice = new Choice();
        this.m_pmChoice.addItemListener(this);
        this.m_pmPanel.add(this.m_pmChoice);
        this.add("North", this.m_pmPanel);
        LEBorderPanel lEBorderPanel = new LEBorderPanel(1);
        lEBorderPanel.setLayout(new BorderLayout());
        lEBorderPanel.add("West", this.createPowerPanel());
        lEBorderPanel.add("Center", this.createBoardPanel());
        this.add("Center", lEBorderPanel);
    }

    public void addListener(LEViewListener lEViewListener) {
    }

    public void deleteListener(LEViewListener lEViewListener) {
    }

    public Component getMainPanel() {
        return this;
    }

    public Component getBottomPanel() {
        return null;
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        int n;
        this.m_pms = lEPortMasterArray;
        this.updatePMChoice(this.m_pms);
        int n2 = -1;
        if (s_pm == null) {
            n = 0;
            while (n2 == -1 && n < this.m_pms.length) {
                if (this.m_pms[n] == this.m_selPM) {
                    n2 = n;
                }
                ++n;
            }
        }
        if (n2 == -1) {
            if (this.m_selPM != null) {
                this.stopMonitoring(this.m_selPM);
            }
            this.m_selPM = null;
            n2 = 0;
        }
        if (s_pm != null) {
            n2 = -1;
            n = 0;
            while (n2 == -1 && n < this.m_pms.length) {
                if (this.m_pms[n] == s_pm) {
                    n2 = n;
                }
                ++n;
            }
            if (n2 == -1) {
                n2 = 0;
            }
            s_pm = null;
        }
        if (this.m_pms.length > 0) {
            this.m_pmChoice.select(n2);
            if (this.m_selPM == null) {
                this.m_selPM = this.m_pms[n2];
                this.startMonitoring(this.m_selPM);
            }
        }
    }

    public void going() {
        if (this.m_selPM != null) {
            this.stopMonitoring(this.m_selPM);
        }
    }

    public void gone() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        LEBoard lEBoard;
        String string;
        if (this.m_selPM == null) {
            return;
        }
        LEBoards lEBoards = (LEBoards)this.m_selPM.get("2555904");
        if (lEBoards == null) {
            return;
        }
        new LEVector();
        String string2 = actionEvent.getActionCommand();
        String string3 = string2.equals("On") ? "on" : "off";
        boolean bl = false;
        int[] nArray = this.m_boards.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            String string4;
            string = (String)this.m_boards.getCellItem(nArray[n], 0);
            if (!(string.equals(MANAGER) || string.equals(ETHERNET) || (lEBoard = (LEBoard)lEBoards.get(string)) == null || (string4 = (String)lEBoard.get(LEBoard.POWER)).equals(string3))) {
                lEBoard.set(LEBoard.POWER, string3);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
            LEVector lEVector = lEBoards.saveChanges(true);
            lEBoards.refresh();
            lEStatusDialog.hideStatus();
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), this.m_selPM.getConfigFacility(), lEVector);
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                string = (String)this.m_boards.getCellItem(nArray[n2], 0);
                lEBoard = (LEBoard)lEBoards.get(string);
                if (lEBoard != null) {
                    this.m_boards.setCellItem(nArray[n2], 1, lEBoard.getType());
                    this.m_boards.setCellItem(nArray[n2], 4, lEBoard.getStatus());
                }
                ++n2;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.m_pmChoice.getSelectedIndex();
        if (this.m_pms[n] != this.m_selPM) {
            if (this.m_selPM != null) {
                this.stopMonitoring(this.m_selPM);
            }
            this.m_selPM = this.m_pms[n];
            this.startMonitoring(this.m_selPM);
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_selPM == null) {
            return;
        }
        if (!string.equals(this.m_selPM.getHostname())) {
            return;
        }
        if (object instanceof LEMonEnvMessage) {
            this.updateEnv((LEMonEnvMessage)object);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus((LEStatusMessage)object);
        }
    }

    void startMonitoring(LEPortMaster lEPortMaster) {
        Object object;
        LEMonitorFacility lEMonitorFacility = lEPortMaster.getMonitorFacility();
        if (lEMonitorFacility == null) {
            return;
        }
        LEBoards lEBoards = (LEBoards)lEPortMaster.get("2555904");
        if (lEBoards != null) {
            object = lEBoards.getKeys();
            int n = ((LEVector)object).size();
            int n2 = 0;
            while (n2 < n) {
                this.addRow((String)((LEVector)object).elementAt(n2), null);
                ++n2;
            }
        }
        object = lEPortMaster.getHostname();
        LEMonitorFactory.GetFactory().addObserver((String)object, this);
        LEStatusFactory.GetFactory().addObserver((String)object, this);
        lEMonitorFacility.startMonitor(0x330000, -1);
    }

    void stopMonitoring(LEPortMaster lEPortMaster) {
        this.resetValues();
        LEMonitorFacility lEMonitorFacility = lEPortMaster.getMonitorFacility();
        if (lEMonitorFacility == null) {
            return;
        }
        String string = lEPortMaster.getHostname();
        LEMonitorFactory.GetFactory().deleteObserver(string, this);
        LEStatusFactory.GetFactory().deleteObserver(string, this);
        lEMonitorFacility.stopMonitor(0x330000, -1);
    }

    void updatePMChoice(LEPortMaster[] lEPortMasterArray) {
        this.m_pmChoice.removeAll();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            this.m_pmChoice.add(lEPortMasterArray[n].getHostname());
            ++n;
        }
        this.m_pmChoice.invalidate();
        this.m_pmPanel.invalidate();
        this.m_pmPanel.validate();
    }

    void updateEnv(LEMonEnvMessage lEMonEnvMessage) {
        if (this.m_selPM == null) {
            return;
        }
        this.m_values[0].setText(lEMonEnvMessage.getMaxPower());
        this.m_values[1].setText(lEMonEnvMessage.getUsedPower());
        this.m_values[2].setText(lEMonEnvMessage.getReqPower());
        this.m_values[3].setText(lEMonEnvMessage.getPowerSupply("top"));
        this.m_values[4].setText(lEMonEnvMessage.getPowerSupply("middle"));
        this.m_values[5].setText(lEMonEnvMessage.getPowerSupply("bottom"));
        this.m_values[6].setText(lEMonEnvMessage.getPrimaryDC());
        this.m_values[7].setText(lEMonEnvMessage.getSecondaryDC());
        this.m_values[8].setText(lEMonEnvMessage.getFan(1));
        this.m_values[9].setText(lEMonEnvMessage.getFan(2));
        this.m_values[10].setText(lEMonEnvMessage.getFan(3));
        this.m_values[11].setText(lEMonEnvMessage.getFan(4));
        LEBoards lEBoards = (LEBoards)this.m_selPM.get("2555904");
        if (lEBoards == null) {
            return;
        }
        int n = 0;
        while (n < 15) {
            String string = Integer.toString(n);
            LEBoard lEBoard = (LEBoard)lEBoards.get(string);
            if (lEBoard != null) {
                int n2 = this.getRowFor(string);
                if (n2 > -1) {
                    String string2;
                    String string3 = lEMonEnvMessage.getBoardTemp(string);
                    if (string3 == null) {
                        string3 = DASH;
                    }
                    if ((string2 = lEMonEnvMessage.getBoardPower(string)) == null) {
                        string2 = DASH;
                    }
                    this.m_boards.setCellItem(n2, 1, lEBoard.getType());
                    this.m_boards.setCellItem(n2, 2, string3);
                    this.m_boards.setCellItem(n2, 3, string2);
                    this.m_boards.setCellItem(n2, 4, lEBoard.getStatus());
                } else {
                    this.addRow(string, lEMonEnvMessage);
                }
            }
            ++n;
        }
        this.m_boards.repaint();
    }

    void updateStatus(LEStatusMessage lEStatusMessage) {
        switch (lEStatusMessage.getStatus()) {
            case 1: {
                this.startMonitoring(this.m_selPM);
                return;
            }
            case 2: 
            case 4: {
                this.stopMonitoring(this.m_selPM);
                return;
            }
        }
    }

    void resetValues() {
        int n = 0;
        while (n < this.m_values.length) {
            this.m_values[n].setText("");
            ++n;
        }
        this.m_boards.deleteAllRows();
    }

    void addRow(String string, LEMonEnvMessage lEMonEnvMessage) {
        if (this.m_selPM == null) {
            return;
        }
        LEBoards lEBoards = (LEBoards)this.m_selPM.get("2555904");
        if (lEBoards == null) {
            return;
        }
        LEBoard lEBoard = (LEBoard)lEBoards.get(string);
        if (lEBoard == null) {
            return;
        }
        Object[] objectArray = new Object[]{string, lEBoard.getType(), lEMonEnvMessage == null ? "" : lEMonEnvMessage.getBoardTemp(string), lEMonEnvMessage == null ? "" : lEMonEnvMessage.getBoardPower(string), lEBoard.getStatus()};
        this.m_boards.addRow(objectArray);
        int n = this.m_boards.getNumRows() - 1;
        this.m_boards.setRowObject(n, string);
    }

    int getRowFor(String string) {
        int n = -1;
        int n2 = this.m_boards.getNumRows();
        int n3 = 0;
        while (n == -1 && n3 < n2) {
            if (string.equals((String)this.m_boards.getRowObject(n3))) {
                n = n3;
            }
            ++n3;
        }
        return n;
    }

    Component createPowerPanel() {
        Font font = LEFont.getBoldFont();
        this.m_values = new Label[12];
        int n = 0;
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(19, 1, 0, 0));
        Label label = new Label(" Power (watts):", 0);
        panel.add(label);
        label.setFont(font);
        panel.add(this.createValuePanel(font, "   Maximum:", n++, ""));
        panel.add(this.createValuePanel(font, "   Used:", n++, ""));
        panel.add(this.createValuePanel(font, "   Required:", n++, ""));
        panel.add(new Label(""));
        label = new Label(" AC Power Supplies:", 0);
        panel.add(label);
        label.setFont(font);
        panel.add(this.createValuePanel(font, "   Top:", n++, ""));
        panel.add(this.createValuePanel(font, "   Middle:", n++, ""));
        panel.add(this.createValuePanel(font, "   Bottom:", n++, ""));
        panel.add(new Label(""));
        label = new Label(" DC Power Supplies:", 0);
        panel.add(label);
        label.setFont(font);
        panel.add(this.createValuePanel(font, "   Primary:", n++, ""));
        panel.add(this.createValuePanel(font, "   Secondary:", n++, ""));
        panel.add(new Label(""));
        label = new Label(" Fans:", 0);
        panel.add(label);
        label.setFont(font);
        panel.add(this.createValuePanel(font, "   1:", n++, ""));
        panel.add(this.createValuePanel(font, "   2:", n++, ""));
        panel.add(this.createValuePanel(font, "   3:", n++, ""));
        panel.add(this.createValuePanel(font, "   4:", n++, ""));
        return new LEScrollPanel(new LEScrollablePanel(panel, false, false));
    }

    Component createValuePanel(Font font, String string, int n, String string2) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2, 0, 0));
        Label label = new Label(string, 0);
        label.setFont(font);
        panel.add(label);
        this.m_values[n] = new Label(string2, 0);
        panel.add(this.m_values[n]);
        return panel;
    }

    Component createBoardPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        this.m_boards = new LEMultiList(1, 1, 4);
        Object[] objectArray = new String[]{"Board", "Type", "Temperature (c)", "Power (watts)", "Status"};
        this.m_boards.setTitles(0, objectArray);
        this.m_boards.setCellJustification(0, 2);
        this.m_boards.setCellJustification(2, 2);
        this.m_boards.setCellJustification(3, 2);
        panel.add("Center", new LEScrollPanel(this.m_boards));
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(1));
        panel2.add(new Label("Power Selected Board(s): "));
        Button button = new Button("On");
        panel2.add(button);
        button.addActionListener(this);
        button = new Button("Off");
        panel2.add(button);
        button.addActionListener(this);
        panel.add("South", panel2);
        return panel;
    }

    String getMonitorName() {
        return "Monitor Chassis";
    }
}

