/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.backend.LEMonLinesMessage;
import com.lucent.ra.nms.backend.LEStatusMessage;

public class LEMonLinesView
extends LEMonitorPanel {
    static int[] s_monitors = null;

    public LEMonLinesView() {
        this.initialize(1, 3, 10);
        this.setCellJustification(1, 2);
        int n = this.getNumColumns();
        int n2 = 4;
        while (n2 < n) {
            this.setCellJustification(n2, 2);
            ++n2;
        }
        this.m_resetCols = new int[7];
        int n3 = 0;
        while (n3 < 7) {
            this.m_resetCols[n3] = n3 + 6;
            ++n3;
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_pms == null) {
            return;
        }
        if (object instanceof LEMonLinesMessage) {
            LEMonLinesMessage lEMonLinesMessage = (LEMonLinesMessage)object;
            String string2 = String.valueOf(lEMonLinesMessage.getBoard()) + lEMonLinesMessage.getName();
            Integer n = this.getRow(string, string2);
            if (n == null) {
                this.createRow(string, string2, lEMonLinesMessage);
            } else {
                this.updateRow(n, lEMonLinesMessage);
            }
            this.repaint();
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Board");
        objectArray[n2++] = new String("Line");
        objectArray[n2++] = new String("Layer 1");
        objectArray[n2++] = new String("Layer 2");
        objectArray[n2++] = new String("Receive Level");
        objectArray[n2++] = new String("Blue Alarm");
        objectArray[n2++] = new String("Yellow Alarm");
        objectArray[n2++] = new String("Carrier Loss");
        objectArray[n2++] = new String("Sync Loss");
        objectArray[n2++] = new String("Bipolar Error");
        objectArray[n2++] = new String("CRC Error");
        objectArray[n2++] = new String("Multiframe Sync Error");
    }

    void createRow(String string, String string2, LEMonLinesMessage lEMonLinesMessage) {
        String[] stringArray = new String[this.getNumColumns()];
        int n = 0;
        stringArray[n++] = this.getPM(string).getDescription();
        stringArray[n++] = lEMonLinesMessage.getBoard();
        stringArray[n++] = lEMonLinesMessage.getName();
        stringArray[n++] = lEMonLinesMessage.getStatus();
        stringArray[n++] = lEMonLinesMessage.getStatus2();
        stringArray[n++] = lEMonLinesMessage.getRecvLevel();
        stringArray[n++] = Long.toString(lEMonLinesMessage.getBlueAlarm());
        stringArray[n++] = Long.toString(lEMonLinesMessage.getYellowAlarm());
        stringArray[n++] = Long.toString(lEMonLinesMessage.getCarrierLoss());
        stringArray[n++] = Long.toString(lEMonLinesMessage.getSyncLoss());
        stringArray[n++] = Long.toString(lEMonLinesMessage.getBIPolarError());
        stringArray[n++] = Long.toString(lEMonLinesMessage.getCRCError());
        stringArray[n++] = Long.toString(lEMonLinesMessage.getSyncError());
        this.addRow(string, string2, stringArray);
    }

    void updateRow(int n, LEMonLinesMessage lEMonLinesMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        int n3 = ++n2;
        this.setCellString(n, n3, lEMonLinesMessage.getStatus());
        int n4 = ++n2;
        this.setCellString(n, n4, lEMonLinesMessage.getStatus2());
        int n5 = ++n2;
        ++n2;
        this.setCellString(n, n5, lEMonLinesMessage.getRecvLevel());
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellString(n, n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getBlueAlarm()).toString());
        this.setCellString(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getYellowAlarm()).toString());
        this.setCellString(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getCarrierLoss()).toString());
        this.setCellString(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getSyncLoss()).toString());
        this.setCellString(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getBIPolarError()).toString());
        this.setCellString(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getCRCError()).toString());
        this.setCellString(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getSyncError()).toString());
    }

    int[] getMonitorEntities() {
        if (s_monitors == null) {
            s_monitors = new int[1];
            LEMonLinesView.s_monitors[0] = 131072;
        }
        return s_monitors;
    }

    String getMonitorName() {
        return "Monitor Lines";
    }
}

