/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;

public class LELocationTemplate {
    private static final String DEFAULT_PATTERN = "set\\s+location\\s+\\S+\\s+(\\w*)\\s+(\\S+)";
    private static final String TYPE_PATTERN = "set\\s+location\\s+\\S+\\s+(\\w+)";
    private static final String IDLE_PATTERN = "set\\s+location\\s+\\S+\\s+idle_timeout\\s+(\\w+)\\s+(\\w*)";
    private static final String NAME_PATTERN = "add\\s+location\\s+(\\S+)";
    private static final String RIPV2_PATTERN = "set\\s+location\\s+\\S+\\s+rip\\s+v2\\s+(\\S+)";
    static Perl5Matcher s_matcher = new Perl5Matcher();
    static Perl5Pattern s_defaultPattern;
    static Perl5Pattern s_typePattern;
    static Perl5Pattern s_idlePattern;
    static Perl5Pattern s_namePattern;
    static Perl5Pattern s_ripv2Pattern;

    protected static void ReadTemplateLine(LEVector templates, String line) {
        try {
            if (s_matcher.contains(line, (Pattern)s_defaultPattern)) {
                MatchResult result = s_matcher.getMatch();
                String template_key = result.group(1);
                templates.add(template_key);
            } else if (s_matcher.contains(line, (Pattern)s_idlePattern)) {
                templates.add("idle_timeout");
            } else if (s_matcher.contains(line, (Pattern)s_namePattern)) {
                templates.add("add location");
            } else if (s_matcher.contains(line, (Pattern)s_typePattern)) {
                MatchResult result = s_matcher.getMatch();
                String template_key = result.group(1);
                templates.add(template_key);
            } else if (s_matcher.contains(line, (Pattern)s_ripv2Pattern)) {
                templates.add("rip v2");
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    static {
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            s_defaultPattern = (Perl5Pattern)compiler.compile(DEFAULT_PATTERN, 1);
            s_typePattern = (Perl5Pattern)compiler.compile(TYPE_PATTERN, 1);
            s_idlePattern = (Perl5Pattern)compiler.compile(IDLE_PATTERN, 1);
            s_namePattern = (Perl5Pattern)compiler.compile(NAME_PATTERN, 1);
            s_ripv2Pattern = (Perl5Pattern)compiler.compile(RIPV2_PATTERN, 1);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

