/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPortMaster_RI;
import com.lucent.ra.nms.backend.LEMonitorFacility_R;
import com.lucent.ra.nms.backend.LEMonitorSetting;
import com.lucent.ra.nms.util.LEDebug;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEMonitorFacility_RI
extends UnicastRemoteObject
implements LEMonitorFacility_R {
    public static final int NO_BOARD = -1;
    public static final String NO_GROUP = null;
    public static final String NO_START = null;
    public static final String NO_END = null;
    static long s_req;
    LEDSSPortMaster_RI m_dss;
    Hashtable m_mons = new Hashtable();

    public static int GetMonitorTime(int entity) {
        return 60000;
    }

    public LEMonitorFacility_RI(LEDSSPortMaster_RI dss) throws RemoteException {
        this.m_dss = dss;
    }

    public synchronized boolean startMonitor(int entity, int board, String group, String start, String end, int interval) throws RemoteException {
        boolean success = true;
        String key = LEMonitorSetting.BuildKey(entity, board, group, start, end);
        LEMonitorSetting setting = (LEMonitorSetting)this.m_mons.get(key);
        if (setting == null) {
            setting = new LEMonitorSetting(entity, board, group, start, end, key);
            this.m_mons.put(key, setting);
        }
        if (setting.addInterval(interval)) {
            success = this.restart(setting);
        }
        return success;
    }

    public boolean startMonitor(LEMonitorSetting setting) throws RemoteException {
        boolean success = true;
        int entity = setting.getEntity();
        int board = setting.getBoard();
        String group = setting.getGroup();
        String start = setting.getStart();
        String end = setting.getEnd();
        int len = setting.getIntervalCount();
        int i = 0;
        while (i < len) {
            success = this.startMonitor(entity, board, group, start, end, setting.getIntervalAt(i));
            ++i;
        }
        return success;
    }

    public synchronized void stopMonitor(int entity, int board, String group, String start, String end, int interval) throws RemoteException {
        String key = LEMonitorSetting.BuildKey(entity, board, group, start, end);
        LEMonitorSetting setting = (LEMonitorSetting)this.m_mons.get(key);
        if (setting != null && setting.removeInterval(interval)) {
            this.restart(setting);
        }
    }

    public void shutdown() {
        Enumeration enumeration = this.m_mons.elements();
        while (enumeration.hasMoreElements()) {
            LEMonitorSetting setting = (LEMonitorSetting)enumeration.nextElement();
            long req = setting.getRequest();
            if (req <= 0L) continue;
            this.killMonitor(req);
        }
        this.m_mons.clear();
        this.m_dss = null;
    }

    public boolean monitor(LEMonitorSetting setting, int interval) {
        boolean success = true;
        try {
            int entity = setting.getEntity();
            int board = setting.getBoard();
            String group = setting.getGroup();
            String start = setting.getStart();
            String end = setting.getEnd();
            if (this.m_dss.isConnected()) {
                long req = board != -1 ? (start != null && end != null ? this.m_dss.monitor(entity, interval, board, start, end) : this.m_dss.monitor(entity, interval, board)) : (group != null && group.length() > 0 ? this.m_dss.monitor(entity, interval, group) : this.m_dss.monitor(entity, interval));
                setting.setRequest(req);
            }
        }
        catch (LEDSSException lEDSSException) {
            success = false;
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            success = false;
        }
        return success;
    }

    boolean restart(LEMonitorSetting setting) {
        int interval;
        boolean success = true;
        long req = setting.getRequest();
        if (req > 0L) {
            this.killMonitor(req);
            setting.setRequest(0L);
        }
        if ((interval = setting.getSmallestInterval()) > 0) {
            success = this.monitor(setting, interval);
        }
        return success;
    }

    void killMonitor(long req) {
        try {
            if (this.m_dss.isConnected()) {
                this.m_dss.killMonitor(req);
            }
        }
        catch (LEDSSException lEDSSException) {
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

