/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEIPSecProfile;
import com.lucent.ra.nms.model.LEIPSecProfiles;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEIPSecProfilesForm
extends LETableForm {
    static final String PORTMASTER = "Device";
    String m_addName;

    public LEIPSecProfilesForm() {
        this.m_keyReadonly = false;
    }

    public void setContext(String string, LEVector lEVector) {
        this.m_platform = string;
        this.m_context = lEVector;
        this.m_cols = 1;
        this.initialize(1, 2, this.m_cols);
        String[] stringArray = new String[this.m_cols + 2];
        stringArray[0] = PORTMASTER;
        stringArray[1] = "IPSec Profile";
        stringArray[2] = "Rule Count";
        this.setTitles(0, stringArray);
    }

    void addEntry(String string, LETable lETable, String string2) {
        String[] stringArray = new String[this.m_cols + 2];
        stringArray[0] = string;
        stringArray[1] = string2;
        Object object = lETable.get(string2);
        if (object instanceof LEIPSecProfile) {
            LEIPSecProfile lEIPSecProfile = (LEIPSecProfile)object;
            stringArray[2] = Integer.toString(lEIPSecProfile.size());
        }
        this.addRow(stringArray);
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label("IPSec Profile Name:");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        panel.add("Center", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add IPSec Profile", panel);
        if (lEAddDialog.okay()) {
            this.m_addName = ((LEFormLine)((Object)component)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An IPSec Profile name must be entered");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LETable lETable = this.getTable(lEPortMaster);
        if (lETable.get(this.m_addName) == null) {
            LEVector lEVector = ((LEIPSecProfiles)lETable).add(this.m_addName);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            } else {
                this.addEntry(lEPortMaster.getDescription(), lETable, this.m_addName);
                lENewEntry = new LENewEntry(lEPortMaster, lETable, this.m_addName);
            }
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getDescription()) + " already contains a IPSec Profile named " + this.m_addName);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LEIPSecProfiles)) {
            return;
        }
        LEIPSecProfiles lEIPSecProfiles = (LEIPSecProfiles)lETable;
        LEVector lEVector = lEIPSecProfiles.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
        }
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        LEVector lEVector;
        String string;
        if (!(object instanceof LEIPSecProfile)) {
            return null;
        }
        LEIPSecProfile lEIPSecProfile = (LEIPSecProfile)object;
        LEIPSecProfiles lEIPSecProfiles = (LEIPSecProfiles)this.getTable(lEPortMaster);
        if (lEIPSecProfiles.get(string = lEIPSecProfile.getName()) != null) {
            string = LETableForm.GetUniqueKey(lEIPSecProfiles, string, 15);
        }
        if ((lEVector = lEIPSecProfiles.add(string)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            string = null;
        }
        return string;
    }
}

