/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEHelpManager;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LEServiceFormLine
extends Panel
implements LEFormLine,
ActionListener,
ItemListener,
MouseListener {
    public static final String NETDATA = new String("netdata");
    public static final String PORTMASTER = new String("portmaster");
    public static final String RLOGIN = new String("rlogin");
    public static final String TELNET = new String("telnet");
    static final String VALID = new String("netdata (0-65535), portmaster, rlogin, telnet (0-65535)");
    Choice m_service;
    LETextField m_tport;
    LEFormLineListener m_listener;

    public LEServiceFormLine() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.m_service = new Choice();
        this.add(this.m_service);
        this.m_service.add(NETDATA);
        this.m_service.add(PORTMASTER);
        this.m_service.add(RLOGIN);
        this.m_service.add(TELNET);
        this.m_service.addItemListener(this);
        this.m_tport = new LETextField(5);
        this.add(this.m_tport);
        this.m_tport.setNumeric(true);
        this.m_tport.addActionListener(this);
        this.addMouseListener(this);
    }

    public void setListener(LEFormLineListener lEFormLineListener) {
        this.m_listener = lEFormLineListener;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        if (string.equals(NETDATA) || string.equals(TELNET)) {
            this.m_tport.setEnabled(true);
        } else {
            this.m_tport.setEnabled(false);
        }
        this.notifyListener();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.notifyListener();
    }

    public void initFormLine(LEPortMaster lEPortMaster, LEDataSpec lEDataSpec) {
    }

    public void setValue(Object object) {
        String string = object.toString();
        String string2 = null;
        int n = string.indexOf(64);
        if (n > -1) {
            string2 = string.substring(n + 1, string.length());
            string = string.substring(0, n);
        }
        int n2 = this.m_service.getItemCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (string.equalsIgnoreCase(this.m_service.getItem(n4))) {
                n3 = n4;
            }
            ++n4;
        }
        this.m_service.select(n3);
        if (string.equalsIgnoreCase(NETDATA) || string.equalsIgnoreCase(TELNET)) {
            this.m_tport.setEnabled(true);
            if (string2 != null) {
                this.m_tport.setText(string2);
                return;
            }
            this.m_tport.setText("0");
            return;
        }
        this.m_tport.setEnabled(false);
    }

    public String getValue() {
        String string;
        String string2 = this.m_service.getSelectedItem();
        StringBuffer stringBuffer = new StringBuffer(string2);
        if ((string2.equals(NETDATA) || string2.equals(TELNET)) && (string = this.m_tport.getText()).length() > 0) {
            stringBuffer.append('@');
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
            }
            n = Math.max(n, 0);
            n = Math.min(n, 65535);
            stringBuffer.append(Integer.toString(n));
        }
        return new String(stringBuffer);
    }

    public String getValidValues() {
        return VALID;
    }

    public boolean equalsField(Object object) {
        if (object != null) {
            String string = object.toString();
            String string2 = this.getValue();
            return string2.equalsIgnoreCase(string);
        }
        return false;
    }

    public boolean isValueValid() {
        block3: {
            String string;
            String string2 = this.m_service.getSelectedItem();
            if (!string2.equals(NETDATA) && !string2.equals(TELNET) || (string = this.m_tport.getText()).length() <= 0) break block3;
            int n = 0;
            try {
                n = Integer.parseInt(string);
                if (n < 0 || n > 65535) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
            }
        }
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void notifyListener() {
        if (this.m_listener != null) {
            LEFormLineEvent lEFormLineEvent = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(lEFormLineEvent);
        }
    }
}

