/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEDBNetUser
extends LEConfig {
    public static final String LOCATION = "368";
    public static final String PASSWORD = "password";
    public static final String IDLE_TIMEOUT = "129";
    public static final String SESSION_LIMIT = "371";
    public static final int KEY_COUNT = 4;
    static String[] s_keys = null;
    String m_name;
    String m_tag;
    boolean m_passwordFetched = false;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[4];
            int i = 0;
            LEDBNetUser.s_keys[i++] = LOCATION;
            LEDBNetUser.s_keys[i++] = PASSWORD;
            LEDBNetUser.s_keys[i++] = IDLE_TIMEOUT;
            LEDBNetUser.s_keys[i++] = SESSION_LIMIT;
        }
        return s_keys;
    }

    public LEDBNetUser(LEConnectionFacade facade, String name) {
        super(facade);
        this.m_name = name;
        this.m_tag = "user " + this.m_name;
    }

    public Object clone() {
        LEDBNetUser config = new LEDBNetUser(this.m_facade, this.m_name);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    void setPassword(String password) {
        this.m_passwordFetched = true;
        this.setField(PASSWORD, password);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(LOCATION)) {
            this.makeSetCommand(cmds, this.m_tag, LOCATION, "dialback");
        }
        if (allCmds || keys.contains(IDLE_TIMEOUT)) {
            this.makeSetCommand(cmds, this.m_tag, IDLE_TIMEOUT, "idle");
        }
        if (allCmds || keys.contains(SESSION_LIMIT)) {
            this.makeSetCommand(cmds, this.m_tag, SESSION_LIMIT, "session-limit");
        }
        if (allCmds && this.m_passwordFetched) {
            this.makeSetCommand(cmds, this.m_tag, PASSWORD, PASSWORD);
            this.clearField(PASSWORD);
            this.m_passwordFetched = false;
        } else if (!allCmds && keys.contains(PASSWORD)) {
            this.makeSetCommand(cmds, this.m_tag, PASSWORD, PASSWORD);
            this.clearField(PASSWORD);
            this.m_passwordFetched = false;
        }
        return cmds.size() > start;
    }
}

