/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEIPRange;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEIPRanges
extends LETable {
    String m_pool;

    public LEIPRanges(LEConnectionFacade facade, String pool) {
        super(facade);
        this.m_pool = pool;
    }

    public Object clone() {
        LEIPRanges config = new LEIPRanges(this.m_facade, this.m_pool);
        config.copy(this);
        return config;
    }

    public String getPool() {
        return this.m_pool;
    }

    public LEVector add(String range, String mask, String gateway) {
        LEPMCommand ret;
        LEVector errors = null;
        StringBuffer buf = new StringBuffer();
        buf.append("set ippool ");
        buf.append(this.m_pool);
        buf.append(" address-range ");
        buf.append(range);
        buf.append("/");
        buf.append(mask);
        if (!gateway.equals("")) {
            buf.append(" ");
            buf.append(gateway);
        }
        if ((ret = this.m_facade.execute(buf.toString())).getStatus()) {
            ret = this.m_facade.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String range) {
        LEVector errors = null;
        StringBuffer buf = new StringBuffer();
        buf.append("delete ippool ");
        buf.append(this.m_pool);
        buf.append(" address-range ");
        buf.append(range);
        LEPMCommand ret = this.m_facade.execute(buf.toString());
        if (ret.getStatus()) {
            this.remove(range);
            ret = this.m_facade.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public void clear() {
        this.m_fields.clear();
        this.setChanged();
        this.notifyObservers();
    }

    boolean getChangedCommands(LEVector cmds) {
        int start = cmds.size();
        boolean gen = super.getChangedCommands(cmds);
        if (gen) {
            this.removeResets(cmds, start);
        }
        return gen;
    }

    boolean getAllCommands(LEVector cmds) {
        int start = cmds.size();
        boolean gen = super.getAllCommands(cmds);
        if (gen) {
            this.removeResets(cmds, start);
        }
        return gen;
    }

    void removeResets(LEVector cmds, int start) {
        int end = cmds.size();
        int reboot = -1;
        int i = start;
        while (i < end) {
            String cmd = (String)cmds.elementAt(i);
            if (cmd.equals("reset ippool")) {
                if (reboot > 0) {
                    cmds.removeElementAt(reboot);
                    --end;
                }
                reboot = --i;
            }
            ++i;
        }
    }

    LEConfig createConfig(String key) {
        return new LEIPRange(this.m_facade, this.m_pool, key);
    }
}

