/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEFilterRule;
import com.lucent.ra.nms.util.LEVector;

public class LEIPRule
extends LEFilterRule {
    public static final String ACTION = "action";
    public static final String DEST_COMPARE = "dst_cmp";
    public static final String DEST_PORT = "dst_port";
    public static final String DESTINATION = "destination";
    public static final String ESTABLISH = "estab";
    public static final String LOG = "log";
    public static final String NOTIFY = "notify";
    public static final String PROTOCOL = "protocol";
    public static final String PROTOCOL_NUM = "protocol_number";
    public static final String SOURCE = "source";
    public static final String SRC_COMPARE = "src_cmp";
    public static final String SRC_PORT = "src_port";
    public static final String TYPE = "type";
    public static final int KEY_COUNT = 13;
    public static final String DENY = "deny";
    public static final String PERMIT = "permit";
    public static final String COMPARE_EQ = "eq";
    public static final String COMPARE_GT = "gt";
    public static final String COMPARE_LT = "lt";
    public static final String PROTOCOL_IP = "ip";
    public static final String PROTOCOL_ICMP = "icmp";
    public static final String PROTOCOL_IPIP = "ipip";
    public static final String PROTOCOL_TCP = "tcp";
    public static final String PROTOCOL_UDP = "udp";
    public static final String PROTOCOL_ESP = "esp";
    public static final String PROTOCOL_AH = "ah";
    public static final String PROTOCOL_PROTO = "protocol";
    static final String DEFAULT_ADDR = "0.0.0.0/0";
    static final String DEFAULT_PORT = "0";
    static final String DEFAULT_TYPE = "0";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[13];
            LEIPRule.s_keys[0] = ACTION;
            LEIPRule.s_keys[1] = DEST_COMPARE;
            LEIPRule.s_keys[2] = DEST_PORT;
            LEIPRule.s_keys[3] = DESTINATION;
            LEIPRule.s_keys[4] = ESTABLISH;
            LEIPRule.s_keys[5] = LOG;
            LEIPRule.s_keys[6] = NOTIFY;
            LEIPRule.s_keys[7] = "protocol";
            LEIPRule.s_keys[8] = PROTOCOL_NUM;
            LEIPRule.s_keys[9] = SOURCE;
            LEIPRule.s_keys[10] = SRC_COMPARE;
            LEIPRule.s_keys[11] = SRC_PORT;
            LEIPRule.s_keys[12] = TYPE;
        }
        return s_keys;
    }

    public LEIPRule(LEConnectionFacade facade, String name, String number) {
        super(facade, name, number);
    }

    public void initialize(String action) {
        this.setField(ACTION, action);
        this.setField(DEST_COMPARE, "");
        this.setField(DEST_PORT, "0");
        this.setField(DESTINATION, DEFAULT_ADDR);
        this.setField(ESTABLISH, "off");
        this.setField(LOG, "off");
        this.setField(NOTIFY, "off");
        this.setField("protocol", PROTOCOL_IP);
        this.setField(PROTOCOL_NUM, "0");
        this.setField(SOURCE, DEFAULT_ADDR);
        this.setField(SRC_COMPARE, "");
        this.setField(SRC_PORT, "0");
        this.setField(TYPE, "");
    }

    public Object clone() {
        LEIPRule config = new LEIPRule(this.m_facade, this.m_name, this.m_number);
        config.copy(this);
        return config;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String notify;
        String log;
        String protocol;
        String action = (String)this.get(ACTION);
        if (this.m_name == null || this.m_number == null || action == null) {
            return false;
        }
        StringBuffer buf = new StringBuffer("set ");
        buf.append("filter ");
        buf.append(this.m_name);
        buf.append(" ");
        buf.append(this.m_number);
        buf.append(" ");
        buf.append(action);
        String src = (String)this.get(SOURCE);
        String dst = (String)this.get(DESTINATION);
        if (src != null && src.length() > 0 && dst != null && dst.length() > 0) {
            buf.append(" ");
            buf.append(src);
            buf.append(" ");
            buf.append(dst);
        }
        if ((protocol = (String)this.get("protocol")) != null) {
            if (protocol.equals(PROTOCOL_IP) || protocol.equals(PROTOCOL_TCP) || protocol.equals(PROTOCOL_UDP)) {
                String est;
                if (protocol.equals(PROTOCOL_TCP)) {
                    buf.append(" tcp");
                } else if (protocol.equals(PROTOCOL_UDP)) {
                    buf.append(" udp");
                }
                String cmp = (String)this.get(SRC_COMPARE);
                String port = (String)this.get(SRC_PORT);
                if (cmp != null && cmp.length() > 0 && port != null && port.length() > 0) {
                    buf.append(" src ");
                    buf.append(cmp);
                    buf.append(" ");
                    buf.append(port);
                }
                cmp = (String)this.get(DEST_COMPARE);
                port = (String)this.get(DEST_PORT);
                if (cmp != null && cmp.length() > 0 && port != null && port.length() > 0) {
                    buf.append(" dst ");
                    buf.append(cmp);
                    buf.append(" ");
                    buf.append(port);
                }
                if (protocol.equals(PROTOCOL_TCP) && (est = (String)this.get(ESTABLISH)) != null && est.equals("on")) {
                    buf.append(" established");
                }
            } else if (protocol.equals(PROTOCOL_ICMP)) {
                buf.append(" icmp");
                String type = (String)this.get(TYPE);
                if (type != null && type.length() > 0) {
                    buf.append(" type ");
                    buf.append(type);
                }
            } else if (protocol.equals("protocol")) {
                String num = (String)this.get(PROTOCOL_NUM);
                if (num != null && num.length() > 0) {
                    buf.append(" protocol ");
                    buf.append(num);
                }
            } else if (protocol.equals(PROTOCOL_ESP)) {
                buf.append(" esp");
            } else if (protocol.equals(PROTOCOL_AH)) {
                buf.append(" ah");
            } else if (protocol.equals(PROTOCOL_IPIP)) {
                buf.append(" ipip");
            }
        }
        if ((log = (String)this.get(LOG)) != null && log.equals("on")) {
            buf.append(" log");
        }
        if ((notify = (String)this.get(NOTIFY)) != null && notify.equals("on")) {
            buf.append(" notify");
        }
        cmds.addElement(new String(buf));
        return true;
    }
}

