/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEIPSecSA;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEIPSecSAs
extends LETable {
    public LEIPSecSAs(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LEIPSecSAs config = new LEIPSecSAs(this.m_facade);
        config.copy(this);
        return config;
    }

    public LEVector add(String name) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("sa", name);
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (ret.getStatus()) {
            cmd = this.makeSetCommand("sa", name, "mode", "sec-ipip-tunnel");
            ret = this.m_facade.execute(cmd);
        }
        if (ret.getStatus()) {
            ret = this.m_facade.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("sa", name);
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_facade.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LEIPSecSA(this.m_facade, key);
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeAddCommand("sa", key));
        return true;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeDeleteCommand("sa", key));
        return true;
    }
}

