/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LELogFacility_R;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.util.LEVector;
import java.rmi.RemoteException;
import java.util.Enumeration;

public class LELogFacility
implements LEAMObserver {
    LEVector m_logReq = new LEVector();
    LEPMConnectionFacade m_facade;
    LELogFacility_R m_facility;

    public LELogFacility(LEPMConnectionFacade facade, LELogFacility_R facility, String id) {
        this.m_facade = facade;
        this.m_facility = facility;
        LEStatusFactory.GetFactory().addObserver(id, this);
    }

    public boolean startLog(int entity) {
        boolean success = false;
        LELogFacility lELogFacility = this;
        synchronized (lELogFacility) {
            this.m_logReq.addUnique(new Integer(entity));
        }
        try {
            if (this.m_facility != null) {
                success = this.m_facility.startLog(entity);
            }
        }
        catch (RemoteException e) {
            this.m_facade.handleRemoteException(e);
            success = false;
        }
        return success;
    }

    public void stopLog() {
        this.m_logReq.removeAllElements();
        try {
            if (this.m_facility != null) {
                this.m_facility.stopLog();
            }
        }
        catch (RemoteException e) {
            this.m_facade.handleRemoteException(e);
        }
    }

    public void reconnect() {
        LEDSSPortMaster dss = (LEDSSPortMaster)this.m_facade.getDSS();
        this.m_facility = dss != null ? dss.getLogFacility() : null;
        if (this.m_facility == null) {
            return;
        }
        try {
            Enumeration enumeration = this.m_logReq.elements();
            while (enumeration.hasMoreElements()) {
                Integer entity = (Integer)enumeration.nextElement();
                this.m_facility.startLog(entity);
            }
        }
        catch (RemoteException e) {
            this.m_facade.handleRemoteException(e);
        }
    }

    public void lostConnection() {
        this.m_facility = null;
    }

    public void update(LEAMFactory factory, String id, Object obj) {
        int status;
        if (obj instanceof LEStatusMessage && (status = ((LEStatusMessage)obj).getStatus()) == 1) {
            this.reconnect();
        }
    }
}

