/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LENATMapRule
extends LEConfig {
    public static final String LHS = "lhs";
    public static final String LOG = "log";
    public static final String RHS = "rhs";
    public static final String TYPE = "type";
    public static final int KEY_COUNT = 4;
    public static final String ADDR_MAP = "addrmap";
    public static final String STATIC_ADDR_MAP = "staticaddrmap";
    public static final String STATIC_TUPORT_MAP = "statictuportmap";
    static String[] s_keys = null;
    String m_name;
    String m_number;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[4];
            int i = 0;
            LENATMapRule.s_keys[i++] = LHS;
            LENATMapRule.s_keys[i++] = LOG;
            LENATMapRule.s_keys[i++] = RHS;
            LENATMapRule.s_keys[i++] = TYPE;
        }
        return s_keys;
    }

    public LENATMapRule(LEConnectionFacade facade, String name, String number) {
        super(facade);
        this.m_name = name;
        this.m_number = number;
    }

    public Object clone() {
        LENATMapRule config = new LENATMapRule(this.m_facade, this.m_name, this.m_number);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String type = (String)this.get(TYPE);
        String lhs = (String)this.get(LHS);
        String rhs = (String)this.get(RHS);
        String log = (String)this.get(LOG);
        if (this.m_name == null || this.m_number == null || type == null || lhs == null || rhs == null) {
            return false;
        }
        StringBuffer buf = new StringBuffer("set ");
        buf.append("map ");
        buf.append(this.m_name);
        buf.append(" ");
        buf.append(this.m_number);
        buf.append(" ");
        buf.append(type);
        buf.append(" ");
        buf.append(lhs);
        buf.append(" ");
        buf.append(rhs);
        if (log != null && log.equals("on")) {
            buf.append(" log");
        }
        cmds.addElement(new String(buf));
        return true;
    }
}

