/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEOSPFArea;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEOSPFAreas
extends LETable {
    public LEOSPFAreas(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LEOSPFAreas config = new LEOSPFAreas(this.m_facade);
        config.copy(this);
        return config;
    }

    public LEVector add(String area) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("ospf area", area);
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (ret.getStatus()) {
            ret = this.m_facade.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String area) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("ospf area", area);
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (ret.getStatus()) {
            this.remove(area);
            ret = this.m_facade.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LEOSPFArea(this.m_facade, key);
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeAddCommand("ospf area", key));
        return true;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeDeleteCommand("ospf area", key));
        return true;
    }

    boolean getChangedCommands(LEVector cmds) {
        int start = cmds.size();
        boolean gen = super.getChangedCommands(cmds);
        if (gen) {
            this.checkCommands(cmds, start);
        }
        return gen;
    }

    boolean getAllCommands(LEVector cmds) {
        int start = cmds.size();
        boolean gen = super.getAllCommands(cmds);
        if (gen) {
            this.checkCommands(cmds, start);
        }
        return gen;
    }

    void checkCommands(LEVector cmds, int start) {
        int end = cmds.size();
        int reset = -1;
        int save = -1;
        int i = start;
        while (i < end) {
            String cmd = (String)cmds.elementAt(i);
            if (cmd.equals("reset ospf")) {
                if (reset > 0) {
                    cmds.removeElementAt(reset);
                    --end;
                    --save;
                }
                reset = --i;
            } else if (cmd.equals("save all")) {
                save = i;
            }
            ++i;
        }
    }
}

