/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMManager_RI;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEAlarmFacility_R;
import com.lucent.ra.nms.backend.LEAsyncCmdFacility_R;
import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.backend.LEDSS;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LEDebugFacility_R;
import com.lucent.ra.nms.backend.LELogFacility_R;
import com.lucent.ra.nms.backend.LEMonitorFacility_R;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.backend.LEUserAuthenticationMessage;
import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEBoards;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LELogFacility;
import com.lucent.ra.nms.model.LEMonitorFacility;
import com.lucent.ra.nms.model.LEPMEntityParser;
import com.lucent.ra.nms.model.LEPMOldParser;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEStatusManager;
import com.lucent.ra.nms.util.LEVector;
import java.rmi.RemoteException;

public class LEPMConnectionFacade
implements LEConnectionFacade,
LEAMObserver,
Runnable {
    public static final int NO_BOARD = -1;
    public static final String NO_GROUP = LEMonitorFacility.NO_GROUP;
    private static final String CONSOLE_ON = "set console on";
    private static final String CONSOLE_OFF = "reset console";
    private static final String COMOS_NO_DEBUG = "ComOS 4.0";
    LEConnectionManager m_cm;
    LEDSSPortMaster m_dss;
    LEPortMaster m_pm;
    LEMonitorFacility m_monitor;
    LELogFacility m_log;
    Thread m_thread;
    boolean m_disconnected;
    LEVector m_toc;
    String m_host;
    String m_user;
    String m_pw;
    String m_id;

    public LEPMConnectionFacade(LEConnectionManager cm, LEDSSPortMaster dss, LEPortMaster pm) {
        this.m_cm = cm;
        this.m_dss = dss;
        this.m_pm = pm;
        this.m_host = this.m_dss.getHostname();
        this.m_user = this.m_dss.getUsername();
        this.m_pw = this.m_dss.getPassword();
        this.m_id = this.m_dss.getResourceID();
        LEStatusFactory.GetFactory().addObserver(cm.getResourceID(), this);
    }

    public void update(LEAMFactory factory, String id, Object data) {
        if (data instanceof LEStatusMessage) {
            LEStatusMessage msg = (LEStatusMessage)data;
            int status = msg.getStatus();
            if (status == 1 && !this.m_disconnected) {
                this.m_cm = (LEConnectionManager)msg.getData();
                try {
                    this.m_dss = null;
                    this.m_dss = this.m_cm.connectToPM(this.m_host, this.m_user, this.m_pw);
                    if (this.m_monitor != null) {
                        this.getMonitor();
                    }
                }
                catch (Exception e) {
                    LEDebug.getLog().logln(20, e);
                }
            } else if (status == 2) {
                this.lostConnection();
            }
        }
    }

    public LEConnectionManager getConnectionManager() {
        return this.m_cm;
    }

    public LEDSS getDSS() {
        return this.m_dss;
    }

    public String getResourceID() {
        return this.m_id;
    }

    public String getDescription() {
        return this.m_host;
    }

    public String getHostname() {
        return this.m_host;
    }

    public String getUsername() {
        return this.m_user;
    }

    public String getPassword() {
        return this.m_pw;
    }

    public boolean getConfig(String key) {
        return this.getConfig(key, null);
    }

    public boolean getConfig(String key, String board_id) {
        if (this.m_dss == null) {
            return false;
        }
        boolean success = false;
        if (board_id == null) {
            if (this.m_dss.supportsEntities() && (!key.equals("2162688") || this.globalEntityOkay())) {
                success = LEPMEntityParser.Parse(key, this.m_dss, this.m_pm);
            }
            if (!success) {
                success = LEPMOldParser.Parse(key, this.m_dss, this.m_pm);
            }
        } else if (this.m_dss.supportsEntities()) {
            success = LEPMEntityParser.Parse(key, board_id, this.m_dss, this.m_pm);
        }
        return success;
    }

    public LEVector getTOC(int entity) {
        if (this.m_dss == null) {
            return null;
        }
        return this.m_dss.getTOC(entity);
    }

    public boolean getUserPasswords() {
        if (this.m_dss == null) {
            return false;
        }
        if (!this.supports(0x310000)) {
            return false;
        }
        LEConfig config = (LEConfig)this.m_pm.get("1835008");
        if (config == null) {
            return true;
        }
        String send = Integer.toString(0x310000);
        return LEPMEntityParser.Parse(this.m_dss, config, send, send);
    }

    public boolean getSecrets() {
        if (this.m_dss == null) {
            return false;
        }
        if (!this.supports(0x320000)) {
            return false;
        }
        this.m_pm.get("2228224");
        this.m_pm.get("1507328");
        String send = Integer.toString(0x320000);
        return LEPMEntityParser.Parse(this.m_dss, this.m_pm, send, send);
    }

    public boolean supportsEntities() {
        if (this.m_dss == null) {
            return false;
        }
        return this.m_dss.supportsEntities();
    }

    public boolean supports(int entity) {
        if (this.isConnected()) {
            if (this.m_toc == null) {
                this.m_toc = this.getTOC(0x1D0000);
            }
            if (this.m_toc != null && this.m_toc.contains(Integer.toString(entity))) {
                return true;
            }
        }
        return false;
    }

    public boolean supportsSMM() {
        LEPMCommand ret;
        return this.supportsEntities() && (ret = this.execute("set view global")) != null && ret.getStatus();
    }

    public boolean isUpgrading() {
        if (this.m_dss == null) {
            return false;
        }
        return this.m_dss.upgrading();
    }

    public boolean isEstablished() {
        return this.m_cm.isConnected();
    }

    public boolean isConnected() {
        return this.m_cm.isConnected() && this.m_dss != null && this.m_dss.isConnected();
    }

    public void disconnect() {
        this.m_disconnected = true;
        if (this.m_dss != null) {
            this.m_cm.disconnectFrom(this.m_dss);
            this.m_dss = null;
        }
    }

    public synchronized boolean reconnect() {
        if (this.m_dss == null) {
            try {
                this.m_dss = this.m_cm.connectToPM(this.m_host, this.m_user, this.m_pw);
                this.m_disconnected = false;
                if (this.m_monitor != null) {
                    this.getMonitor();
                }
            }
            catch (LEDSSException lEDSSException) {
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
        } else if (!this.m_dss.isConnected()) {
            LEAMManager_RI.GetManager().addID(this.m_cm.getAMRouter(), this.m_id);
            boolean success = false;
            try {
                success = this.m_dss.reconnect();
            }
            catch (Exception exception) {}
            if (!success) {
                this.m_dss = null;
                LEAMManager_RI.GetManager().removeID(this.m_cm.getAMRouter(), this.m_id);
            } else {
                this.m_disconnected = false;
            }
        }
        return this.m_dss != null;
    }

    public LEPMCommand execute(String command) {
        LEPMCommand ret;
        block9: {
            if (this.m_dss == null) {
                return null;
            }
            LEStatusManager.SetStatus(command);
            ret = this.m_dss.execute(command);
            if (this.m_dss != null) {
                this.m_pw = this.m_dss.getPassword();
            }
            if (LEPMCommand.IsReboot(command)) {
                this.m_pm.rebooted(this);
            }
            if (LEPMCommand.IsPowerOff(command)) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    LEDebug.getLog().logln(20, e);
                }
            }
            if (LEPMCommand.IsPowerOn(command) && this.m_thread == null) {
                this.m_thread = new Thread(this);
                this.m_thread.start();
            }
            if (!command.startsWith("set bgp id ")) break block9;
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
        }
        return ret;
    }

    public boolean startAsync(int entity, int board, String cmd) {
        if (this.m_dss == null) {
            return false;
        }
        boolean ret = false;
        try {
            LEAsyncCmdFacility_R facility = this.m_dss.getAsyncFacility();
            if (facility != null) {
                ret = facility.startAsync(entity, board, cmd);
            }
        }
        catch (RemoteException remoteException) {}
        return ret;
    }

    public void stopAsync(int entity, int board, String cmd) {
        if (this.m_dss == null) {
            return;
        }
        try {
            LEAsyncCmdFacility_R facility = this.m_dss.getAsyncFacility();
            if (facility != null) {
                facility.stopAsync(entity, board, cmd);
            }
        }
        catch (RemoteException remoteException) {}
    }

    public boolean startMonitor(int entity, int board) {
        return this.startMonitor(entity, board, LEMonitorFacility.NO_GROUP, LEMonitorFacility.NO_START, LEMonitorFacility.NO_END, 60000);
    }

    public boolean startMonitor(int entity, String group) {
        return this.startMonitor(entity, -1, group, LEMonitorFacility.NO_START, LEMonitorFacility.NO_END, 60000);
    }

    public boolean startMonitor(int entity, int board, String group, int interval) {
        if (this.m_dss == null) {
            return false;
        }
        if (this.m_monitor == null) {
            this.getMonitor();
        }
        if (this.m_monitor == null) {
            return false;
        }
        return this.startMonitor(entity, board, group, LEMonitorFacility.NO_START, LEMonitorFacility.NO_END, interval);
    }

    public boolean startMonitor(int entity, int board, String group, String start, String end, int interval) {
        if (this.m_dss == null) {
            return false;
        }
        if (this.m_monitor == null) {
            this.getMonitor();
        }
        if (this.m_monitor == null) {
            return false;
        }
        return this.m_monitor.startMonitor(entity, board, group, start, end, interval);
    }

    public void stopMonitor(int entity, int board) {
        this.stopMonitor(entity, board, LEMonitorFacility.NO_GROUP, LEMonitorFacility.NO_START, LEMonitorFacility.NO_END, 60000);
    }

    public void stopMonitor(int entity, String group) {
        this.stopMonitor(entity, -1, group, LEMonitorFacility.NO_START, LEMonitorFacility.NO_END, 60000);
    }

    public void stopMonitor(int entity, int board, String group, int interval) {
        if (this.m_monitor == null) {
            return;
        }
        this.stopMonitor(entity, board, group, LEMonitorFacility.NO_START, LEMonitorFacility.NO_END, interval);
    }

    public void stopMonitor(int entity, int board, String group, String start, String end, int interval) {
        if (this.m_monitor == null) {
            return;
        }
        this.m_monitor.stopMonitor(entity, board, group, start, end, interval);
    }

    public boolean startDelta(int entity, int board) {
        return false;
    }

    public void stopDelta(int entity, int board) {
    }

    public boolean startDebug(int entity, int debug, int board) {
        String software;
        if (this.m_dss == null) {
            return false;
        }
        boolean ret = false;
        try {
            LEDebugFacility_R facility = this.m_dss.getDebugFacility();
            if (facility != null) {
                ret = facility.startDebug(entity, debug, board);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        if (ret && (software = this.m_pm.getSoftwareVersion()).indexOf(COMOS_NO_DEBUG) > -1) {
            this.m_dss.execute(CONSOLE_ON);
        }
        return ret;
    }

    public void stopDebug(int entity, int debug, int board) {
        String software;
        if (this.m_dss == null) {
            return;
        }
        try {
            LEDebugFacility_R facility = this.m_dss.getDebugFacility();
            if (facility != null) {
                facility.stopDebug(entity, debug, board);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        if ((software = this.m_pm.getSoftwareVersion()).indexOf(COMOS_NO_DEBUG) > -1) {
            this.m_dss.execute(CONSOLE_OFF);
        }
    }

    public LEVector getAlarms() {
        if (this.m_dss == null) {
            return null;
        }
        LEVector ret = null;
        try {
            LEAlarmFacility_R facility = this.m_dss.getAlarmFacility();
            if (facility != null) {
                ret = facility.getAlarms();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public boolean clearAlarm(String id) {
        if (this.m_dss == null) {
            return false;
        }
        boolean ret = false;
        try {
            LEAlarmFacility_R facility = this.m_dss.getAlarmFacility();
            if (facility != null) {
                ret = facility.clearAlarm(id);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public boolean startLog(int entity) {
        if (this.m_dss == null) {
            return false;
        }
        if (this.m_log == null) {
            this.getLogFacility();
        }
        if (this.m_log == null) {
            return false;
        }
        return this.m_log.startLog(entity);
    }

    public void stopLog() {
        if (this.m_log == null) {
            return;
        }
        this.m_log.stopLog();
    }

    public LEUserAuthenticationMessage userAuthenticate(String username, String password) {
        if (this.m_dss == null) {
            return null;
        }
        return this.m_dss.userAuthenticate(username, password);
    }

    public void run() {
        try {
            this.checkForBoards();
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        this.m_thread = null;
    }

    void checkForBoards() {
        LEDebug.getLog().logln(40, "Checking Boards");
        if (this.m_dss == null || !this.m_dss.isConnected()) {
            LEDebug.getLog().logln(40, "checkForBoards: no connection");
            return;
        }
        LEBoards boards = (LEBoards)this.m_pm.get("2555904");
        if (boards == null) {
            LEDebug.getLog().logln(40, "checkForBoards: no boards");
            return;
        }
        LEStatusManager.SetStatus("Checking boards");
        boolean count = false;
        boolean wait = true;
        while (wait) {
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
            wait = false;
            if (this.m_dss != null && this.m_dss.isConnected()) {
                String msg;
                boards.refresh();
                LEVector keys = boards.getKeys();
                int len = keys.size();
                if (LEDebug.getLog().shouldLog(40)) {
                    LEDebug.getLog().logln(40, "Boards: " + keys.toString());
                }
                if (keys.contains("10")) {
                    int i = 0;
                    while (!wait && i < len) {
                        String id = (String)keys.elementAt(i);
                        LEBoard board = (LEBoard)boards.get(id);
                        if (board != null && board.isPoweringUp()) {
                            msg = "Waiting on board " + id;
                            LEStatusManager.SetStatus(msg);
                            LEDebug.getLog().logln(40, msg);
                            wait = true;
                        }
                        ++i;
                    }
                    continue;
                }
                msg = "Waiting on board 10";
                LEStatusManager.SetStatus(msg);
                LEDebug.getLog().logln(40, msg);
                wait = true;
                continue;
            }
            LEDebug.getLog().logln(40, "checkForBoards: connection lost");
        }
        if (this.m_dss != null && this.m_dss.isConnected()) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
                boards.refresh();
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
        }
        LEDebug.getLog().logln(40, "Checking Boards - done");
    }

    boolean globalEntityOkay() {
        boolean okay;
        block4: {
            okay = true;
            String ver = this.m_pm.getSoftwareVersion();
            if (!ver.startsWith("3.8b")) break block4;
            String sub = ver.substring(4);
            int index = sub.indexOf(47);
            if (index > -1) {
                sub = sub.substring(0, index);
            }
            try {
                int rel = Integer.parseInt(sub);
                if (rel < 18) {
                    okay = false;
                }
            }
            catch (NumberFormatException e) {
                LEDebug.getLog().logln(20, e);
            }
        }
        return okay;
    }

    void getMonitor() {
        LEMonitorFacility_R facility = this.m_dss.getMonitorFacility();
        if (facility != null) {
            if (this.m_monitor == null) {
                this.m_monitor = new LEMonitorFacility(this, facility, this.m_id);
            } else {
                this.m_monitor.reconnect();
            }
        }
    }

    void getLogFacility() {
        LELogFacility_R facility = this.m_dss.getLogFacility();
        if (facility != null) {
            if (this.m_log == null) {
                this.m_log = new LELogFacility(this, facility, this.m_id);
            } else {
                this.m_log.reconnect();
            }
        }
    }

    void handleRemoteException(RemoteException e) {
        LEDebug.getLog().logln(20, e);
        this.m_dss = null;
        LEStatusMessage msg = new LEStatusMessage(2);
        LEAMManager_RI.Process(this.m_cm.getResourceID(), "STATUS", msg);
    }

    void lostConnection() {
        this.m_dss = null;
        if (this.m_monitor != null) {
            this.m_monitor.lostConnection();
        }
    }
}

