/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPVC;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEPVCs
extends LETable {
    public LEPVCs(LEConnectionFacade facade, String board, String key) {
        super(facade, board, key);
    }

    public LEPVCs(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LEPVCs config = new LEPVCs(this.m_facade, this.m_board, this.m_fetchKey);
        config.copy(this);
        return config;
    }

    public LEVector add(String name) {
        LEVector errors = null;
        String cmd = "set view " + this.m_board;
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        } else {
            cmd = this.makeAddCommand("pvc", name);
            ret = this.m_facade.execute(cmd);
            if (ret.getStatus()) {
                cmd = this.m_smm ? "set view global" : "set view 4";
                this.m_facade.execute(cmd);
                ret = this.m_facade.execute("save all");
                if (!ret.getStatus()) {
                    errors = new LEVector();
                    errors.addElement(ret);
                }
                this.refresh();
            } else {
                errors = new LEVector();
                errors.addElement(ret);
            }
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = "set view " + this.m_board;
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        } else {
            cmd = this.makeDeleteCommand("pvc", name);
            ret = this.m_facade.execute(cmd);
            if (ret.getStatus()) {
                this.remove(name);
                cmd = this.m_smm ? "set view global" : "set view 4";
                this.m_facade.execute(cmd);
                ret = this.m_facade.execute("save all");
                if (!ret.getStatus()) {
                    this.refresh();
                }
            }
            if (!ret.getStatus()) {
                errors = new LEVector();
                errors.addElement(ret);
            }
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LEPVC(this.m_facade, this.m_board, key);
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeAddCommand("pvc", key));
        return true;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeDeleteCommand("pvc", key));
        return true;
    }
}

