/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.ui.LEPathEvent;
import com.lucent.ra.nms.ui.LEPathItem;
import com.lucent.ra.nms.ui.LEPathListener;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class LEPathBar
extends Canvas
implements MouseListener {
    static final int SPACE = 2;
    static final int LINE = 10;
    static final int BUF = 3;
    LEPathItem[] m_path;
    int m_thickness = 2;
    int m_border = 2;
    Font m_bold;
    boolean m_disabled;
    Vector m_listeners = new Vector();

    public LEPathBar() {
        this.addMouseListener(this);
    }

    public LEPathBar(LEPathItem[] lEPathItemArray) {
        this();
        this.m_path = lEPathItemArray;
    }

    public LEPathBar(int n) {
        this();
        this.m_border = n;
    }

    public LEPathBar(LEPathItem[] lEPathItemArray, int n) {
        this();
        this.m_path = lEPathItemArray;
        this.m_border = n;
    }

    public void addNotify() {
        super.addNotify();
        Font font = this.getFont();
        this.m_bold = new Font(font.getName(), 1, font.getSize());
    }

    public void setPath(LEPathItem[] lEPathItemArray) {
        this.m_path = lEPathItemArray;
        this.repaint();
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            super.setEnabled(bl);
            this.m_disabled = false;
            this.repaint();
            return;
        }
        super.setEnabled(bl);
        this.m_disabled = true;
        this.repaint();
    }

    public synchronized Dimension getMinimumSize() {
        if (this.m_bold == null) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.m_bold);
        FontMetrics fontMetrics2 = this.getFontMetrics(this.getFont());
        int n = this.m_thickness + 2 + this.m_border + fontMetrics.getHeight() + 2;
        int n2 = 2 * this.m_border;
        if (this.m_path != null && this.m_path.length > 0) {
            n2 += fontMetrics.stringWidth(this.m_path[this.m_path.length - 1].getLabel());
            int n3 = 0;
            while (n3 < this.m_path.length - 1) {
                n2 += fontMetrics2.stringWidth(this.m_path[n3].getLabel()) + 10 + 6;
                ++n3;
            }
        }
        return new Dimension(n2, n);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Font font = graphics.getFont();
        if (this.m_bold == null) {
            this.m_bold = new Font(font.getName(), 1, font.getSize());
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        FontMetrics fontMetrics2 = graphics.getFontMetrics(this.m_bold);
        int n = fontMetrics2.getAscent() + this.m_border;
        if (this.m_disabled) {
            graphics.setColor(this.getBackground().darker());
        }
        if (this.m_path != null && this.m_path.length > 0) {
            int n2 = this.m_border;
            int n3 = fontMetrics2.getHeight() / 2 + this.m_border;
            int n4 = 0;
            while (n4 < this.m_path.length - 1) {
                graphics.drawString(this.m_path[n4].getLabel(), n2, n);
                n2 += fontMetrics.stringWidth(this.m_path[n4].getLabel());
                if (this.m_path.length > 1) {
                    graphics.drawLine(n2 += 3, n3, n2 + 10, n3);
                    n2 += 13;
                }
                ++n4;
            }
            graphics.setFont(this.m_bold);
            graphics.drawString(this.m_path[this.m_path.length - 1].getLabel(), n2, n);
            graphics.setFont(font);
        }
        if (this.m_thickness > 0) {
            graphics.fillRect(this.m_border, dimension.height - this.m_thickness - 2, dimension.width - 2 * this.m_border, this.m_thickness);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.m_disabled || this.m_path == null || this.m_path.length < 2) {
            return;
        }
        Dimension dimension = this.getSize();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n2 < dimension.height - this.m_thickness - 2) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n3 = this.m_border;
            int n4 = 0;
            while (n4 < this.m_path.length - 1) {
                if (n < (n3 += fontMetrics.stringWidth(this.m_path[n4].getLabel()))) {
                    this.notifyListeners(new LEPathEvent(1, this.m_path[n4]));
                    return;
                }
                if (n < (n3 += 16)) {
                    return;
                }
                ++n4;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void addListener(LEPathListener lEPathListener) {
        this.m_listeners.addElement(lEPathListener);
    }

    public void deleteListener(LEPathListener lEPathListener) {
        this.m_listeners.removeElement(lEPathListener);
    }

    synchronized void notifyListeners(LEPathEvent lEPathEvent) {
        int n = this.m_listeners.size();
        int n2 = 0;
        while (n2 < n) {
            LEPathListener lEPathListener = (LEPathListener)this.m_listeners.elementAt(n2);
            if (lEPathListener != null) {
                lEPathListener.onLEPathEvent(lEPathEvent);
            }
            ++n2;
        }
    }
}

