/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import oracle.ewt.lwAWT.lwText.LWTextComponent;
import oracle.ewt.timer.Periodic;

final class CursorIdler
implements Runnable {
    private static final int _IDLE_TIME = 600;
    private static CursorIdler _sCursorIdler;
    private int _referenceCount;
    private LWTextComponent _idlee;
    private Periodic _periodic = new Periodic((Runnable)this, "CursorIdler");
    private boolean _isCursorDrawn;

    private CursorIdler() {
        this.addRef();
    }

    static CursorIdler getCursorIdler() {
        if (_sCursorIdler == null) {
            _sCursorIdler = new CursorIdler();
        }
        return _sCursorIdler;
    }

    public void setIdlee(LWTextComponent lWTextComponent) {
        if (lWTextComponent != null && lWTextComponent.getSelectionStart() == lWTextComponent.getSelectionEnd()) {
            this._schedule();
        } else {
            this._periodic.cancel();
        }
        this._idlee = lWTextComponent;
    }

    public LWTextComponent getIdlee() {
        return this._idlee;
    }

    public int addRef() {
        ++this._referenceCount;
        return this._referenceCount;
    }

    public int release() {
        --this._referenceCount;
        _sCursorIdler = null;
        this._periodic.kill();
        this._periodic = null;
        return this._referenceCount;
    }

    public void run() {
        LWTextComponent lWTextComponent = this.getIdlee();
        boolean bl = this._isCursorDrawn = !this._isCursorDrawn;
        if (lWTextComponent != null && lWTextComponent.getSelectionStart() == lWTextComponent.getSelectionEnd()) {
            if (this._isCursorDrawn) {
                lWTextComponent.paintSelection();
                return;
            }
            lWTextComponent.eraseSelection();
        }
    }

    public void schedule(LWTextComponent lWTextComponent) {
        LWTextComponent lWTextComponent2 = this.getIdlee();
        if (lWTextComponent2 == null || lWTextComponent2 == lWTextComponent) {
            if (lWTextComponent2 == null) {
                this.setIdlee(lWTextComponent);
            }
            this._schedule();
        }
    }

    public void cancel(LWTextComponent lWTextComponent) {
        if (this.getIdlee() == lWTextComponent) {
            this.setIdlee(null);
        }
    }

    private void _schedule() {
        this._periodic.schedule(600L);
        this._isCursorDrawn = true;
    }
}

