/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicWindow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.toolBar.ToolBar;
import oracle.help.HelpBook;
import oracle.help.context.GlobalContext;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.navigator.CharsetEvent;
import oracle.help.navigator.CharsetListener;
import oracle.help.navigator.OptionsDialog;
import oracle.help.topicWindow.TopicWindowMenuBar;
import oracle.help.topicWindow.TopicWindowPanel;
import oracle.help.util.WindowManager;

public class TopicWindow
extends BufferedFrame
implements ActionListener,
CharsetListener {
    protected TopicWindowMenuBar _twMenubar;
    protected TopicWindowPanel _twPanel;
    protected ToolBar _toolbar;
    protected WindowManager _manager;
    protected GlobalContext _context;

    public TopicWindow(WindowManager windowManager, HTMLBrowser hTMLBrowser) {
        this(windowManager, null, hTMLBrowser);
    }

    public TopicWindow(WindowManager windowManager, TopicWindowPanel topicWindowPanel) {
        this(windowManager, topicWindowPanel, null);
    }

    public TopicWindow(WindowManager windowManager, TopicWindowPanel topicWindowPanel, HTMLBrowser hTMLBrowser) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Generic", Locale.getDefault());
        this.setTitle(resourceBundle.getString("topicwin.title"));
        ((Component)this).setBackground(Color.lightGray);
        this._twMenubar = new TopicWindowMenuBar(this);
        this.setMenuBar(this._twMenubar);
        this._twMenubar.setEnableAll(false);
        if (topicWindowPanel == null) {
            this._twPanel = new TopicWindowPanel(this, hTMLBrowser);
        } else {
            this._twPanel = topicWindowPanel;
            this._twPanel.setDocked(false, this);
        }
        this._twPanel.setSyncGoMenu(this._twMenubar);
        this.add((Component)this._twPanel, "Center");
        this._manager = windowManager;
        this._context = windowManager.getContext();
        Dimension dimension = TopicWindow.getInitialSize();
        ((Component)this).setSize(dimension.width, dimension.height);
        this.enableEvents(64L);
    }

    public static Dimension getInitialSize() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Defaults");
        String string = resourceBundle.getString("topicwin.width");
        String string2 = resourceBundle.getString("topicwin.height");
        Dimension dimension = new Dimension(Integer.parseInt(string), Integer.parseInt(string2));
        return dimension;
    }

    public void displayUrl(URL uRL) {
        this._twPanel.displayUrl(null, uRL);
    }

    public URL getURL() {
        return this._twPanel.getURL();
    }

    public void displayUrl(HelpBook helpBook, URL uRL) {
        this._twPanel.displayUrl(helpBook, uRL);
        if (helpBook != null) {
            this.setSearchEnabled(helpBook.containsSearch());
        }
    }

    public void dockTopicWindow() {
        this.refreshNavigator();
        this._twPanel.setDocked(true, null);
        this._manager.dock(this);
    }

    public void search() {
        this._context.showSearchDialog();
    }

    public void navigator() {
        this._context.showContents();
        this.refreshNavigator();
    }

    public TopicWindowPanel getPanel() {
        return this._twPanel;
    }

    public HelpBook getBook() {
        return this._twPanel.getBook();
    }

    public void setNavigatorEnabled(boolean bl) {
        this._twMenubar.setNavigatorEnabled(bl);
        this._twPanel.setNavigatorEnabled(bl);
    }

    public void setSearchEnabled(boolean bl) {
        this._twMenubar.setSearchEnabled(bl);
        this._twPanel.setSearchEnabled(bl);
    }

    public void setDockEnabled(boolean bl) {
        this._twMenubar.setDockEnabled(bl);
        this._twPanel.setDockEnabled(bl);
    }

    public void showOptionsDialog() {
        Point point = this.getLocation();
        OptionsDialog optionsDialog = this._context.getOptionsDialog();
        optionsDialog.addCharsetListener(this);
        optionsDialog.setCharset(this._twPanel.getCharset());
        optionsDialog.setMakeDefault(false);
        ((Component)optionsDialog).setLocation(point.x + 50, point.y + 100);
        optionsDialog.show();
        optionsDialog.removeCharsetListener(this);
    }

    public void charsetChanged(CharsetEvent charsetEvent) {
        if (charsetEvent.makeDefault()) {
            this._context.setDefaultCharset(charsetEvent.getCharset());
            return;
        }
        this.setCharset(charsetEvent.getCharset());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MenuItem menuItem = (MenuItem)actionEvent.getSource();
        String string = menuItem.getActionCommand();
        if (string.equals("PrintTopic")) {
            this._twPanel.printTopic();
            return;
        }
        if (string.equals("Close")) {
            this._manager.removeWindow(this);
            return;
        }
        if (string.equals("Exit")) {
            this._context.setVisible(false);
            return;
        }
        if (!string.equals("Copy")) {
            if (string.equals("Back")) {
                this._twPanel.goBack();
                return;
            }
            if (string.equals("Forward")) {
                this._twPanel.goForward();
                return;
            }
            if (string.equals("Navigator")) {
                this._context.showNavigatorWindow();
                this.refreshNavigator();
                return;
            }
            if (string.equals("Search")) {
                this.search();
                return;
            }
            if (string.equals("Dock")) {
                this.dockTopicWindow();
                return;
            }
            if (string.equals("Preferences")) {
                this.showOptionsDialog();
            }
        }
    }

    public void refreshNavigator() {
        this._manager.setCurrentWindow(this);
    }

    public void setCharset(String string) {
        this._twPanel.setCharset(string);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            ((Component)this).setVisible(false);
            if (this._context == null) {
                System.exit(0);
            } else {
                this._context.removeWindow(this);
            }
        } else if (windowEvent.getID() == 200) {
            if (this._context != null) {
                this.setNavigatorEnabled(true);
                this.setDockEnabled(true);
            } else {
                this.setNavigatorEnabled(false);
                this.setDockEnabled(false);
            }
        } else if (windowEvent.getID() == 205 && this._context != null) {
            this.refreshNavigator();
        }
        super.processWindowEvent(windowEvent);
    }
}

