/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.backend.LEMonNetConnMessage;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Button;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class LEMonNetConnView
extends LEMonitorPanel {
    static int[] s_monitors = null;
    Button m_resetConn;

    public LEMonNetConnView() {
        this.initialize(1, 2, 5);
        this.setCellJustification(2, 2);
        this.setCellJustification(3, 2);
        this.m_resetCols = new int[2];
        this.m_resetCols[0] = 2;
        this.m_resetCols[1] = 3;
        this.m_resetConn = new Button("Reset Connection");
        this.m_buttons.add((Component)this.m_resetConn, 0);
        this.m_resetConn.addActionListener(this);
        this.m_resetConn.setEnabled(false);
    }

    public synchronized void onLEMLEvent(LEMLEvent lEMLEvent) {
        super.onLEMLEvent(lEMLEvent);
        if (lEMLEvent.getType() == 3) {
            if (this.getSelectSize() > 0) {
                this.m_resetConn.setEnabled(true);
                return;
            }
            this.m_resetConn.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_resetConn) {
            if (this.getSelectSize() == 0) {
                return;
            }
            int[] nArray = this.getSelectedRows();
            int n = 0;
            while (n < nArray.length) {
                LEPMCommand lEPMCommand;
                LEConnectionFacade lEConnectionFacade;
                LEVector lEVector = null;
                LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(nArray[n]);
                String string = lEMonitorData.getID();
                String string2 = this.getCellString(nArray[n], 1);
                String string3 = this.createResetCommand(string2);
                LEPortMaster lEPortMaster = this.getPM(string);
                if (lEPortMaster != null && (lEConnectionFacade = lEPortMaster.getConnectionFacade()) instanceof LEPMConnectionFacade && !(lEPMCommand = lEConnectionFacade.execute(string3)).getStatus()) {
                    lEVector = new LEVector();
                    lEVector.add(lEPMCommand);
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                this.deleteRow(nArray[n2] - n2);
                ++n2;
            }
            return;
        }
        super.actionPerformed(actionEvent);
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (this.m_pms == null) {
            return;
        }
        if (object instanceof LEMonNetConnMessage) {
            LEMonNetConnMessage lEMonNetConnMessage = (LEMonNetConnMessage)object;
            String string2 = lEMonNetConnMessage.getHandle();
            Integer n = this.getRow(string, string2);
            if (n == null) {
                this.createRow(string, string2, lEMonNetConnMessage);
            } else {
                this.updateRow(n, lEMonNetConnMessage);
            }
            this.repaint();
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Handle");
        objectArray[n2++] = new String("Receive Queue");
        objectArray[n2++] = new String("Send Queue");
        objectArray[n2++] = new String("Local Address");
        objectArray[n2++] = new String("Foreign Address");
        objectArray[n2++] = new String("State");
    }

    void createRow(String string, String string2, LEMonNetConnMessage lEMonNetConnMessage) {
        String[] stringArray = new String[this.getNumColumns()];
        int n = 0;
        stringArray[n++] = this.getPM(string).getDescription();
        stringArray[n++] = lEMonNetConnMessage.getHandle();
        stringArray[n++] = Long.toString(lEMonNetConnMessage.getInBytes());
        stringArray[n++] = Long.toString(lEMonNetConnMessage.getOutBytes());
        stringArray[n++] = lEMonNetConnMessage.getLocalAddress();
        stringArray[n++] = lEMonNetConnMessage.getForeignAddress();
        stringArray[n++] = lEMonNetConnMessage.getState();
        this.addRow(string, string2, stringArray);
    }

    void updateRow(int n, LEMonNetConnMessage lEMonNetConnMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellString(n, n2, lEMonitorData.getCounter(n2, lEMonNetConnMessage.getInBytes()).toString());
        this.setCellString(n, ++n2, lEMonitorData.getCounter(n2, lEMonNetConnMessage.getOutBytes()).toString());
        int n3 = ++n2;
        this.setCellString(n, n3, lEMonNetConnMessage.getLocalAddress());
        int n4 = ++n2;
        this.setCellString(n, n4, lEMonNetConnMessage.getForeignAddress());
        int n5 = ++n2;
        ++n2;
        this.setCellString(n, n5, lEMonNetConnMessage.getState());
    }

    int[] getMonitorEntities() {
        if (s_monitors == null) {
            s_monitors = new int[1];
            LEMonNetConnView.s_monitors[0] = 3670018;
        }
        return s_monitors;
    }

    String getMonitorName() {
        return "Monitor Network Connections";
    }

    String createResetCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("reset n");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

