/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.backend.LESessionSummaryMessage;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.view.LEViewEvent;
import com.lucent.ra.nms.view.LEViewSubWindow;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;

public class LESessionSummaryView
extends LEMonitorPanel {
    static int[] s_monitors = null;
    Button m_details;

    public LESessionSummaryView() {
        this.initialize(1, 2, 5);
        this.setCellJustification(1, 2);
        int n = this.getNumColumns();
        int n2 = 2;
        while (n2 < n) {
            this.setCellJustification(n2, 2);
            ++n2;
        }
        this.m_buttons.remove(this.m_reset);
        this.m_buttons.remove(this.m_restore);
        this.m_details = new Button("Details...");
        this.m_buttons.add((Component)this.m_details, 0);
        this.m_details.addActionListener(this);
        this.m_details.setEnabled(false);
    }

    public void onLEMLEvent(LEMLEvent lEMLEvent) {
        super.onLEMLEvent(lEMLEvent);
        Frame frame = LEUiUtils.getFrame(this);
        if (!(frame instanceof LEViewSubWindow) && lEMLEvent.getType() == 3) {
            int n = this.getSelectSize();
            if (n == 1) {
                this.m_details.setEnabled(true);
                return;
            }
            this.m_details.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_details) {
            int[] nArray = this.getSelectedRows();
            if (nArray.length > 0) {
                LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(nArray[0]);
                String string = this.getCellString(nArray[0], 1);
                if (string.length() == 0) {
                    string = null;
                }
                LEMonitorDetailPanel.Display(lEMonitorData.getID(), string);
                if (this.m_listener != null) {
                    LEVector lEVector = new LEVector();
                    lEVector.addElement("pm");
                    lEVector.addElement(LEControlTree.MONITOR);
                    lEVector.addElement(LEControlTree.SESSIONS);
                    LEViewEvent lEViewEvent = new LEViewEvent(3, lEVector);
                    this.m_listener.onLEViewEvent(lEViewEvent);
                    return;
                }
            }
        } else {
            if (actionEvent.getSource() == this.m_tearoff) {
                this.m_details.setEnabled(false);
                super.actionPerformed(actionEvent);
                return;
            }
            super.actionPerformed(actionEvent);
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LESessionSummaryMessage) {
            LESessionSummaryMessage lESessionSummaryMessage = (LESessionSummaryMessage)object;
            if (lESessionSummaryMessage.getTotal() == -1) {
                return;
            }
            String string2 = lESessionSummaryMessage.getBoard();
            Integer n = this.getRow(string, string2);
            if (n == null) {
                this.createRow(string, string2, lESessionSummaryMessage);
            } else {
                this.updateRow(n, lESessionSummaryMessage);
            }
            this.repaint();
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus(string, (LEStatusMessage)object);
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Board ID");
        objectArray[n2++] = new String("Total");
        objectArray[n2++] = new String("ISDN");
        objectArray[n2++] = new String("56k");
        objectArray[n2++] = new String("v34");
        objectArray[n2++] = new String("Other");
    }

    void createRow(String string, String string2, LESessionSummaryMessage lESessionSummaryMessage) {
        String[] stringArray = new String[11];
        int n = 0;
        stringArray[n++] = this.getPM(string).getDescription();
        stringArray[n++] = lESessionSummaryMessage.getBoard();
        stringArray[n++] = Integer.toString(lESessionSummaryMessage.getTotal());
        stringArray[n++] = Integer.toString(lESessionSummaryMessage.getISDNCount());
        stringArray[n++] = Integer.toString(lESessionSummaryMessage.get56KCount());
        stringArray[n++] = Integer.toString(lESessionSummaryMessage.getV34Count());
        stringArray[n++] = Integer.toString(lESessionSummaryMessage.getOtherCount());
        this.addRow(string, string2, stringArray);
    }

    void updateRow(int n, LESessionSummaryMessage lESessionSummaryMessage) {
        int n2 = 0;
        ++n2;
        int n3 = ++n2;
        this.setCellString(n, n3, Integer.toString(lESessionSummaryMessage.getTotal()));
        int n4 = ++n2;
        this.setCellString(n, n4, Integer.toString(lESessionSummaryMessage.getISDNCount()));
        int n5 = ++n2;
        this.setCellString(n, n5, Integer.toString(lESessionSummaryMessage.get56KCount()));
        int n6 = ++n2;
        this.setCellString(n, n6, Integer.toString(lESessionSummaryMessage.getV34Count()));
        int n7 = ++n2;
        ++n2;
        this.setCellString(n, n7, Integer.toString(lESessionSummaryMessage.getOtherCount()));
    }

    int[] getMonitorEntities() {
        if (s_monitors == null) {
            s_monitors = new int[1];
            LESessionSummaryView.s_monitors[0] = 0x2E0000;
        }
        return s_monitors;
    }

    String getMonitorName() {
        return "Monitor Session Summary";
    }
}

