/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEEntityMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEUpTimeCompare;
import java.io.Serializable;

public class LEAlarmMessage
extends LEEntityMessage
implements Serializable {
    public static final String CLEARED = "Cleared";
    public static final String CURRENT = "Current";
    public static final String STALE = "Stale";
    public static final String OS_SENDING_TICKS = "4.1b10";
    public static final int TICKS_PER_MINUTE = 1092;
    int m_time;
    String m_ftime;
    String m_state = "Current";
    String m_message;
    String m_severity;
    int m_count;

    public LEAlarmMessage(String string, int n, String string2) {
        super(string, n, string2);
        this.m_messageType = "ALARM";
    }

    public int getMinutes() {
        return this.m_time;
    }

    public void checkForTicks(String string) {
        if (string.startsWith(OS_SENDING_TICKS)) {
            this.m_time /= 1092;
        }
    }

    public String getFormatedTime() {
        if (this.m_ftime == null) {
            this.m_ftime = LEUpTimeCompare.FormatTime(this.m_time);
        }
        return this.m_ftime;
    }

    public String getState() {
        return this.m_state;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String getSeverity() {
        return this.m_severity;
    }

    public int getCount() {
        return this.m_count;
    }

    public void clear() {
        this.m_state = CLEARED;
    }

    public void setState(String string) {
        this.m_state = string;
    }

    public void setAttribute(int n, String string) {
        try {
            switch (n) {
                case 58: {
                    this.extractTime(string);
                    return;
                }
                case 59: {
                    this.m_state = string;
                    return;
                }
                case 60: {
                    this.m_message = string;
                    return;
                }
                case 61: {
                    this.m_severity = string;
                    return;
                }
                case 62: {
                    this.m_count = Integer.parseInt(string);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void extractTime(String string) {
        try {
            int n = string.indexOf(58);
            if (n > -1) {
                int n2 = Integer.parseInt(string.substring(0, n));
                int n3 = Integer.parseInt(string.substring(n + 1));
                this.m_time = n2 * 60 + n3;
                return;
            }
            n = string.indexOf("days");
            if (n > -1) {
                int n4 = Integer.parseInt(string.substring(0, n));
                this.m_time = n4 * 1440;
                return;
            }
            this.m_time = Integer.parseInt(string);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }
}

