/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEChannels;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEEthernets;
import com.lucent.ra.nms.model.LEIMT;
import com.lucent.ra.nms.model.LEL2TP;
import com.lucent.ra.nms.model.LELines;
import com.lucent.ra.nms.model.LEModems;
import com.lucent.ra.nms.model.LEPVCs;
import com.lucent.ra.nms.model.LEPorts;
import com.lucent.ra.nms.util.LEVector;

public class LEBoard
extends LEConfig {
    public static final String ASSIGNED_ADDR = Integer.toString(164);
    public static final String ASSIGNED_POOL = Integer.toString(165);
    public static final String BACKPLANE_CLOCK = "473";
    public static final String BOARD_TYPE = Integer.toString(272);
    public static final String CHANNELS = "3670019";
    public static final String ETHERNETS = Integer.toString(720896);
    public static final String IMT = "3670022";
    public static final String PRI_SWITCH = Integer.toString(172);
    public static final String LINE_CLOCK = "472";
    public static final String LINE_LOOP = "461";
    public static final String LINES = Integer.toString(131072);
    public static final String MGR_TYPE = "530";
    public static final String MODEMS = Integer.toString(196608);
    public static final String OS_VERSION = Integer.toString(276);
    public static final String PORTS = Integer.toString(262144);
    public static final String POWER = Integer.toString(279);
    public static final String PVCS = "4194311";
    public static final String SERIAL_NUMBER = Integer.toString(273);
    public static final String SLOT = Integer.toString(274);
    public static final String L2TP = Integer.toString(0x350000);
    public static final String STATUS = "17";
    public static final int KEY_COUNT = 21;
    public static final String ETHERNET = "Ethernet";
    public static final String DUAL_ETHER = "Dual Ethernet";
    public static final String PRESENT = "Present";
    public static final String QUAD_T1 = "Quad T1";
    public static final String TRI_E1 = "Tri E1";
    public static final String SYSTEM_MANAGER = "System Manager";
    public static final String T3_MUX = "T3 Mux";
    public static final String E3_MUX = "E3 Mux";
    public static final String T3_CLEAR = "T3 Clear";
    public static final String LNS = "LNS";
    public static final String T3_MUXR = "T3 Mux Redundant";
    public static final String E3_MUXR = "E3 Mux Redundant";
    public static final String T3_ATM = "T3 ATM";
    public static final String E3_ATM = "E3 ATM";
    public static final String E3_CLEAR = "E3 Clear";
    public static final String STS1 = "STS1 Mux";
    public static final String STS1_R = "STS1 Mux Redundant";
    public static final String HSSI = "HSSI";
    public static final String PCT = "PCT";
    public static final String UNKNOWN = "Unknown";
    public static final String PRIMARY = "Primary";
    public static final String SECONDARY = "Secondary";
    public static final String MANAGER_1 = "4";
    public static final String MANAGER_2 = "5";
    public static final String BOOTING = "booting";
    public static final String SYSTEM_MANAGER_ID_1 = "4";
    public static final String SYSTEM_MANAGER_ID_2 = "5";
    public static final String ETHER_DAUGHTER_ID = "10";
    public static final String DUALETHER_DAUGHTER_ID = "11";
    public static final String SET_GLOBAL_VIEW = "set view global";
    public static final String SET_MGR_VIEW = "set view 4";
    static String[] s_keys = null;
    String m_name;
    boolean m_reboot;
    LEDataSpec m_powerSpec;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[21];
            int i = 0;
            LEBoard.s_keys[i++] = ASSIGNED_ADDR;
            LEBoard.s_keys[i++] = ASSIGNED_POOL;
            LEBoard.s_keys[i++] = BACKPLANE_CLOCK;
            LEBoard.s_keys[i++] = BOARD_TYPE;
            LEBoard.s_keys[i++] = CHANNELS;
            LEBoard.s_keys[i++] = ETHERNETS;
            LEBoard.s_keys[i++] = IMT;
            LEBoard.s_keys[i++] = PRI_SWITCH;
            LEBoard.s_keys[i++] = LINE_CLOCK;
            LEBoard.s_keys[i++] = LINE_LOOP;
            LEBoard.s_keys[i++] = LINES;
            LEBoard.s_keys[i++] = MGR_TYPE;
            LEBoard.s_keys[i++] = MODEMS;
            LEBoard.s_keys[i++] = OS_VERSION;
            LEBoard.s_keys[i++] = PORTS;
            LEBoard.s_keys[i++] = POWER;
            LEBoard.s_keys[i++] = PVCS;
            LEBoard.s_keys[i++] = SERIAL_NUMBER;
            LEBoard.s_keys[i++] = SLOT;
            LEBoard.s_keys[i++] = STATUS;
            LEBoard.s_keys[i++] = L2TP;
        }
        return s_keys;
    }

    public LEBoard(LEConnectionFacade facade, String name) {
        super(facade);
        this.m_name = name;
        this.m_board = name;
    }

    public static final LEPMCommand SetView(LEConnectionFacade facade, String view) {
        String cmd = new String("set view " + view);
        return facade.execute(cmd);
    }

    public static boolean IsManager(String id) {
        return id.equals("4") || id.equals("5") || id.equals(ETHER_DAUGHTER_ID);
    }

    public static boolean IsDaughter(String id) {
        return id.equals(ETHER_DAUGHTER_ID) || id.equals(DUALETHER_DAUGHTER_ID);
    }

    public Object clone() {
        LEBoard config = new LEBoard(this.m_facade, this.m_name);
        config.copy(this);
        return config;
    }

    public LEDataSpec getSpecFor(String key) {
        LEDataSpec spec = super.getSpecFor(key);
        if (spec != null && key.equals(POWER) && (LEBoard.IsManager(this.m_board) || LEBoard.IsDaughter(this.m_board))) {
            if (this.m_powerSpec == null) {
                this.m_powerSpec = (LEDataSpec)spec.clone();
                this.m_powerSpec.addAttribute(LEAttributes.READONLY, "");
            }
            spec = this.m_powerSpec;
        }
        return spec;
    }

    public String getType() {
        String type = (String)this.get(BOARD_TYPE);
        if (type == null) {
            type = "";
        }
        return type;
    }

    public String getStatus() {
        String type = this.getType();
        String power = (String)this.get(POWER);
        if (power == null) {
            return "";
        }
        if (type.equals(PRESENT) && power.equals("on")) {
            return BOOTING;
        }
        return power;
    }

    public boolean isPoweredUp() {
        String type = (String)this.get(BOARD_TYPE);
        String power = (String)this.get(POWER);
        return type != null && !type.equals(PRESENT) && power != null && power.equals("on");
    }

    public boolean isPoweringUp() {
        String type = (String)this.get(BOARD_TYPE);
        String power = (String)this.get(POWER);
        return type != null && type.equals(PRESENT) && power != null && power.equals("on");
    }

    public boolean getGlobalCommands(LEVector cmds) {
        return this.generateCommands(null, cmds);
    }

    boolean makeViewCommand(LEVector cmds) {
        String cmd = this.getViewCommand();
        String power = (String)this.get(POWER);
        if (cmd != null && power.equals("on")) {
            cmds.addElement(cmd);
            return true;
        }
        return false;
    }

    LEConfig createConfig(String key) {
        if (key.equals(PORTS)) {
            return new LEPorts(this.m_facade, this.m_name, PORTS);
        }
        if (key.equals(LINES)) {
            return new LELines(this.m_facade, this.m_name, LINES);
        }
        if (key.equals(ETHERNETS)) {
            return new LEEthernets(this.m_facade, this.m_name, ETHERNETS);
        }
        if (key.equals(MODEMS)) {
            return new LEModems(this.m_facade, this.m_name, MODEMS);
        }
        if (key.equals(IMT)) {
            return new LEIMT(this.m_facade, this.m_name, IMT);
        }
        if (key.equals(CHANNELS)) {
            return new LEChannels(this.m_facade, this.m_name, CHANNELS);
        }
        if (key.equals(L2TP)) {
            return new LEL2TP(this.m_facade, this.m_name, L2TP);
        }
        if (key.equals(PVCS)) {
            return new LEPVCs(this.m_facade, this.m_name, PVCS);
        }
        return new LEConfig(this.m_facade);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String power;
        String slot;
        boolean allCmds = keys == null;
        int start = cmds.size();
        if ((allCmds || keys.contains(POWER)) && this.makePowerCommand(cmds, slot = (String)this.get(SLOT), power = (String)this.get(POWER))) {
            this.makeViewCommand(cmds);
        }
        if (allCmds || keys.contains(ASSIGNED_ADDR)) {
            this.makeSetCommand(cmds, null, ASSIGNED_ADDR, "assigned_address");
        }
        if (allCmds || keys.contains(ASSIGNED_POOL)) {
            this.makeSetCommand(cmds, null, ASSIGNED_POOL, "pool");
        }
        if (allCmds || keys.contains(PRI_SWITCH)) {
            this.makeSetCommand(cmds, null, PRI_SWITCH, "isdn-switch");
        }
        if (allCmds || keys.contains(BACKPLANE_CLOCK)) {
            this.makeSetCommand(cmds, null, BACKPLANE_CLOCK, "mux backplane-clock");
        }
        if (allCmds || keys.contains(LINE_CLOCK)) {
            this.makeSetCommand(cmds, null, LINE_CLOCK, "mux line-clock");
        }
        if (allCmds || keys.contains(LINE_LOOP)) {
            this.makeSetCommand(cmds, null, LINE_LOOP, "mux line-loop");
        }
        return cmds.size() > start;
    }

    boolean makePowerCommand(LEVector cmds, String slot, String power) {
        if (slot == null || power == null) {
            return false;
        }
        boolean ret = false;
        try {
            int num = Integer.parseInt(slot);
            if (num < 10 && num != 4 && num != 5) {
                if (this.m_smm) {
                    cmds.addElement(SET_GLOBAL_VIEW);
                } else {
                    cmds.addElement(SET_MGR_VIEW);
                }
                StringBuffer buf = new StringBuffer(14);
                buf.append("set ");
                buf.append("slot");
                buf.append(slot);
                buf.append(" ");
                buf.append(power);
                cmds.addElement(buf.toString());
                ret = true;
            }
        }
        catch (Exception exception) {}
        return ret;
    }

    LEVector getChildren(boolean fetch) {
        LEVector children = null;
        if (this.get(IMT) != null) {
            if (children == null) {
                children = new LEVector();
            }
            children.addElement(IMT);
        }
        if (this.get(LINES) != null) {
            if (children == null) {
                children = new LEVector();
            }
            children.addElement(LINES);
        }
        if (this.get(ETHERNETS) != null) {
            if (children == null) {
                children = new LEVector();
            }
            children.addElement(ETHERNETS);
        }
        if (this.get(PORTS) != null) {
            if (children == null) {
                children = new LEVector();
            }
            children.addElement(PORTS);
        }
        if (this.get(MODEMS) != null) {
            if (children == null) {
                children = new LEVector();
            }
            children.addElement(MODEMS);
        }
        if (this.get(CHANNELS) != null) {
            if (children == null) {
                children = new LEVector();
            }
            children.addElement(CHANNELS);
        }
        if (this.get(L2TP) != null) {
            if (children == null) {
                children = new LEVector();
            }
            children.addElement(L2TP);
        }
        if (this.get(PVCS) != null) {
            if (children == null) {
                children = new LEVector();
            }
            children.addElement(PVCS);
        }
        return children;
    }
}

