/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEEthernet
extends LEConfig {
    public static final String ADDRESS = "9";
    public static final String BROADCAST = "186";
    public static final String COST = "242";
    public static final String DEADTIME = "244";
    public static final String HELLOINTERVAL = "243";
    public static final String INPUT_FILTER = "193";
    public static final String IP_STATUS = "191";
    public static final String IPSEC_ACTIVE_PROFILE = "501";
    public static final String IPSEC_LOG_CONSOLE = "499";
    public static final String IPSEC_LOG_FAILURE = "496";
    public static final String IPSEC_LOG_SUCCESS = "497";
    public static final String IPSEC_LOG_SYSLOG = "498";
    public static final String IPSEC_OUTSRC_PROFILE = "500";
    public static final String IPSEC_PASSIVE_PROFILE = "502";
    public static final String IPSEC_PDA = "503";
    public static final String IPX_FRAME = "190";
    public static final String IPX_NETWORK = "189";
    public static final String IPX_STATUS = "192";
    public static final String MAC_ADDRESS = "195";
    public static final String MIGRATION = "241";
    public static final String MPROXY = "512";
    public static final String MPROXY_ADDR = "513";
    public static final String MPROXY_PORT = "514";
    public static final String MPROXY_SRC_ADDR = "515";
    public static final String MPROXY_SRC_MASK = "516";
    public static final String MPROXY_SLOT = "517";
    public static final String MPROXY_NUM = "518";
    public static final String MPROXY_ALARM = "519";
    public static final String MPROXY_TIMEOUT = "520";
    public static final String NAT_TCP_TIMEOUT = "353";
    public static final String NAT_OTHER_TIMEOUT = "354";
    public static final String NAT_FAIL_ACTION = "355";
    public static final String NAT_IN_MAP = "356";
    public static final String NAT_PROXY_IN_MAP = "357";
    public static final String NAT_OUT_MAP = "358";
    public static final String NAT_PROXY_OUT_MAP = "359";
    public static final String NAT_LOG_FAILURE = "360";
    public static final String NAT_LOG_SUCCESS = "361";
    public static final String NAT_LOG_SYSLOG = "362";
    public static final String NAT_LOG_CONSOLE = "363";
    public static final String NETMASK = "15";
    public static final String OSPF_ROUTERID = "100";
    public static final String OSPF_STATUS = "246";
    public static final String OUTPUT_FILTER = "194";
    public static final String RIP = "rip";
    public static final String RIP_V2 = "rip_v2";
    public static final String RIP_COST = "198";
    public static final String ROUTE_IFILTER = "533";
    public static final String ROUTE_OFILTER = "534";
    public static final String XBAR_ADDR = "72";
    public static final int KEY_COUNT = 49;
    public static final String HIGH = "high";
    public static final String LOW = "low";
    public static final String BROAD = "broadcast";
    public static final String LISTEN = "listen";
    public static final String V2 = "v2 enabled";
    public static final String MULTICAST = "multicast";
    public static final String COMPATABILITY = "v1-compatability";
    public static final String ETHERNET_802_2 = "ethernet_802.2";
    public static final String ETHERNET_802_2_II = "ethernet_802.2_ii";
    public static final String ETHERNET_802_3 = "ethernet_802.3";
    public static final String ETHERNET_II = "ethernet_ii";
    static String[] s_keys = null;
    String m_name;
    boolean m_reboot;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[49];
            int i = 0;
            LEEthernet.s_keys[i++] = ADDRESS;
            LEEthernet.s_keys[i++] = BROADCAST;
            LEEthernet.s_keys[i++] = COST;
            LEEthernet.s_keys[i++] = DEADTIME;
            LEEthernet.s_keys[i++] = HELLOINTERVAL;
            LEEthernet.s_keys[i++] = INPUT_FILTER;
            LEEthernet.s_keys[i++] = IP_STATUS;
            LEEthernet.s_keys[i++] = IPSEC_ACTIVE_PROFILE;
            LEEthernet.s_keys[i++] = IPSEC_LOG_FAILURE;
            LEEthernet.s_keys[i++] = IPSEC_LOG_SUCCESS;
            LEEthernet.s_keys[i++] = IPSEC_LOG_SYSLOG;
            LEEthernet.s_keys[i++] = IPSEC_LOG_CONSOLE;
            LEEthernet.s_keys[i++] = IPSEC_OUTSRC_PROFILE;
            LEEthernet.s_keys[i++] = IPSEC_PASSIVE_PROFILE;
            LEEthernet.s_keys[i++] = IPSEC_PDA;
            LEEthernet.s_keys[i++] = IPX_FRAME;
            LEEthernet.s_keys[i++] = IPX_NETWORK;
            LEEthernet.s_keys[i++] = IPX_STATUS;
            LEEthernet.s_keys[i++] = MAC_ADDRESS;
            LEEthernet.s_keys[i++] = MIGRATION;
            LEEthernet.s_keys[i++] = MPROXY;
            LEEthernet.s_keys[i++] = MPROXY_ADDR;
            LEEthernet.s_keys[i++] = MPROXY_SRC_ADDR;
            LEEthernet.s_keys[i++] = MPROXY_SRC_MASK;
            LEEthernet.s_keys[i++] = MPROXY_SLOT;
            LEEthernet.s_keys[i++] = MPROXY_NUM;
            LEEthernet.s_keys[i++] = MPROXY_ALARM;
            LEEthernet.s_keys[i++] = MPROXY_TIMEOUT;
            LEEthernet.s_keys[i++] = NAT_TCP_TIMEOUT;
            LEEthernet.s_keys[i++] = NAT_OTHER_TIMEOUT;
            LEEthernet.s_keys[i++] = NAT_FAIL_ACTION;
            LEEthernet.s_keys[i++] = NAT_IN_MAP;
            LEEthernet.s_keys[i++] = NAT_PROXY_IN_MAP;
            LEEthernet.s_keys[i++] = NAT_OUT_MAP;
            LEEthernet.s_keys[i++] = NAT_PROXY_OUT_MAP;
            LEEthernet.s_keys[i++] = NAT_LOG_FAILURE;
            LEEthernet.s_keys[i++] = NAT_LOG_SUCCESS;
            LEEthernet.s_keys[i++] = NAT_LOG_SYSLOG;
            LEEthernet.s_keys[i++] = NAT_LOG_CONSOLE;
            LEEthernet.s_keys[i++] = NETMASK;
            LEEthernet.s_keys[i++] = OSPF_ROUTERID;
            LEEthernet.s_keys[i++] = OSPF_STATUS;
            LEEthernet.s_keys[i++] = OUTPUT_FILTER;
            LEEthernet.s_keys[i++] = RIP_COST;
            LEEthernet.s_keys[i++] = RIP;
            LEEthernet.s_keys[i++] = RIP_V2;
            LEEthernet.s_keys[i++] = ROUTE_IFILTER;
            LEEthernet.s_keys[i++] = ROUTE_OFILTER;
            LEEthernet.s_keys[i++] = XBAR_ADDR;
        }
        return s_keys;
    }

    public LEEthernet(LEConnectionFacade facade, String board, String name) {
        super(facade, board);
        this.m_name = name;
    }

    public LEEthernet(LEConnectionFacade facade, String name) {
        super(facade);
        this.m_name = name;
    }

    public Object clone() {
        LEEthernet config = new LEEthernet(this.m_facade, this.m_board, this.m_name);
        config.copy(this);
        return config;
    }

    boolean getAllCommands(LEVector cmds) {
        boolean ret = super.getAllCommands(cmds);
        if (ret && this.m_reboot) {
            cmds.addElement("save all");
            if (this.m_board != null) {
                if (LEBoard.IsManager(this.m_board)) {
                    cmds.addElement("reboot");
                } else {
                    this.makePowerCycleCommands(cmds);
                }
            } else {
                cmds.addElement("reboot");
            }
            this.m_reboot = false;
        }
        return ret;
    }

    boolean getChangedCommands(LEVector cmds) {
        boolean ret = super.getChangedCommands(cmds);
        if (ret && this.m_reboot) {
            cmds.addElement("save all");
            if (this.m_board != null) {
                if (LEBoard.IsManager(this.m_board)) {
                    cmds.addElement("reboot");
                } else {
                    this.makePowerCycleCommands(cmds);
                }
            } else {
                cmds.addElement("reboot");
            }
            this.m_reboot = false;
        }
        return ret;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        this.m_reboot = false;
        if (allCmds || keys.contains(ADDRESS)) {
            this.makeSetCommand(cmds, this.m_name, ADDRESS, "address");
        }
        if (allCmds || keys.contains(BROADCAST)) {
            this.makeSetCommand(cmds, this.m_name, BROADCAST, BROAD);
        }
        if (allCmds || keys.contains(INPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_name, INPUT_FILTER, "ifilter");
        }
        if (allCmds || keys.contains(IP_STATUS)) {
            if (this.m_board != null) {
                if (LEBoard.IsManager(this.m_board)) {
                    this.makeSetCommand(cmds, this.m_name, IP_STATUS, "ip");
                }
            } else {
                this.makeSetCommand(cmds, this.m_name, IP_STATUS, "ip");
            }
        }
        if (allCmds || keys.contains(IPX_FRAME)) {
            this.makeSetCommand(cmds, this.m_name, IPX_FRAME, "ipxframe");
        }
        if (allCmds || keys.contains(IPX_NETWORK)) {
            this.makeSetCommand(cmds, this.m_name, IPX_NETWORK, "ipxnet");
        }
        if (allCmds || keys.contains(IPX_STATUS)) {
            if (this.m_board != null) {
                if (LEBoard.IsManager(this.m_board)) {
                    this.makeSetCommand(cmds, this.m_name, IPX_STATUS, "ipx");
                }
            } else {
                this.makeSetCommand(cmds, this.m_name, IPX_STATUS, "ipx");
            }
        }
        if (allCmds || keys.contains(NAT_TCP_TIMEOUT)) {
            this.makeNATTimeOutCommand(cmds, this.m_name, NAT_TCP_TIMEOUT, NAT_TCP_TIMEOUT);
        }
        if (allCmds || keys.contains(NAT_OTHER_TIMEOUT)) {
            this.makeNATTimeOutCommand(cmds, this.m_name, NAT_OTHER_TIMEOUT, NAT_OTHER_TIMEOUT);
        }
        if (allCmds || keys.contains(NAT_FAIL_ACTION)) {
            this.makeNATFailActionCommand(cmds, this.m_name, NAT_FAIL_ACTION);
        }
        if (allCmds || keys.contains(NAT_IN_MAP)) {
            this.makeNATMapCommand(cmds, this.m_name, NAT_IN_MAP, true, false);
        }
        if (allCmds || keys.contains(NAT_PROXY_IN_MAP)) {
            this.makeNATMapCommand(cmds, this.m_name, NAT_PROXY_IN_MAP, true, true);
        }
        if (allCmds || keys.contains(NAT_OUT_MAP)) {
            this.makeNATMapCommand(cmds, this.m_name, NAT_OUT_MAP, false, false);
        }
        if (allCmds || keys.contains(NAT_PROXY_OUT_MAP)) {
            this.makeNATMapCommand(cmds, this.m_name, NAT_PROXY_OUT_MAP, false, true);
        }
        if (allCmds || keys.contains(NAT_LOG_FAILURE)) {
            this.makeNATLogCommand(cmds, this.m_name, NAT_LOG_FAILURE, NAT_LOG_FAILURE);
        }
        if (allCmds || keys.contains(NAT_LOG_SUCCESS)) {
            this.makeNATLogCommand(cmds, this.m_name, NAT_LOG_SUCCESS, NAT_LOG_SUCCESS);
        }
        if (allCmds || keys.contains(NAT_LOG_SYSLOG)) {
            this.makeNATLogCommand(cmds, this.m_name, NAT_LOG_SYSLOG, NAT_LOG_SYSLOG);
        }
        if (allCmds || keys.contains(NAT_LOG_CONSOLE)) {
            this.makeNATLogCommand(cmds, this.m_name, NAT_LOG_CONSOLE, NAT_LOG_CONSOLE);
        }
        if (allCmds || keys.contains(NETMASK)) {
            this.makeSetCommand(cmds, this.m_name, NETMASK, "netmask");
        }
        if (allCmds || keys.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_name, OUTPUT_FILTER, "ofilter");
        }
        if (allCmds || keys.contains(RIP) || keys.contains(RIP_V2)) {
            String rip = (String)this.get(RIP);
            if (allCmds) {
                this.makeRIPCommand(cmds, this.m_name, RIP, (String)this.get(RIP));
                this.makeRIPv2Command(cmds, this.m_name, "rip v2", (String)this.get(RIP), (String)this.get(RIP_V2));
            } else if (keys != null && keys.contains(RIP) && rip != null && !rip.equals(V2)) {
                this.makeRIPCommand(cmds, this.m_name, RIP, (String)this.get(RIP));
            } else {
                this.makeRIPv2Command(cmds, this.m_name, "rip v2", (String)this.get(RIP), (String)this.get(RIP_V2));
            }
        }
        if (allCmds || keys.contains(RIP_COST)) {
            this.makeSetCommand(cmds, this.m_name, RIP_COST, "rip cost");
        }
        if ((allCmds || keys.contains(OSPF_STATUS) || keys.contains(COST) || keys.contains(MIGRATION) || keys.contains(HELLOINTERVAL) || keys.contains(DEADTIME)) && this.get(OSPF_STATUS) != null) {
            StringBuffer buf = new StringBuffer(100);
            buf.append("set ");
            buf.append(this.m_name);
            buf.append(" ospf ");
            String status = (String)this.get(OSPF_STATUS);
            buf.append(status);
            if (status.equals("on")) {
                String dead;
                String hello;
                String migration;
                String cost = (String)this.get(COST);
                if (cost != null && cost.length() > 0) {
                    buf.append(" cost ");
                    buf.append(cost);
                }
                if ((migration = (String)this.get(MIGRATION)) != null && migration.length() > 0) {
                    buf.append(" accept-rip ");
                    buf.append(migration);
                }
                if ((hello = (String)this.get(HELLOINTERVAL)) != null && hello.length() > 0) {
                    buf.append(" hello-interval ");
                    buf.append(hello);
                }
                if ((dead = (String)this.get(DEADTIME)) != null && dead.length() > 0) {
                    buf.append(" dead-time ");
                    buf.append(dead);
                }
            }
            buf.append(" ");
            cmds.add(new String(buf));
        }
        if (allCmds || keys.contains(OSPF_ROUTERID)) {
            this.makeSetCommand(cmds, null, OSPF_ROUTERID, "ospf router-id");
        }
        if (allCmds || keys.contains(IPSEC_LOG_FAILURE)) {
            this.makeIPSecLogCommand(cmds, this.m_name, IPSEC_LOG_FAILURE, IPSEC_LOG_FAILURE);
        }
        if (allCmds || keys.contains(IPSEC_LOG_SUCCESS)) {
            this.makeIPSecLogCommand(cmds, this.m_name, IPSEC_LOG_SUCCESS, IPSEC_LOG_SUCCESS);
        }
        if (allCmds || keys.contains(IPSEC_LOG_SYSLOG)) {
            this.makeIPSecLogCommand(cmds, this.m_name, IPSEC_LOG_SYSLOG, IPSEC_LOG_SYSLOG);
        }
        if (allCmds || keys.contains(IPSEC_LOG_CONSOLE)) {
            this.makeIPSecLogCommand(cmds, this.m_name, IPSEC_LOG_CONSOLE, IPSEC_LOG_CONSOLE);
        }
        if (allCmds || keys.contains(IPSEC_OUTSRC_PROFILE)) {
            this.makeIPSecProfileCommand(cmds, this.m_name, IPSEC_OUTSRC_PROFILE, IPSEC_OUTSRC_PROFILE);
        }
        if (allCmds || keys.contains(IPSEC_ACTIVE_PROFILE)) {
            this.makeIPSecProfileCommand(cmds, this.m_name, IPSEC_ACTIVE_PROFILE, IPSEC_ACTIVE_PROFILE);
        }
        if (allCmds || keys.contains(IPSEC_PDA)) {
            this.makeIPSecPDACommand(cmds, this.m_name, IPSEC_PDA, IPSEC_PDA);
        }
        if (allCmds || keys.contains(XBAR_ADDR)) {
            this.m_reboot = this.makeSetCommand(cmds, this.m_name, XBAR_ADDR, "crossbar-ip");
        }
        if (allCmds || keys.contains(ROUTE_IFILTER)) {
            this.makeSetCommand(cmds, this.m_name, ROUTE_IFILTER, "route-filter incoming");
        }
        if (allCmds || keys.contains(ROUTE_OFILTER)) {
            this.makeSetCommand(cmds, this.m_name, ROUTE_OFILTER, "route-filter outgoing");
        }
        if (allCmds || keys.contains(MPROXY)) {
            this.makeSetCommand(cmds, this.m_name, MPROXY, "mproxy");
        }
        if (allCmds || keys.contains(MPROXY_ADDR)) {
            this.makeSetCommand(cmds, this.m_name, MPROXY_ADDR, "mproxy address");
        }
        if (allCmds || keys.contains(MPROXY_PORT)) {
            this.makeSetCommand(cmds, this.m_name, MPROXY_PORT, "mproxy port");
        }
        if (allCmds || keys.contains(MPROXY_SRC_ADDR)) {
            this.makeSetCommand(cmds, this.m_name, MPROXY_SRC_ADDR, "mproxy src-address");
        }
        if (allCmds || keys.contains(MPROXY_SRC_MASK)) {
            this.makeSetCommand(cmds, this.m_name, MPROXY_SRC_MASK, "mproxy src-netmask");
        }
        if (allCmds || keys.contains(MPROXY_NUM)) {
            this.makeSetCommand(cmds, this.m_name, MPROXY_NUM, "mproxy number-slots");
        }
        if (allCmds || keys.contains(MPROXY_SLOT)) {
            this.makeSetCommand(cmds, this.m_name, MPROXY_SLOT, "mproxy slot-time");
        }
        if (allCmds || keys.contains(MPROXY_ALARM)) {
            this.makeSetCommand(cmds, this.m_name, MPROXY_ALARM, "mproxy alarm");
        }
        if (allCmds || keys.contains(MPROXY_TIMEOUT)) {
            this.makeSetCommand(cmds, this.m_name, MPROXY_TIMEOUT, "mproxy timeout");
        }
        return cmds.size() > start;
    }

    public boolean requiresPowerCycle(String key) {
        return this.m_board != null && key.equals(XBAR_ADDR) && !LEBoard.IsManager(this.m_board) && !LEBoard.IsDaughter(this.m_board);
    }

    public boolean requiresReboot(String key) {
        if (key.equals(XBAR_ADDR)) {
            if (this.m_board != null) {
                if (!LEBoard.IsManager(this.m_board)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

