/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEHost;
import com.lucent.ra.nms.model.LEOrderedList;
import com.lucent.ra.nms.util.LEVector;

public class LEHosts
extends LEOrderedList {
    public LEHosts(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LEHosts config = new LEHosts(this.m_facade);
        config.copy(this);
        return config;
    }

    public LEVector add(String ip, String host) {
        LEVector errors = null;
        StringBuffer buf = new StringBuffer("add ");
        buf.append("host ");
        buf.append(ip);
        buf.append(" ");
        buf.append(host);
        LEPMCommand ret = this.m_facade.execute(buf.toString());
        if (ret.getStatus()) {
            ret = this.m_facade.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String host) {
        LEVector errors = null;
        StringBuffer buf = new StringBuffer("delete ");
        buf.append("host ");
        buf.append(host);
        LEPMCommand ret = this.m_facade.execute(buf.toString());
        if (ret.getStatus()) {
            ret = this.m_facade.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig() {
        return new LEHost(this.m_facade);
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        LEHost host = (LEHost)this.get(key);
        if (host == null) {
            return false;
        }
        String ip = (String)host.get("address");
        String name = (String)host.get("hostname");
        if (ip != null && ip.length() > 0 && name != null && name.length() > 0) {
            StringBuffer buf = new StringBuffer("add ");
            buf.append("host ");
            buf.append(ip);
            buf.append(" ");
            buf.append(name);
            cmds.addElement(buf.toString());
            return true;
        }
        return false;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        LEHost host = (LEHost)this.get(key);
        if (host == null) {
            return false;
        }
        String name = (String)host.get("hostname");
        if (name != null && name.length() > 0) {
            StringBuffer buf = new StringBuffer("delete ");
            buf.append("host ");
            buf.append(name);
            cmds.addElement(buf.toString());
            return true;
        }
        return false;
    }
}

