/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LELocalIPAddress;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LELocalIPAddresses
extends LETable {
    public LELocalIPAddresses(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LELocalIPAddresses config = new LELocalIPAddresses(this.m_facade);
        config.copy(this);
        return config;
    }

    public LEVector add(String num, String address) {
        LEVector errors = null;
        LELocalIPAddress local_ip = (LELocalIPAddress)this.getConfig(num);
        local_ip.set("9", address);
        errors = local_ip.saveChanges();
        this.refresh();
        return errors;
    }

    public LEVector delete(String num) {
        LEVector cmds;
        LEPMCommand ret;
        LEVector errors = null;
        this.m_fields.remove(num);
        if (this.m_facade != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("set local-ip-address ");
            buf.append(num);
            buf.append(" 0.0.0.0 ");
            ret = this.m_facade.execute(buf.toString());
            if (!ret.getStatus()) {
                errors = new LEVector();
                errors.addElement(ret);
            }
        }
        if (errors == null && this.m_facade != null && this.getCommands(cmds = new LEVector())) {
            int len = cmds.size();
            int i = 0;
            while (i < len) {
                ret = this.m_facade.execute((String)cmds.elementAt(i));
                if (!ret.getStatus()) {
                    if (errors == null) {
                        errors = new LEVector();
                    }
                    errors.addElement(ret);
                }
                ++i;
            }
        }
        if (errors != null) {
            this.refresh();
        }
        return errors;
    }

    public void clear() {
        this.m_fields.clear();
        this.setChanged();
        this.notifyObservers();
    }

    LEConfig createConfig(String key) {
        return new LELocalIPAddress(this.m_facade, key);
    }
}

