/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LELoginUser
extends LEConfig {
    public static final String COST = "242";
    public static final String DEADTIME = "244";
    public static final String HELLOINTERVAL = "243";
    public static final String HOST = "host";
    public static final String HOST_ADDRESS = "HostAddress";
    public static final String IDLE_TIMEOUT = "129";
    public static final String INPUT_FILTER = "193";
    public static final String LOGIN_SERVICE = "service";
    public static final String MIGRATION = "241";
    public static final String OSPF_STATUS = "246";
    public static final String PASSWORD = "password";
    public static final String SESSION_LIMIT = "371";
    public static final String WANTYPE = "245";
    public static final int KEY_COUNT = 13;
    public static final String DEFAULT = "default";
    public static final String PROMPT = "prompt";
    public static final String SPECIFIED = "specified";
    public static final String PORTMASTER = "portmaster";
    public static final String RLOGIN = "rlogin";
    public static final String TELNET = "telnet";
    public static final String NETDATA = "netdata";
    static String[] s_keys = null;
    String m_name;
    String m_tag;
    boolean m_passwordFetched = false;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[13];
            int i = 0;
            LELoginUser.s_keys[i++] = COST;
            LELoginUser.s_keys[i++] = DEADTIME;
            LELoginUser.s_keys[i++] = HELLOINTERVAL;
            LELoginUser.s_keys[i++] = HOST;
            LELoginUser.s_keys[i++] = HOST_ADDRESS;
            LELoginUser.s_keys[i++] = IDLE_TIMEOUT;
            LELoginUser.s_keys[i++] = INPUT_FILTER;
            LELoginUser.s_keys[i++] = LOGIN_SERVICE;
            LELoginUser.s_keys[i++] = MIGRATION;
            LELoginUser.s_keys[i++] = OSPF_STATUS;
            LELoginUser.s_keys[i++] = PASSWORD;
            LELoginUser.s_keys[i++] = SESSION_LIMIT;
            LELoginUser.s_keys[i++] = WANTYPE;
        }
        return s_keys;
    }

    public LELoginUser(LEConnectionFacade facade, String name) {
        super(facade);
        this.m_name = name;
        this.m_tag = "user " + this.m_name;
    }

    public Object clone() {
        LELoginUser config = new LELoginUser(this.m_facade, this.m_name);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    void setPassword(String password) {
        this.m_passwordFetched = true;
        this.setField(PASSWORD, password);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(HOST) || keys.contains(HOST_ADDRESS)) {
            String host = (String)this.get(HOST);
            if (host != null && host.equals(SPECIFIED)) {
                this.makeSetCommand(cmds, this.m_tag, HOST_ADDRESS, HOST);
            } else {
                this.makeSetCommand(cmds, this.m_tag, HOST, HOST);
            }
        }
        if (allCmds || keys.contains(IDLE_TIMEOUT)) {
            this.makeSetCommand(cmds, this.m_tag, IDLE_TIMEOUT, "idle");
        }
        if (allCmds || keys.contains(INPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_tag, INPUT_FILTER, "ifilter");
        }
        if (allCmds || keys.contains(LOGIN_SERVICE)) {
            this.makeServiceCommand(cmds, this.m_tag, LOGIN_SERVICE, LOGIN_SERVICE);
        }
        if (allCmds && this.m_passwordFetched) {
            this.makeSetCommand(cmds, this.m_tag, PASSWORD, PASSWORD);
            this.clearField(PASSWORD);
            this.m_passwordFetched = false;
        }
        if (!allCmds && keys.contains(PASSWORD)) {
            this.makeSetCommand(cmds, this.m_tag, PASSWORD, PASSWORD);
            this.clearField(PASSWORD);
            this.m_passwordFetched = false;
        }
        if (allCmds || keys.contains(SESSION_LIMIT)) {
            this.makeSetCommand(cmds, this.m_tag, SESSION_LIMIT, "session-limit");
        }
        if ((allCmds || keys.contains(OSPF_STATUS)) && this.get(OSPF_STATUS) != null) {
            StringBuffer buf = new StringBuffer(100);
            buf.append("set ");
            buf.append(" ");
            buf.append(this.m_tag);
            buf.append(" ospf ");
            String status = (String)this.get(OSPF_STATUS);
            buf.append(status);
            if (status.equals("on")) {
                String wantype;
                String dead;
                String hello;
                String migration;
                String cost = (String)this.get(COST);
                if (cost != null && cost.length() > 0) {
                    buf.append(" cost ");
                    buf.append(cost);
                }
                if ((migration = (String)this.get(MIGRATION)) != null && migration.length() > 0) {
                    buf.append(" accept-rip ");
                    buf.append(migration);
                }
                if ((hello = (String)this.get(HELLOINTERVAL)) != null && hello.length() > 0) {
                    buf.append(" hello-interval ");
                    buf.append(hello);
                }
                if ((dead = (String)this.get(DEADTIME)) != null && dead.length() > 0) {
                    buf.append(" dead-time ");
                    buf.append(dead);
                }
                if ((wantype = (String)this.get(WANTYPE)) != null && wantype.length() > 0) {
                    buf.append(" ");
                    buf.append(wantype);
                }
            }
            buf.append(" ");
            cmds.add(new String(buf));
        }
        return cmds.size() > start;
    }
}

