/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LEMonitorFacility_R;
import com.lucent.ra.nms.backend.LEMonitorFacility_RI;
import com.lucent.ra.nms.backend.LEMonitorSetting;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEMonitorFacility
implements LEAMObserver {
    public static final int NO_BOARD = -1;
    public static final String NO_GROUP = LEMonitorFacility_RI.NO_GROUP;
    public static final String NO_START = LEMonitorFacility_RI.NO_START;
    public static final String NO_END = LEMonitorFacility_RI.NO_END;
    public static final int DEFAULT_INTERVAL = 60000;
    Hashtable m_mons = new Hashtable();
    LEPMConnectionFacade m_facade;
    LEMonitorFacility_R m_facility;

    public LEMonitorFacility(LEPMConnectionFacade facade, LEMonitorFacility_R facility, String id) {
        this.m_facade = facade;
        this.m_facility = facility;
        LEStatusFactory.GetFactory().addObserver(id, this);
    }

    public boolean startMonitor(int entity, int board, String group, String start, String end, int interval) {
        LEMonitorSetting setting;
        boolean success = false;
        String key = LEMonitorSetting.BuildKey(entity, board, start, end, group);
        LEMonitorFacility lEMonitorFacility = this;
        synchronized (lEMonitorFacility) {
            setting = (LEMonitorSetting)this.m_mons.get(key);
            if (setting == null) {
                setting = new LEMonitorSetting(entity, board, group, start, end, key);
                this.m_mons.put(key, setting);
            }
        }
        try {
            if (this.m_facility != null) {
                success = this.m_facility.startMonitor(entity, board, group, start, end, interval);
            }
            setting.addInterval(interval);
        }
        catch (RemoteException e) {
            this.m_facade.handleRemoteException(e);
            success = false;
        }
        return success;
    }

    public void stopMonitor(int entity, int board, String group, String start, String end, int interval) {
        String key = LEMonitorSetting.BuildKey(entity, board, start, end, group);
        LEMonitorSetting setting = (LEMonitorSetting)this.m_mons.get(key);
        if (setting != null) {
            setting.removeInterval(interval);
            if (setting.getIntervalCount() == 0) {
                this.m_mons.remove(key);
            }
        }
        try {
            if (this.m_facility != null) {
                this.m_facility.stopMonitor(entity, board, group, start, end, interval);
            }
        }
        catch (RemoteException e) {
            this.m_facade.handleRemoteException(e);
        }
    }

    public void reconnect() {
        LEDSSPortMaster dss = (LEDSSPortMaster)this.m_facade.getDSS();
        this.m_facility = dss != null ? dss.getMonitorFacility() : null;
        if (this.m_facility == null) {
            return;
        }
        try {
            Enumeration enumeration = this.m_mons.elements();
            while (enumeration.hasMoreElements()) {
                this.m_facility.startMonitor((LEMonitorSetting)enumeration.nextElement());
            }
        }
        catch (RemoteException e) {
            this.m_facade.handleRemoteException(e);
        }
    }

    public void lostConnection() {
        this.m_facility = null;
    }

    public void update(LEAMFactory factory, String id, Object obj) {
        int status;
        if (obj instanceof LEStatusMessage && (status = ((LEStatusMessage)obj).getStatus()) == 1) {
            this.reconnect();
        }
    }
}

