/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LESendResponse;
import com.lucent.ra.nms.model.LEAsyncPort;
import com.lucent.ra.nms.model.LEAsyncPorts;
import com.lucent.ra.nms.model.LEBGPPeer;
import com.lucent.ra.nms.model.LEBGPPolicy;
import com.lucent.ra.nms.model.LEBGPPolicyRule;
import com.lucent.ra.nms.model.LEBinding;
import com.lucent.ra.nms.model.LEBindings;
import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEBoards;
import com.lucent.ra.nms.model.LEChannels;
import com.lucent.ra.nms.model.LEChoicenet;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LECustomPlans;
import com.lucent.ra.nms.model.LEDBNetUser;
import com.lucent.ra.nms.model.LEDLCI;
import com.lucent.ra.nms.model.LEDLCITable;
import com.lucent.ra.nms.model.LEDialScript;
import com.lucent.ra.nms.model.LEDomCustomPlan;
import com.lucent.ra.nms.model.LEDomCustomPlans;
import com.lucent.ra.nms.model.LEEthernet;
import com.lucent.ra.nms.model.LEEthernets;
import com.lucent.ra.nms.model.LEGlobal;
import com.lucent.ra.nms.model.LEGroup;
import com.lucent.ra.nms.model.LEGroups;
import com.lucent.ra.nms.model.LEHost;
import com.lucent.ra.nms.model.LEHostOverrides;
import com.lucent.ra.nms.model.LEHosts;
import com.lucent.ra.nms.model.LEIMT;
import com.lucent.ra.nms.model.LEIPPool;
import com.lucent.ra.nms.model.LEIPPools;
import com.lucent.ra.nms.model.LEIPRange;
import com.lucent.ra.nms.model.LEIPRanges;
import com.lucent.ra.nms.model.LEIPSecProfile;
import com.lucent.ra.nms.model.LEIPSecProfileRule;
import com.lucent.ra.nms.model.LEIPSecProfiles;
import com.lucent.ra.nms.model.LEISDNPort;
import com.lucent.ra.nms.model.LEISDNPorts;
import com.lucent.ra.nms.model.LEIntlCustomPlan;
import com.lucent.ra.nms.model.LEIntlCustomPlans;
import com.lucent.ra.nms.model.LEL2TP;
import com.lucent.ra.nms.model.LELine;
import com.lucent.ra.nms.model.LELines;
import com.lucent.ra.nms.model.LELocalIPAddress;
import com.lucent.ra.nms.model.LELocation;
import com.lucent.ra.nms.model.LELocations;
import com.lucent.ra.nms.model.LELoginUser;
import com.lucent.ra.nms.model.LEModemConfig;
import com.lucent.ra.nms.model.LEModems;
import com.lucent.ra.nms.model.LEMuxChannel;
import com.lucent.ra.nms.model.LENATMap;
import com.lucent.ra.nms.model.LENATMapRule;
import com.lucent.ra.nms.model.LENATMaps;
import com.lucent.ra.nms.model.LENetUser;
import com.lucent.ra.nms.model.LENetworkRanges;
import com.lucent.ra.nms.model.LENumberingPlan;
import com.lucent.ra.nms.model.LEOSPFArea;
import com.lucent.ra.nms.model.LEOrderedList;
import com.lucent.ra.nms.model.LEPVC;
import com.lucent.ra.nms.model.LEPVCs;
import com.lucent.ra.nms.model.LEParallelPort;
import com.lucent.ra.nms.model.LEParallelPorts;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LEPorts;
import com.lucent.ra.nms.model.LEPrefixes;
import com.lucent.ra.nms.model.LEPriCustomPlan;
import com.lucent.ra.nms.model.LEPriCustomPlans;
import com.lucent.ra.nms.model.LERadius;
import com.lucent.ra.nms.model.LERoute;
import com.lucent.ra.nms.model.LESNMPHosts;
import com.lucent.ra.nms.model.LESubInterface;
import com.lucent.ra.nms.model.LESubInterfaces;
import com.lucent.ra.nms.model.LESyncPort;
import com.lucent.ra.nms.model.LESyncPorts;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.model.LEUsers;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LENetmask;
import com.lucent.ra.nms.util.LEOctets;
import com.lucent.ra.nms.util.LETokenizer;
import java.util.StringTokenizer;

public class LEPMEntityParser {
    public static final String MCPU_EMPTY = "0";
    public static final String MCPU_PRESENT = "1";
    public static final String MCPU_MGR_PM4 = "3";
    public static final String MCPU_PM4_QT1 = "5";
    public static final String MCPU_PM4_TE1 = "6";
    public static final String MCPU_T3MX = "7";
    public static final String MCPU_ETHER = "8";
    public static final String MCPU_E3MX = "9";
    public static final String MCPU_T3_CLR = "10";
    public static final String MCPU_LNS = "11";
    public static final String MCPU_T3_MUXR = "12";
    public static final String MCPU_E3_MUXR = "13";
    public static final String MCPU_100E_2P = "14";
    public static final String MCPU_T3_ATM = "15";
    public static final String MCPU_E3_ATM = "16";
    public static final String MCPU_E3_CLR = "17";
    public static final String MCPU_STS1 = "18";
    public static final String MCPU_STS1_R = "19";
    public static final String MCPU_HSSI = "20";
    public static final String MCPU_PCT = "21";
    public static final String ASYNC_PORT = "async";
    public static final String ISDN_PORT = "isdn";
    public static final String PARA_PORT = "parallel";
    public static final String SYNC_PORT = "sync";
    public static final String X_PORT_PRE = "X";

    public static boolean Parse(String key, LEDSSPortMaster dss, LEPortMaster pm) {
        String send = key;
        if (key.equals("1048580") || key.equals("1048581") || key.equals("1048582")) {
            return LEPMEntityParser.Parse(dss, pm.getConfig("1048577"), key, send);
        }
        return LEPMEntityParser.Parse(dss, pm.getConfig(key), key, send);
    }

    public static boolean Parse(String key, String board_id, LEDSSPortMaster dss, LEPortMaster pm) {
        String send = String.valueOf(key) + " " + 275 + " " + board_id;
        return LEPMEntityParser.Parse(dss, pm.getConfig("2555904"), key, send);
    }

    public static boolean Parse(LEDSSPortMaster dss, LEConfig config, String key, String send) {
        boolean success = true;
        try {
            LESendResponse resp = dss.send((byte)31, (short)send.length(), send, true);
            success = resp.successful();
            while (success && LEPMEntityParser.Parse(key, config, resp.getStreamTok())) {
                resp = dss.recv(true);
                success = resp.successful();
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            success = false;
        }
        dss.done();
        return success;
    }

    public static boolean Parse(String key, LEConfig config, LETokenizer tok) {
        int entity = 0;
        try {
            entity = Integer.parseInt(key);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        boolean more = false;
        switch (entity) {
            case 0x210000: {
                more = LEPMEntityParser.ParseGlobal(config, tok);
                break;
            }
            case 327680: {
                more = LEPMEntityParser.ParseSyslog(config, tok);
                break;
            }
            case 0x150000: {
                more = LEPMEntityParser.ParseSNMP(config, tok);
                break;
            }
            case 0x100000: {
                more = LEPMEntityParser.ParseOSPF(config, tok);
                break;
            }
            case 524288: {
                more = LEPMEntityParser.ParseOSPFAreas(config, tok);
                break;
            }
            case 0x140000: {
                more = LEPMEntityParser.ParseRoutes(config, tok);
                break;
            }
            case 0x130000: {
                more = LEPMEntityParser.ParseHosts(config, tok);
                break;
            }
            case 196608: {
                more = LEPMEntityParser.ParseModems(config, tok);
                break;
            }
            case 0x500000: {
                more = LEPMEntityParser.ParseModemTable(config, tok);
                break;
            }
            case 131072: {
                more = LEPMEntityParser.ParseLines(config, tok);
                break;
            }
            case 0x260000: {
                more = LEPMEntityParser.ParseSubInterface(config, tok);
                break;
            }
            case 0x270000: {
                more = LEPMEntityParser.ParseBoards(config, tok);
                break;
            }
            case 0x1A0000: {
                more = LEPMEntityParser.ParseLocations(config, tok);
                break;
            }
            case 262144: {
                more = LEPMEntityParser.ParsePorts(config, tok);
                break;
            }
            case 0x290000: {
                more = LEPMEntityParser.ParseNATMaps(config, tok);
                break;
            }
            case 720896: {
                more = LEPMEntityParser.ParseEthernets(config, tok);
                break;
            }
            case 0x1C0000: {
                more = LEPMEntityParser.ParseUsers(config, tok);
                break;
            }
            case 0x310000: {
                more = LEPMEntityParser.ParseUserPasswords(config, tok);
                break;
            }
            case 0x220000: {
                more = LEPMEntityParser.ParseRadius(config, tok);
                break;
            }
            case 0x170000: {
                more = LEPMEntityParser.ParseChoiceNet(config, tok);
                break;
            }
            case 0x320000: {
                more = LEPMEntityParser.ParseSecrets(config, tok);
                break;
            }
            case 589824: {
                more = LEPMEntityParser.ParseBGP(config, tok);
                break;
            }
            case 0x160000: {
                more = LEPMEntityParser.ParseBGPPeers(config, tok);
                break;
            }
            case 0x300000: {
                more = LEPMEntityParser.ParseBGPPolicies(config, tok);
                break;
            }
            case 0x250000: {
                more = LEPMEntityParser.ParseSAs(config, tok);
                break;
            }
            case 0x390000: {
                more = LEPMEntityParser.ParseIPSecProfiles(config, tok);
                break;
            }
            case 3670021: {
                more = LEPMEntityParser.ParseIPPools(config, tok);
                break;
            }
            case 3670022: {
                more = LEPMEntityParser.ParseIMT(config, tok);
                break;
            }
            case 3670023: {
                more = LEPMEntityParser.ParseLocalIPAddresses(config, tok);
                break;
            }
            case 0x350000: {
                more = LEPMEntityParser.ParseL2TP(config, tok);
                break;
            }
            case 0x100001: {
                more = LEPMEntityParser.ParseNumberingPlan(config, tok);
                break;
            }
            case 0x100002: {
                more = LEPMEntityParser.ParseGateway(config, tok);
                break;
            }
            case 0x100004: {
                more = LEPMEntityParser.ParseDomCustPlans(config, tok);
                break;
            }
            case 0x100005: {
                more = LEPMEntityParser.ParseIntlCustPlans(config, tok);
                break;
            }
            case 0x100006: {
                more = LEPMEntityParser.ParsePrivateCustPlans(config, tok);
                break;
            }
            case 0x380003: {
                more = LEPMEntityParser.ParseMuxChannels(config, tok);
                break;
            }
            case 0x400007: {
                more = LEPMEntityParser.ParseATMPVCs(config, tok);
                break;
            }
            case 3670032: {
                more = LEPMEntityParser.ParseDHCP(config, tok);
                break;
            }
            default: {
                LEDebug.getLog().logln(20, "No parser for entity: " + entity);
            }
        }
        return more;
    }

    public static boolean ParseNumberingPlan(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            block7: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x100001: {
                        tok.getNextQuotedString();
                        config.getConfig("1048580");
                        config.getConfig("1048581");
                        config.getConfig("1048582");
                        break;
                    }
                    case 61440: 
                    case 61441: 
                    case 61442: 
                    case 61443: 
                    case 61444: 
                    case 61445: 
                    case 61446: 
                    case 61447: 
                    case 61448: 
                    case 61449: 
                    case 61450: 
                    case 61451: 
                    case 61452: 
                    case 61453: 
                    case 61460: 
                    case 61461: 
                    case 61462: 
                    case 61473: 
                    case 61474: 
                    case 61475: 
                    case 61476: 
                    case 61477: 
                    case 61495: 
                    case 61501: 
                    case 61502: 
                    case 61503: {
                        String tmp = tok.getNextQuotedString();
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block7;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Numbering Plan", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseDomCustPlans(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LECustomPlans plans = null;
            LEDomCustomPlan plan = null;
            LEOrderedList prefixes = null;
            boolean done = false;
            block10: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x100004: {
                        tok.getNextQuotedString();
                        if (!(config instanceof LENumberingPlan)) continue block10;
                        plans = (LEDomCustomPlans)config.get("1048580");
                        break;
                    }
                    case 61491: {
                        String tmp = tok.getNextQuotedString();
                        if (plans == null || (plan = (LEDomCustomPlan)plans.getConfig(tmp)) == null) continue block10;
                        prefixes = (LEPrefixes)plan.getConfig("61492");
                        prefixes.clearList();
                        break;
                    }
                    case 61494: {
                        String tmp = tok.getNextQuotedString();
                        if (plan == null) continue block10;
                        plan.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 61493: {
                        String tmp = tok.getNextQuotedString();
                        String tmp1 = tmp.replace('\'', '\"');
                        if (plan == null) continue block10;
                        plan.setField(Integer.toString(attribute), tmp1);
                        break;
                    }
                    case 61492: {
                        String tmp = tok.getNextQuotedString();
                        if (prefixes == null) continue block10;
                        prefixes.addField(tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block10;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Domestic Custom Plan", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseIntlCustPlans(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LECustomPlans plans = null;
            LEIntlCustomPlan plan = null;
            LEOrderedList prefixes = null;
            boolean done = false;
            block10: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x100005: {
                        tok.getNextQuotedString();
                        if (!(config instanceof LENumberingPlan)) continue block10;
                        plans = (LEIntlCustomPlans)config.get("1048581");
                        break;
                    }
                    case 61491: {
                        String tmp = tok.getNextQuotedString();
                        if (plans == null || (plan = (LEIntlCustomPlan)plans.getConfig(tmp)) == null) continue block10;
                        prefixes = (LEPrefixes)plan.getConfig("61492");
                        prefixes.clearList();
                        break;
                    }
                    case 61494: {
                        String tmp = tok.getNextQuotedString();
                        if (plan == null) continue block10;
                        plan.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 61493: {
                        String tmp = tok.getNextQuotedString();
                        String tmp1 = tmp.replace('\'', '\"');
                        if (plan == null) continue block10;
                        plan.setField(Integer.toString(attribute), tmp1);
                        break;
                    }
                    case 61492: {
                        String tmp = tok.getNextQuotedString();
                        if (prefixes == null) continue block10;
                        prefixes.addField(tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block10;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("International Custom Plan", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParsePrivateCustPlans(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LECustomPlans plans = null;
            LEPriCustomPlan plan = null;
            LEOrderedList prefixes = null;
            boolean done = false;
            block10: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x100006: {
                        tok.getNextQuotedString();
                        if (!(config instanceof LENumberingPlan)) continue block10;
                        plans = (LEPriCustomPlans)config.get("1048582");
                        break;
                    }
                    case 61491: {
                        String tmp = tok.getNextQuotedString();
                        if (plans == null || (plan = (LEPriCustomPlan)plans.getConfig(tmp)) == null) continue block10;
                        prefixes = (LEPrefixes)plan.getConfig("61492");
                        prefixes.clearList();
                        break;
                    }
                    case 61494: {
                        String tmp = tok.getNextQuotedString();
                        if (plan == null) continue block10;
                        plan.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 61493: {
                        String tmp = tok.getNextQuotedString();
                        String tmp1 = tmp.replace('\'', '\"');
                        if (plan == null) continue block10;
                        plan.setField(Integer.toString(attribute), tmp1);
                        break;
                    }
                    case 61492: {
                        String tmp = tok.getNextQuotedString();
                        if (prefixes == null) continue block10;
                        prefixes.addField(tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block10;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Private Custom Plan", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseGateway(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            block7: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x100002: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 61465: 
                    case 61466: 
                    case 61467: 
                    case 61468: 
                    case 61469: 
                    case 61472: 
                    case 61478: 
                    case 61479: 
                    case 61480: 
                    case 61481: 
                    case 61482: 
                    case 61483: 
                    case 61484: 
                    case 61485: 
                    case 61486: 
                    case 61487: 
                    case 61488: 
                    case 61489: 
                    case 61490: 
                    case 61496: 
                    case 61497: 
                    case 61498: 
                    case 61499: 
                    case 61500: 
                    case 61504: 
                    case 61505: 
                    case 61506: 
                    case 61507: 
                    case 61508: 
                    case 61510: 
                    case 61511: 
                    case 61514: 
                    case 61515: 
                    case 61516: 
                    case 61517: {
                        String tmp = tok.getNextQuotedString();
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block7;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Gateway", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseRoutes(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig route = null;
            boolean done = false;
            String destination = null;
            String gateway = null;
            String source = null;
            String type = null;
            block12: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x140000: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block12;
                        destination = tmp;
                        break;
                    }
                    case 74: {
                        destination = tok.getNextQuotedString();
                        break;
                    }
                    case 75: {
                        gateway = tok.getNextQuotedString();
                        break;
                    }
                    case 77: {
                        source = tok.getNextQuotedString().toLowerCase();
                        break;
                    }
                    case 78: {
                        type = tok.getNextQuotedString().toLowerCase();
                        break;
                    }
                    case 82: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        route = null;
                        if (source != null && source.equals("local") && tmp != null && tmp.equals("static") && destination != null) {
                            route = (LERoute)config.getConfig(destination);
                            if (gateway != null) {
                                route.setField(LERoute.GATEWAY, gateway);
                            }
                            if (type != null) {
                                route.setField(LERoute.TYPE, type);
                            }
                            route.setField(LERoute.SOURCE, source);
                            route.setField(LERoute.STATUS, tmp);
                        }
                        destination = null;
                        gateway = null;
                        source = null;
                        type = null;
                        break;
                    }
                    case 79: 
                    case 81: 
                    case 83: 
                    case 84: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        if (route == null) continue block12;
                        route.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block12;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Routes", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseGlobal(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            block13: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x210000: {
                        tok.getNextQuotedString();
                        if (config == null) continue block13;
                        config.setField("password", "");
                        break;
                    }
                    case 36: 
                    case 57: 
                    case 75: 
                    case 87: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 195: 
                    case 199: 
                    case 220: 
                    case 221: 
                    case 275: 
                    case 529: 
                    case 530: {
                        String tmp = tok.getNextQuotedString();
                        if (config == null) continue block13;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 181: 
                    case 197: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("on")) {
                            config.setField(Integer.toString(attribute), "enable");
                            break;
                        }
                        config.setField(Integer.toString(attribute), "disable");
                        break;
                    }
                    case 146: {
                        String tmp = tok.getNextQuotedString();
                        if (config == null) continue block13;
                        config.setField(Integer.toString(attribute), tmp);
                        if (!tmp.startsWith("7.")) continue block13;
                        config.setField("rip-password", "");
                        break;
                    }
                    case 178: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 280: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals(MCPU_EMPTY)) {
                            config.setField(Integer.toString(attribute), "pm4");
                            break;
                        }
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 281: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals(MCPU_EMPTY)) {
                            config.setField(Integer.toString(attribute), "60");
                            break;
                        }
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 134: {
                        String tmp = tok.getNextQuotedString();
                        if (config == null) continue block13;
                        config.setField("callcheck-password", tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block13;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Global", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseRadius(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            block9: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x220000: {
                        tok.getNextQuotedString();
                        if (config == null) continue block9;
                        config.setField("secret", "");
                        break;
                    }
                    case 12: 
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: 
                    case 216: 
                    case 218: 
                    case 278: 
                    case 282: 
                    case 283: {
                        String tmp = tok.getNextQuotedString();
                        if (config == null) continue block9;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 212: 
                    case 213: 
                    case 217: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals(MCPU_EMPTY)) {
                            tmp = "1645";
                        }
                        if (config == null) continue block9;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 214: 
                    case 215: 
                    case 219: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals(MCPU_EMPTY)) {
                            tmp = "1646";
                        }
                        if (config == null) continue block9;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block9;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("RADIUS", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseChoiceNet(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x170000: {
                        tok.getNextQuotedString();
                        if (config == null) continue block8;
                        config.setField("choicenet-secret", "");
                        break;
                    }
                    case 208: 
                    case 209: {
                        String tmp = tok.getNextQuotedString();
                        if (config == null) continue block8;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 212: 
                    case 213: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals(MCPU_EMPTY)) {
                            tmp = "1647";
                        }
                        if (config == null) continue block8;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("ChoiceNet", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseSyslog(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            String log = null;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 327680: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block8;
                        log = tmp;
                        break;
                    }
                    case 91: {
                        log = tok.getNextQuotedString();
                        break;
                    }
                    case 90: {
                        String facility = tok.getNextQuotedString();
                        if (log == null) continue block8;
                        config.setField(log, facility);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Syslog", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseSNMP(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LESNMPHosts hosts = null;
            boolean done = false;
            String key = null;
            block16: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x150000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 17: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 87: {
                        config.setField("sysname", tok.getNextQuotedString());
                        break;
                    }
                    case 85: {
                        config.setField("read", tok.getNextQuotedString());
                        hosts = (LESNMPHosts)config.getConfig("readhost");
                        hosts.clearList();
                        key = "readtype";
                        break;
                    }
                    case 86: {
                        config.setField("write", tok.getNextQuotedString());
                        hosts = (LESNMPHosts)config.getConfig("writehost");
                        hosts.clearList();
                        key = "writetype";
                        break;
                    }
                    case 12: {
                        int count = tok.getNextInt();
                        switch (count) {
                            case -1: {
                                if (key != null) {
                                    config.setField(key, "any");
                                }
                                if (hosts == null) continue block16;
                                hosts.setType(0);
                                break;
                            }
                            case 0: {
                                if (key != null) {
                                    config.setField(key, "none");
                                }
                                if (hosts == null) continue block16;
                                hosts.setType(1);
                                break;
                            }
                            default: {
                                if (key != null) {
                                    config.setField(key, "specified");
                                }
                                if (hosts == null) continue block16;
                                hosts.setType(2);
                                break;
                            }
                        }
                        continue block16;
                    }
                    case 3: {
                        String name = tok.getNextQuotedString();
                        if (name.endsWith(".in-addr.arpa")) {
                            name = LEPMEntityParser.fixHostname(name);
                        }
                        if (hosts == null) continue block16;
                        hosts.addField(name);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block16;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("SNMP", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    static String fixHostname(String name) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tz = new StringTokenizer(name, ".");
        buf.insert(0, tz.nextToken());
        buf.insert(0, '.');
        buf.insert(0, tz.nextToken());
        buf.insert(0, '.');
        buf.insert(0, tz.nextToken());
        buf.insert(0, '.');
        buf.insert(0, tz.nextToken());
        return buf.toString();
    }

    public static boolean ParseOSPF(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            block7: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x100000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 97: 
                    case 100: {
                        String tmp = tok.getNextQuotedString();
                        if (config == null) continue block7;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block7;
                        more = true;
                        break;
                    }
                    default: {
                        tok.getNextQuotedString();
                        LEDebug.getLog().logln(20, "Bad OSPF attribute: " + attribute);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseOSPFAreas(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEOSPFArea area = null;
            LETable ranges = null;
            boolean done = false;
            String advertise = null;
            block14: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 524288: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0 || tmp.equals(MCPU_EMPTY)) continue block14;
                        area = (LEOSPFArea)config.getConfig(tmp);
                        ranges = (LENetworkRanges)area.getConfig("range");
                        break;
                    }
                    case 9: {
                        String tmp = tok.getNextQuotedString();
                        area = (LEOSPFArea)config.getConfig(tmp);
                        ranges = (LENetworkRanges)area.getConfig("range");
                        break;
                    }
                    case 12: {
                        String tmp = tok.getNextQuotedString();
                        int count = Integer.parseInt(tmp);
                        break;
                    }
                    case 101: {
                        String tmp = tok.getNextQuotedString();
                        if (area == null) continue block14;
                        if (tmp.equalsIgnoreCase("md5")) {
                            area.setField("AuthType", "md5");
                        } else if (tmp.equalsIgnoreCase("none")) {
                            area.setField("AuthType", "none");
                        } else {
                            area.setField("AuthType", "password");
                        }
                        if (!tmp.equalsIgnoreCase("md5")) {
                            area.setField("AuthID", "");
                            area.setField("AuthKey", "");
                        }
                        area.setField("password", "");
                        break;
                    }
                    case 99: {
                        String tmp = tok.getNextQuotedString();
                        if (area == null) continue block14;
                        area.setField("AuthID", tmp);
                        break;
                    }
                    case 102: {
                        String type;
                        String tmp = tok.getNextQuotedString();
                        int len = tmp.length();
                        StringBuffer buf = new StringBuffer(tmp);
                        if (area == null || (type = (String)area.get("AuthType")) == null) continue block14;
                        if (type.equals("md5")) {
                            area.setField("AuthKey", buf.toString());
                            break;
                        }
                        if (!type.equals("password")) continue block14;
                        area.setField("password", buf.toString());
                        break;
                    }
                    case 103: {
                        String tmp = tok.getNextQuotedString();
                        if (area == null) continue block14;
                        if (tmp.equalsIgnoreCase("external")) {
                            area.setField("AreaType", "external");
                            break;
                        }
                        if (tmp.equalsIgnoreCase("stub")) {
                            area.setField("AreaType", "stub");
                            break;
                        }
                        area.setField("AreaType", "nssa");
                        break;
                    }
                    case 117: {
                        String tmp;
                        advertise = tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 104: {
                        String tmp = tok.getNextQuotedString();
                        if (ranges == null || advertise == null) continue block14;
                        ranges.setField(tmp, advertise);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block14;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("OSPF Area", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseHosts(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEHosts hosts = (LEHosts)config;
            hosts.clearList();
            String ipaddress = null;
            boolean done = false;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x130000: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block8;
                        ipaddress = tmp;
                        break;
                    }
                    case 9: {
                        ipaddress = tok.getNextQuotedString();
                        break;
                    }
                    case 3: {
                        String hostname = tok.getNextQuotedString();
                        if (ipaddress == null) continue block8;
                        LEHost host = (LEHost)hosts.addConfig();
                        host.setField("address", ipaddress);
                        host.setField("hostname", hostname);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Hosts", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseModems(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEModems modems = null;
            if (config instanceof LEModems) {
                modems = (LEModems)config;
            }
            String name = null;
            boolean done = false;
            block9: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: {
                        LEBoard board;
                        String tmp = tok.getNextQuotedString();
                        if (!(config instanceof LEBoards) || (board = (LEBoard)config.get(tmp)) == null) continue block9;
                        modems = (LEModems)board.get(LEBoard.MODEMS);
                        break;
                    }
                    case 196608: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block9;
                        name = "M" + tmp;
                        break;
                    }
                    case 40: {
                        name = "M" + tok.getNextQuotedString();
                        break;
                    }
                    case 41: {
                        String state = tok.getNextQuotedString();
                        if (name == null) continue block9;
                        modems.setField(name, state);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block9;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Modems", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseModemTable(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig modem = null;
            boolean done = false;
            block10: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x500000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 768: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block10;
                        modem = (LEModemConfig)config.getConfig(tmp);
                        break;
                    }
                    case 771: {
                        String tmp = tok.getNextQuotedString();
                        if (modem == null) continue block10;
                        if (tmp.equals(MCPU_EMPTY)) {
                            modem.setField("771", "user");
                            break;
                        }
                        modem.setField("771", "system");
                        break;
                    }
                    case 769: 
                    case 770: {
                        String tmp = tok.getNextQuotedString();
                        if (modem == null) continue block10;
                        modem.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 772: {
                        String tmp = LEPMEntityParser.NormalizeCarets(tok.getNextQuotedString());
                        if (modem == null) continue block10;
                        modem.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block10;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Routes", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static String NormalizeCarets(String str) {
        int ptr = str.length() - 1;
        char ch = str.charAt(ptr);
        while (ch == '\u0001' || ch == '\u0002') {
            ch = str.charAt(--ptr);
        }
        StringBuffer buf = new StringBuffer(++ptr);
        int i = 0;
        while (i < ptr) {
            ch = str.charAt(i);
            if (ch == '\u0001' || ch == '\u0002') {
                buf.append('^');
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return new String(buf);
    }

    public static boolean ParseMuxChannels(LEConfig config, LETokenizer tok) {
        boolean more = false;
        boolean done = false;
        String num = "";
        try {
            LEChannels channels = null;
            if (config instanceof LEChannels) {
                channels = (LEChannels)config;
            }
            block9: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: {
                        LEBoard board;
                        String tmp = tok.getNextQuotedString();
                        if (!(config instanceof LEBoards) || (board = (LEBoard)config.get(tmp)) == null) continue block9;
                        channels = (LEChannels)board.get("3670019");
                        break;
                    }
                    case 0x380003: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 416: {
                        num = tok.getNextQuotedString();
                        break;
                    }
                    case 462: {
                        LEMuxChannel channel;
                        String tmp = tok.getNextQuotedString();
                        if (channels == null || (channel = (LEMuxChannel)channels.getConfig(num)) == null) continue block9;
                        channel.setField("462", tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block9;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Mux Channels", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseLines(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LELines lines = null;
            if (config instanceof LELines) {
                lines = (LELines)config;
            }
            LEConfig line = null;
            LETable groups = null;
            LEGroup group = null;
            boolean done = false;
            block15: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: {
                        LEBoard board;
                        String tmp = tok.getNextQuotedString();
                        if (!(config instanceof LEBoards) || (board = (LEBoard)config.get(tmp)) == null) continue block15;
                        lines = (LELines)board.get(LEBoard.LINES);
                        break;
                    }
                    case 131072: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block15;
                        line = (LELine)lines.getConfig("line" + tmp);
                        groups = (LEGroups)line.getConfig("groups");
                        break;
                    }
                    case 11: {
                        String tmp = "line" + tok.getNextQuotedString();
                        line = (LELine)lines.getConfig(tmp);
                        groups = (LEGroups)line.getConfig("groups");
                        break;
                    }
                    case 17: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 37: 
                    case 39: 
                    case 472: 
                    case 474: 
                    case 475: 
                    case 476: 
                    case 477: 
                    case 61463: 
                    case 61464: 
                    case 61470: 
                    case 61471: 
                    case 61512: 
                    case 61513: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        if (line == null) continue block15;
                        line.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 478: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        if (line == null) continue block15;
                        if (tmp.endsWith(":0")) {
                            line.setField("477", "local");
                        }
                        line.setField("478", tmp);
                        break;
                    }
                    case 53: {
                        String tmp = tok.getNextQuotedString();
                        if (line == null) continue block15;
                        if (tmp.equals("down")) {
                            tmp = "up";
                        } else if (tmp.equals("up")) {
                            tmp = "down";
                        }
                        line.setField("53", tmp.toLowerCase());
                        break;
                    }
                    case 129: {
                        String tmp = tok.getNextQuotedString();
                        if (groups == null) continue block15;
                        group = (LEGroup)groups.getConfig(tmp);
                        break;
                    }
                    case 130: 
                    case 131: 
                    case 132: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        if (group == null) continue block15;
                        group.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 128: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 38: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("r2 custom") || tmp.equals("R2 custom")) {
                            tmp = "r2custom";
                        } else if (tmp.equals("r2mf generic") || tmp.equals("R2MF generic")) {
                            tmp = "r2generic";
                        }
                        if (line == null) continue block15;
                        line.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block15;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Lines", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseSubInterface(LEConfig config, LETokenizer tok) {
        more = false;
        sub_is = (LESubInterfaces)config;
        sub = null;
        done = false;
        try {
            block8: while (true) lbl-1000:
            // 9 sources

            {
                if (done) {
                    return more;
                }
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x260000: {
                        tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block8;
                        sub = (LESubInterface)sub_is.getConfig(tmp);
                        ** break;
                    }
                    case 237: {
                        tmp = tok.getNextQuotedString();
                        sub = (LESubInterface)sub_is.getConfig(tmp);
                        ** break;
                    }
                    case 9: 
                    case 15: 
                    case 186: 
                    case 260: {
                        tmp = tok.getNextQuotedString();
                        if (sub == null) continue block8;
                        sub.setField(Integer.toString(attribute), tmp);
                        ** break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("SubInterfaces", attribute, tok.getNextQuotedString());
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseBoards(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig board = null;
            String board_id = null;
            boolean done = false;
            block11: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x270000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 275: {
                        board_id = tok.getNextQuotedString();
                        board = null;
                        break;
                    }
                    case 272: {
                        String tmp = tok.getNextQuotedString();
                        if (board_id != null && !tmp.equals(MCPU_EMPTY) && (board = (LEBoard)config.getConfig(board_id)) != null) {
                            if (tmp.equals(MCPU_PRESENT)) {
                                tmp = "Present";
                            } else if (tmp.equals(MCPU_MGR_PM4)) {
                                tmp = "System Manager";
                                board.getConfig(LEBoard.PORTS);
                                board.getConfig(LEBoard.ETHERNETS);
                            } else if (tmp.equals(MCPU_PM4_QT1)) {
                                tmp = "Quad T1";
                                board.getConfig(LEBoard.PORTS);
                                board.getConfig(LEBoard.LINES);
                                board.getConfig(LEBoard.MODEMS);
                                board.getConfig("3670022");
                                board.getConfig(LEBoard.L2TP);
                            } else if (tmp.equals(MCPU_PM4_TE1)) {
                                tmp = "Tri E1";
                                board.getConfig(LEBoard.PORTS);
                                board.getConfig(LEBoard.LINES);
                                board.getConfig(LEBoard.MODEMS);
                                board.getConfig("3670022");
                                board.getConfig(LEBoard.L2TP);
                            } else if (tmp.equals(MCPU_T3MX)) {
                                tmp = "T3 Mux";
                                board.getConfig("3670019");
                            } else if (tmp.equals(MCPU_ETHER)) {
                                tmp = "Ethernet";
                                board.getConfig(LEBoard.ETHERNETS);
                            } else if (tmp.equals(MCPU_E3MX)) {
                                tmp = "E3 Mux";
                                board.getConfig("3670019");
                            } else if (tmp.equals(MCPU_T3_CLR)) {
                                tmp = "T3 Clear";
                            } else if (tmp.equals(MCPU_LNS)) {
                                tmp = "LNS";
                            } else if (tmp.equals(MCPU_T3_MUXR)) {
                                tmp = "T3 Mux Redundant";
                            } else if (tmp.equals(MCPU_E3_MUXR)) {
                                tmp = "E3 Mux Redundant";
                            } else if (tmp.equals(MCPU_100E_2P)) {
                                tmp = "Dual Ethernet";
                            } else if (tmp.equals(MCPU_T3_ATM)) {
                                tmp = "T3 ATM";
                                board.getConfig("4194311");
                            } else if (tmp.equals(MCPU_E3_ATM)) {
                                tmp = "E3 ATM";
                                board.getConfig("4194311");
                            } else if (tmp.equals(MCPU_E3_CLR)) {
                                tmp = "E3 Clear";
                            } else if (tmp.equals(MCPU_STS1)) {
                                tmp = "STS1 Mux";
                                board.getConfig("3670019");
                            } else {
                                tmp = tmp.equals(MCPU_STS1_R) ? "STS1 Mux Redundant" : (tmp.equals(MCPU_HSSI) ? "HSSI" : (tmp.equals(MCPU_PCT) ? "PCT" : "Unknown"));
                            }
                        }
                        if (board == null) continue block11;
                        board.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 17: 
                    case 164: 
                    case 165: 
                    case 172: 
                    case 273: 
                    case 274: 
                    case 276: 
                    case 461: 
                    case 472: 
                    case 530: {
                        String tmp = tok.getNextQuotedString();
                        if (board == null) continue block11;
                        board.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 279: {
                        String tmp = tok.getNextQuotedString();
                        if (board == null) continue block11;
                        if (LEBoard.IsDaughter(board_id)) {
                            tmp = "on";
                        }
                        board.setField(LEBoard.POWER, tmp);
                        break;
                    }
                    case 473: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block11;
                        char start = tmp.charAt(0);
                        tmp = start == 'e' || start == 'E' ? "enable" : "disable";
                        if (board == null) continue block11;
                        board.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block11;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Boards", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseLocations(LEConfig config, LETokenizer tok) {
        boolean more = false;
        LELocations locs = (LELocations)config;
        LELocation loc = null;
        boolean done = false;
        LEDLCITable ip_table = null;
        LEDLCITable ipx_table = null;
        String ipnum = null;
        String ipxnum = null;
        LEDialScript script = null;
        try {
            boolean rip_broad = false;
            boolean rip_listen = false;
            boolean rip2_broad = false;
            boolean rip2_multi = false;
            boolean rip2_listen = false;
            block23: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x1A0000: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block23;
                        loc = (LELocation)locs.getConfig(tmp);
                        break;
                    }
                    case 237: {
                        String tmp = tok.getNextQuotedString();
                        loc = (LELocation)locs.getConfig(tmp);
                        break;
                    }
                    case 2: 
                    case 9: 
                    case 15: 
                    case 74: 
                    case 129: 
                    case 170: 
                    case 177: 
                    case 193: 
                    case 194: 
                    case 198: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 292: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 496: 
                    case 497: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 525: 
                    case 533: 
                    case 534: {
                        String tmp = tok.getNextQuotedString();
                        if (loc == null) continue block23;
                        loc.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 288: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("on_demand")) {
                            tmp = "on-demand";
                        }
                        if (loc == null) continue block23;
                        loc.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 189: {
                        String tmp = tok.getNextQuotedString();
                        if (loc == null) continue block23;
                        if (tmp.indexOf(46) > -1) {
                            LEOctets octs = new LEOctets(tmp);
                            tmp = octs.toHexString();
                        }
                        loc.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 187: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("on")) {
                            rip_broad = true;
                            break;
                        }
                        rip_broad = false;
                        break;
                    }
                    case 188: {
                        String tmp = tok.getNextQuotedString();
                        rip_listen = tmp.equals("on");
                        if (loc == null) continue block23;
                        if (!rip_broad && !rip_listen) {
                            loc.setField("rip", "off");
                            break;
                        }
                        if (rip_broad && rip_listen) {
                            loc.setField("rip", "on");
                            break;
                        }
                        if (rip_broad && !rip_listen) {
                            loc.setField("rip", "broadcast");
                            break;
                        }
                        if (!rip_broad && rip_listen) {
                            loc.setField("rip", "listen");
                            break;
                        }
                        loc.setField("rip", "off");
                        break;
                    }
                    case 535: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("broadcast")) {
                            rip2_broad = true;
                            rip2_multi = false;
                            break;
                        }
                        if (tmp.equals("multicast")) {
                            rip2_broad = false;
                            rip2_multi = true;
                            break;
                        }
                        if (!tmp.equals("off")) continue block23;
                        rip2_broad = false;
                        rip2_multi = false;
                        break;
                    }
                    case 536: {
                        String tmp = tok.getNextQuotedString();
                        rip2_listen = tmp.equals("on");
                        if (loc == null) continue block23;
                        if (rip2_broad || rip2_multi || rip2_listen) {
                            loc.setField("rip", "v2 enabled");
                        }
                        if (rip2_multi && rip2_listen) {
                            loc.setField("rip_v2", "on");
                            break;
                        }
                        if (rip2_multi && !rip2_listen) {
                            loc.setField("rip_v2", "multicast");
                            break;
                        }
                        if (rip2_broad && rip2_listen) {
                            loc.setField("rip_v2", "v1-compatability");
                            break;
                        }
                        if (rip2_broad && !rip2_listen) {
                            loc.setField("rip_v2", "broadcast");
                            break;
                        }
                        if (rip2_listen) {
                            loc.setField("rip_v2", "listen");
                            break;
                        }
                        loc.setField("rip_v2", "on");
                        break;
                    }
                    case 72: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("")) {
                            tmp = "0.0.0.0";
                        }
                        if (loc == null) continue block23;
                        loc.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 303: {
                        String tmp = tok.getNextQuotedString();
                        if (loc == null) continue block23;
                        script = (LEDialScript)loc.getConfig("script");
                        LEDialScript.LoadScript(script, tmp);
                        loc.setField("script", script);
                        break;
                    }
                    case 304: {
                        String tmp = tok.getNextQuotedString();
                        if (loc == null) continue block23;
                        script = (LEDialScript)loc.getConfig("v25bis");
                        LEDialScript.LoadScript(script, tmp);
                        loc.setField("v25bis", script);
                        break;
                    }
                    case 339: {
                        String tmp = tok.getNextQuotedString();
                        if (loc == null) continue block23;
                        ip_table = (LEDLCITable)loc.getConfig("ipdlci");
                        break;
                    }
                    case 340: {
                        String tmp = tok.getNextQuotedString();
                        if (loc == null) continue block23;
                        ipx_table = (LEDLCITable)loc.getConfig("ipxdlci");
                        break;
                    }
                    case 305: {
                        ipnum = tok.getNextQuotedString();
                        break;
                    }
                    case 306: {
                        ipxnum = tok.getNextQuotedString();
                        break;
                    }
                    case 307: {
                        String tmp = tok.getNextQuotedString();
                        if (ipnum == null || ip_table == null) continue block23;
                        LEDLCI dlci = (LEDLCI)ip_table.getConfig(ipnum);
                        if (dlci != null) {
                            dlci.setField("address", tmp);
                        }
                        ipnum = null;
                        break;
                    }
                    case 308: {
                        String tmp = tok.getNextQuotedString();
                        if (ipxnum == null || ipx_table == null) continue block23;
                        LEDLCI dlci = (LEDLCI)ipx_table.getConfig(ipxnum);
                        if (dlci != null) {
                            dlci.setField("address", tmp);
                        }
                        ipxnum = null;
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block23;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Locations", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParsePorts(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEPorts ports = null;
            LEBoard board = null;
            LEBoards boards = null;
            if (config instanceof LEPorts) {
                ports = (LEPorts)config;
            } else if (config instanceof LEBoards) {
                boards = (LEBoards)config;
            }
            boolean done = false;
            boolean ignore = false;
            String type = null;
            int next = 0;
            block9: while (!done) {
                int attribute;
                if (next > 0) {
                    attribute = next;
                    next = 0;
                } else {
                    attribute = tok.getNextInt();
                }
                switch (attribute) {
                    case 262144: {
                        type = null;
                        tok.getNextQuotedString();
                        break;
                    }
                    case 275: {
                        type = null;
                        String tmp = tok.getNextQuotedString();
                        if (boards == null || (board = (LEBoard)boards.getConfig(tmp)) == null) continue block9;
                        ports = (LEPorts)board.getConfig(LEBoard.PORTS);
                        break;
                    }
                    case 333: {
                        type = tok.getNextQuotedString();
                        break;
                    }
                    case 1: {
                        String tmp = tok.getNextQuotedString();
                        ignore = tmp.startsWith(X_PORT_PRE);
                        if (ports == null || type == null || ignore) continue block9;
                        if (type.equals(ASYNC_PORT)) {
                            next = LEPMEntityParser.ParseAsyncPort(ports, tmp, tok);
                            break;
                        }
                        if (type.equals(ISDN_PORT)) {
                            next = LEPMEntityParser.ParseISDNPort(ports, tmp, tok);
                            break;
                        }
                        if (type.equals(PARA_PORT)) {
                            next = LEPMEntityParser.ParseParallelPort(ports, tmp, tok);
                            break;
                        }
                        if (!type.equals(SYNC_PORT)) continue block9;
                        next = LEPMEntityParser.ParseSyncPort(ports, tmp, tok);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() == 1) {
                            more = true;
                            break;
                        }
                        ignore = false;
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        if (ignore) continue block9;
                        LEPMEntityParser.LogBadAttribute("Ports", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static int ParseAsyncPort(LEPorts allPorts, String name, LETokenizer tok) {
        int attribute = 0;
        try {
            LEAsyncPorts ports = (LEAsyncPorts)allPorts.getConfig("AsyncPort");
            LEAsyncPort port = null;
            if (ports != null) {
                port = (LEAsyncPort)ports.getConfig(name);
            }
            boolean done = false;
            boolean rip_broad = false;
            boolean rip_listen = false;
            boolean rip2_broad = false;
            boolean rip2_multi = false;
            boolean rip2_listen = false;
            block12: while (!done) {
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        done = true;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 15: 
                    case 23: 
                    case 74: 
                    case 129: 
                    case 130: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 193: 
                    case 194: 
                    case 198: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 289: 
                    case 290: 
                    case 295: 
                    case 297: 
                    case 299: 
                    case 302: 
                    case 309: 
                    case 310: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 316: 
                    case 317: 
                    case 322: 
                    case 323: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 332: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 496: 
                    case 497: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 533: 
                    case 534: 
                    case 553: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block12;
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 327: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: {
                        LEHostOverrides over;
                        String tmp = tok.getNextQuotedString();
                        if (port == null || (over = (LEHostOverrides)port.getConfig("overrides")) == null) continue block12;
                        over.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 187: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("on")) {
                            rip_broad = true;
                            break;
                        }
                        rip_broad = false;
                        break;
                    }
                    case 188: {
                        String tmp = tok.getNextQuotedString();
                        rip_listen = tmp.equals("on");
                        if (port == null) continue block12;
                        if (!rip_broad && !rip_listen) {
                            port.setField("rip", "off");
                            break;
                        }
                        if (rip_broad && rip_listen) {
                            port.setField("rip", "on");
                            break;
                        }
                        if (rip_broad && !rip_listen) {
                            port.setField("rip", "broadcast");
                            break;
                        }
                        if (!rip_broad && rip_listen) {
                            port.setField("rip", "listen");
                            break;
                        }
                        port.setField("rip", "off");
                        break;
                    }
                    case 535: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("broadcast")) {
                            rip2_broad = true;
                            rip2_multi = false;
                            break;
                        }
                        if (tmp.equals("multicast")) {
                            rip2_broad = false;
                            rip2_multi = true;
                            break;
                        }
                        if (!tmp.equals("off")) continue block12;
                        rip2_broad = false;
                        rip2_multi = false;
                        break;
                    }
                    case 536: {
                        String tmp = tok.getNextQuotedString();
                        rip2_listen = tmp.equals("on");
                        if (port == null) continue block12;
                        if (rip2_broad || rip2_multi || rip2_listen) {
                            port.setField("rip", "v2 enabled");
                        }
                        if (rip2_multi && rip2_listen) {
                            port.setField("rip_v2", "on");
                            break;
                        }
                        if (rip2_multi && !rip2_listen) {
                            port.setField("rip_v2", "multicast");
                            break;
                        }
                        if (rip2_broad && rip2_listen) {
                            port.setField("rip_v2", "v1-compatability");
                            break;
                        }
                        if (rip2_broad && !rip2_listen) {
                            port.setField("rip_v2", "broadcast");
                            break;
                        }
                        if (rip2_listen) {
                            port.setField("rip_v2", "listen");
                            break;
                        }
                        port.setField("rip_v2", "on");
                        break;
                    }
                    case 72: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("")) {
                            tmp = "0.0.0.0";
                        }
                        if (port == null) continue block12;
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Async Port", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return attribute;
    }

    public static int ParseISDNPort(LEPorts allPorts, String name, LETokenizer tok) {
        int attribute = 0;
        try {
            LEISDNPorts ports = (LEISDNPorts)allPorts.getConfig("ISDNPort");
            LEISDNPort port = null;
            if (ports != null) {
                port = (LEISDNPort)ports.getConfig(name);
            }
            boolean rip_broad = false;
            boolean rip_listen = false;
            boolean rip2_broad = false;
            boolean rip2_multi = false;
            boolean rip2_listen = false;
            boolean done = false;
            block13: while (!done) {
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        done = true;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 15: 
                    case 74: 
                    case 129: 
                    case 130: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 181: 
                    case 193: 
                    case 194: 
                    case 198: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 290: 
                    case 295: 
                    case 297: 
                    case 302: 
                    case 309: 
                    case 310: 
                    case 312: 
                    case 317: 
                    case 320: 
                    case 321: 
                    case 322: 
                    case 323: 
                    case 325: 
                    case 332: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 496: 
                    case 497: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 533: 
                    case 534: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block13;
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 189: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block13;
                        LEOctets octs = new LEOctets(tmp);
                        tmp = octs.toHexString();
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 289: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 187: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("on")) {
                            rip_broad = true;
                            break;
                        }
                        rip_broad = false;
                        break;
                    }
                    case 188: {
                        String tmp = tok.getNextQuotedString();
                        rip_listen = tmp.equals("on");
                        if (port == null) continue block13;
                        if (!rip_broad && !rip_listen) {
                            port.setField("rip", "off");
                            break;
                        }
                        if (rip_broad && rip_listen) {
                            port.setField("rip", "on");
                            break;
                        }
                        if (rip_broad && !rip_listen) {
                            port.setField("rip", "broadcast");
                            break;
                        }
                        if (!rip_broad && rip_listen) {
                            port.setField("rip", "listen");
                            break;
                        }
                        port.setField("rip", "off");
                        break;
                    }
                    case 535: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("broadcast")) {
                            rip2_broad = true;
                            rip2_multi = false;
                            break;
                        }
                        if (tmp.equals("multicast")) {
                            rip2_broad = false;
                            rip2_multi = true;
                            break;
                        }
                        if (!tmp.equals("off")) continue block13;
                        rip2_broad = false;
                        rip2_multi = false;
                        break;
                    }
                    case 536: {
                        String tmp = tok.getNextQuotedString();
                        rip2_listen = tmp.equals("on");
                        if (port == null) continue block13;
                        if (rip2_broad || rip2_multi || rip2_listen) {
                            port.setField("rip", "v2 enabled");
                        }
                        if (rip2_multi && rip2_listen) {
                            port.setField("rip_v2", "on");
                            break;
                        }
                        if (rip2_multi && !rip2_listen) {
                            port.setField("rip_v2", "multicast");
                            break;
                        }
                        if (rip2_broad && rip2_listen) {
                            port.setField("rip_v2", "v1-compatability");
                            break;
                        }
                        if (rip2_broad && !rip2_listen) {
                            port.setField("rip_v2", "broadcast");
                            break;
                        }
                        if (rip2_listen) {
                            port.setField("rip_v2", "listen");
                            break;
                        }
                        port.setField("rip_v2", "on");
                        break;
                    }
                    case 72: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("")) {
                            tmp = "0.0.0.0";
                        }
                        if (port == null) continue block13;
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("ISDN Port", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return attribute;
    }

    public static int ParseParallelPort(LEPorts allPorts, String name, LETokenizer tok) {
        int attribute = 0;
        try {
            LEParallelPorts ports = (LEParallelPorts)allPorts.getConfig("ParallelPort");
            LEParallelPort port = null;
            if (ports != null) {
                port = (LEParallelPort)ports.getConfig(name);
            }
            boolean done = false;
            block6: while (!done) {
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        done = true;
                        break;
                    }
                    case 173: 
                    case 309: 
                    case 310: 
                    case 311: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block6;
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Parallel Port", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return attribute;
    }

    public static int ParseSyncPort(LEPorts allPorts, String name, LETokenizer tok) {
        int attribute = 0;
        try {
            LESyncPorts ports = (LESyncPorts)allPorts.getConfig("SyncPort");
            LESyncPort port = null;
            if (ports != null) {
                port = (LESyncPort)ports.getConfig(name);
            }
            LEDLCITable ip_table = null;
            LEDLCITable ipx_table = null;
            String ipnum = null;
            String ipxnum = null;
            boolean rip_broad = false;
            boolean rip_listen = false;
            boolean rip2_broad = false;
            boolean rip2_multi = false;
            boolean rip2_listen = false;
            boolean done = false;
            block18: while (!done) {
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        done = true;
                        break;
                    }
                    case 4: 
                    case 15: 
                    case 74: 
                    case 129: 
                    case 130: 
                    case 177: 
                    case 181: 
                    case 193: 
                    case 194: 
                    case 198: 
                    case 289: 
                    case 290: 
                    case 295: 
                    case 297: 
                    case 312: 
                    case 316: 
                    case 318: 
                    case 319: 
                    case 332: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 496: 
                    case 497: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 533: 
                    case 534: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block18;
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 189: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block18;
                        LEOctets octs = new LEOctets(tmp);
                        tmp = octs.toHexString();
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 339: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block18;
                        ip_table = (LEDLCITable)port.getConfig(LESyncPort.IP_DLCI_TAB);
                        break;
                    }
                    case 340: {
                        String tmp = tok.getNextQuotedString();
                        if (port == null) continue block18;
                        ipx_table = (LEDLCITable)port.getConfig(LESyncPort.IPX_DLCI_TAB);
                        break;
                    }
                    case 305: {
                        ipnum = tok.getNextQuotedString();
                        break;
                    }
                    case 306: {
                        ipxnum = tok.getNextQuotedString();
                        break;
                    }
                    case 307: {
                        String tmp = tok.getNextQuotedString();
                        if (ipnum == null || ip_table == null) continue block18;
                        LEDLCI dlci = (LEDLCI)ip_table.getConfig(ipnum);
                        if (dlci != null) {
                            dlci.setField("address", tmp);
                        }
                        ipnum = null;
                        break;
                    }
                    case 308: {
                        String tmp = tok.getNextQuotedString();
                        if (ipxnum == null || ipx_table == null) continue block18;
                        LEDLCI dlci = (LEDLCI)ipx_table.getConfig(ipxnum);
                        if (dlci != null) {
                            dlci.setField("address", tmp);
                        }
                        ipxnum = null;
                        break;
                    }
                    case 187: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("on")) {
                            rip_broad = true;
                            break;
                        }
                        rip_broad = false;
                        break;
                    }
                    case 188: {
                        String tmp = tok.getNextQuotedString();
                        rip_listen = tmp.equals("on");
                        if (port == null) continue block18;
                        if (!rip_broad && !rip_listen) {
                            port.setField("rip", "off");
                            break;
                        }
                        if (rip_broad && rip_listen) {
                            port.setField("rip", "on");
                            break;
                        }
                        if (rip_broad && !rip_listen) {
                            port.setField("rip", "broadcast");
                            break;
                        }
                        if (!rip_broad && rip_listen) {
                            port.setField("rip", "listen");
                            break;
                        }
                        port.setField("rip", "off");
                        break;
                    }
                    case 535: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("broadcast")) {
                            rip2_broad = true;
                            rip2_multi = false;
                            break;
                        }
                        if (tmp.equals("multicast")) {
                            rip2_broad = false;
                            rip2_multi = true;
                            break;
                        }
                        if (!tmp.equals("off")) continue block18;
                        rip2_broad = false;
                        rip2_multi = false;
                        break;
                    }
                    case 536: {
                        String tmp = tok.getNextQuotedString();
                        rip2_listen = tmp.equals("on");
                        if (port == null) continue block18;
                        if (rip2_broad || rip2_multi || rip2_listen) {
                            port.setField("rip", "v2 enabled");
                        }
                        if (rip2_multi && rip2_listen) {
                            port.setField("rip_v2", "on");
                            break;
                        }
                        if (rip2_multi && !rip2_listen) {
                            port.setField("rip_v2", "multicast");
                            break;
                        }
                        if (rip2_broad && rip2_listen) {
                            port.setField("rip_v2", "v1-compatability");
                            break;
                        }
                        if (rip2_broad && !rip2_listen) {
                            port.setField("rip_v2", "broadcast");
                            break;
                        }
                        if (rip2_listen) {
                            port.setField("rip_v2", "listen");
                            break;
                        }
                        port.setField("rip_v2", "on");
                        break;
                    }
                    case 72: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("")) {
                            tmp = "0.0.0.0";
                        }
                        if (port == null) continue block18;
                        port.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Sync Port", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return attribute;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseIPPools(LEConfig config, LETokenizer tok) {
        more = false;
        done = false;
        pools = (LEIPPools)config;
        pool = null;
        ranges = null;
        range = null;
        try {
            block11: while (true) lbl-1000:
            // 14 sources

            {
                if (done) {
                    return more;
                }
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 3670021: {
                        tmp = tok.getNextQuotedString();
                        ** break;
                    }
                    case 237: {
                        tmp = tok.getNextQuotedString();
                        pool = (LEIPPool)pools.getConfig(tmp);
                        ranges = (LEIPRanges)pool.getConfig("ranges");
                        range = null;
                        ** break;
                    }
                    case 75: {
                        tmp = tok.getNextQuotedString();
                        if (pool == null) continue block11;
                        pool.setField("75", tmp);
                        ** break;
                    }
                    case 521: {
                        tmp = tok.getNextQuotedString();
                        if (ranges == null) continue block11;
                        range = (LEIPRange)ranges.getConfig(tmp);
                        ** break;
                    }
                    case 165: {
                        tmp = tok.getNextQuotedString();
                        size = Long.parseLong(tmp);
                        cidr = LENetmask.GetCIDRFromTotal(size);
                        if (range == null) continue block11;
                        range.setField("165", tmp);
                        range.setField("15", Integer.toString(cidr));
                        ** break;
                    }
                    case 522: {
                        tmp = tok.getNextQuotedString();
                        if (range == null) continue block11;
                        range.setField("522", tmp);
                        ** break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block11;
                        more = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("IP Pools", attribute, tok.getNextQuotedString());
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseNATMaps(LEConfig config, LETokenizer tok) {
        more = false;
        done = false;
        maps = (LENATMaps)config;
        map = null;
        rule = null;
        buf = null;
        notation = 0;
        netmask = null;
        portStart = null;
        portEnd = null;
        address = null;
        addressStart = null;
        addressEnd = null;
        lhs_index = 0;
        rhs_index = 0;
        index = 0;
        try {
            block31: while (true) lbl-1000:
            // 28 sources

            {
                if (done) {
                    return more;
                }
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x290000: {
                        tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block31;
                        map = (LENATMap)maps.getConfig(tmp);
                        ** break;
                    }
                    case 237: {
                        tmp = tok.getNextQuotedString();
                        map = (LENATMap)maps.getConfig(tmp);
                        ** break;
                    }
                    case 341: {
                        tmp = tok.getNextQuotedString();
                        if (map != null) {
                            rule = (LENATMapRule)map.getConfig(tmp);
                            ** break;
                        }
                        rule = null;
                        ** break;
                    }
                    case 352: {
                        tmp = tok.getNextQuotedString();
                        if (rule == null) continue block31;
                        rule.setField("type", tmp);
                        ** break;
                    }
                    case 351: {
                        tmp = tok.getNextQuotedString();
                        if (rule == null) continue block31;
                        if (tmp.equals("off")) {
                            rule.setField("log", "off");
                            ** break;
                        }
                        rule.setField("log", "on");
                        ** break;
                    }
                    case 342: {
                        lhs_index = Integer.parseInt(tok.getNextQuotedString());
                        ** break;
                    }
                    case 343: {
                        rhs_index = Integer.parseInt(tok.getNextQuotedString()) + lhs_index;
                        ** break;
                    }
                    case 344: {
                        index = Integer.parseInt(tok.getNextQuotedString()) + 1;
                        ** break;
                    }
                    case 345: {
                        notation = Integer.parseInt(tok.getNextQuotedString());
                        ** break;
                    }
                    case 15: {
                        netmask = tok.getNextQuotedString();
                        ** break;
                    }
                    case 346: {
                        portStart = tok.getNextQuotedString();
                        ** break;
                    }
                    case 347: {
                        portEnd = tok.getNextQuotedString();
                        ** break;
                    }
                    case 348: {
                        address = tok.getNextQuotedString();
                        ** break;
                    }
                    case 349: {
                        addressStart = tok.getNextQuotedString();
                        ** break;
                    }
                    case 350: {
                        addressEnd = tok.getNextQuotedString();
                        if (rule == null) continue block31;
                        if (buf == null) {
                            buf = new StringBuffer();
                        } else {
                            buf.append(",");
                        }
                        switch (notation) {
                            case 1: {
                                buf.append(address);
                                buf.append('/');
                                buf.append(netmask);
                                break;
                            }
                            case 2: {
                                buf.append(addressStart);
                                buf.append('-');
                                buf.append(addressEnd);
                                break;
                            }
                            case 4: {
                                buf.append(addressStart);
                                break;
                            }
                            case 8: {
                                buf.append(addressStart);
                                buf.append(':');
                                buf.append(portStart);
                                break;
                            }
                            case 16: {
                                buf.append(addressStart);
                                buf.append(':');
                                buf.append(portStart);
                                buf.append('-');
                                buf.append(portEnd);
                                break;
                            }
                            case 132: {
                                buf.append("@ipaddr");
                                break;
                            }
                            case 136: {
                                buf.append("@ipaddr");
                                buf.append(':');
                                buf.append(portStart);
                                break;
                            }
                            case 144: {
                                buf.append("@ipaddr");
                                buf.append(':');
                                buf.append(portStart);
                                buf.append('-');
                                buf.append(portEnd);
                                break;
                            }
                        }
                        if (index == lhs_index) {
                            rule.setField("lhs", buf.toString());
                            buf = null;
                            ** break;
                        }
                        if (index != rhs_index) continue block31;
                        rule.setField("rhs", buf.toString());
                        buf = null;
                        ** break;
                    }
                    case 12: {
                        tmp = tok.getNextQuotedString();
                        ** break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block31;
                        more = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("NAT Maps", attribute, tok.getNextQuotedString());
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseDHCP(LEConfig config, LETokenizer tok) {
        more = false;
        done = false;
        bindings = null;
        binding = null;
        buf = new StringBuffer();
        notation = 0;
        netmask = null;
        address = null;
        addressStart = null;
        addressEnd = null;
        macaddr = null;
        ether = null;
        index = 0;
        try {
            block25: while (true) lbl-1000:
            // 22 sources

            {
                if (done) {
                    return more;
                }
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 3670032: {
                        tmp = tok.getNextQuotedString();
                        ** break;
                    }
                    case 15: 
                    case 17: 
                    case 75: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 190: 
                    case 201: 
                    case 202: 
                    case 203: 
                    case 204: {
                        tmp = tok.getNextQuotedString();
                        if (config == null) continue block25;
                        config.setField(Integer.toString(attribute), tmp);
                        ** break;
                    }
                    case 200: {
                        tmp = tok.getNextQuotedString();
                        value = 0L;
                        try {
                            value = Long.parseLong(tmp);
                        }
                        catch (NumberFormatException e) {
                            LEDebug.getLog().logln(20, e);
                        }
                        value /= 60L;
                        if (config == null) continue block25;
                        config.setField(Integer.toString(attribute), Long.toString(value));
                        ** break;
                    }
                    case 364: {
                        tmp = tok.getNextQuotedString();
                        buf = new StringBuffer();
                        if (config == null) continue block25;
                        config.setField("ippool", buf.toString());
                        ** break;
                    }
                    case 344: {
                        index = Integer.parseInt(tok.getNextQuotedString());
                        ** break;
                    }
                    case 345: {
                        notation = Integer.parseInt(tok.getNextQuotedString());
                        ** break;
                    }
                    case 76: {
                        netmask = tok.getNextQuotedString();
                        ** break;
                    }
                    case 348: {
                        address = tok.getNextQuotedString();
                        ** break;
                    }
                    case 349: {
                        addressStart = tok.getNextQuotedString();
                        ** break;
                    }
                    case 350: {
                        addressEnd = tok.getNextQuotedString();
                        if (index > 0) {
                            buf.append(",");
                        }
                        switch (notation) {
                            case 1: {
                                buf.append(addressStart);
                                buf.append('-');
                                buf.append(addressEnd);
                                break;
                            }
                            case 2: {
                                buf.append(address);
                                buf.append('/');
                                buf.append(netmask);
                                break;
                            }
                            case 3: {
                                buf.append(addressStart);
                                break;
                            }
                        }
                        if (config == null) continue block25;
                        config.setField("ippool", buf.toString());
                        ** break;
                    }
                    case 365: {
                        tmp = tok.getNextQuotedString();
                        bindings = (LEBindings)config.getConfig("bindings");
                        ** break;
                    }
                    case 9: {
                        address = tok.getNextQuotedString();
                        if (bindings == null) continue block25;
                        binding = (LEBinding)bindings.getConfig(address);
                        ** break;
                    }
                    case 195: {
                        tmp = tok.getNextQuotedString();
                        if (binding != null) {
                            binding.setField("195", tmp);
                        }
                        binding = null;
                        ** break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block25;
                        more = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("DHCP", attribute, tok.getNextQuotedString());
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseEthernets(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEEthernets ethers = null;
            if (config instanceof LEEthernets) {
                ethers = (LEEthernets)config;
            }
            LEEthernet ether = null;
            boolean done = false;
            boolean rip_broad = false;
            boolean rip_listen = false;
            boolean rip2_broad = false;
            boolean rip2_multi = false;
            boolean rip2_listen = false;
            block18: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 720896: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0 || ethers == null) continue block18;
                        ether = (LEEthernet)ethers.getConfig(tmp);
                        break;
                    }
                    case 275: {
                        LEBoard board;
                        String tmp = tok.getNextQuotedString();
                        if (!(config instanceof LEBoards) || (board = (LEBoard)config.get(tmp)) == null) continue block18;
                        ethers = (LEEthernets)board.get(LEBoard.ETHERNETS);
                        break;
                    }
                    case 260: {
                        String tmp = tok.getNextQuotedString();
                        if (ethers == null) continue block18;
                        ether = (LEEthernet)ethers.getConfig(tmp);
                        break;
                    }
                    case 190: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        if (ether == null) continue block18;
                        ether.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 9: 
                    case 15: 
                    case 100: 
                    case 186: 
                    case 189: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 198: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 246: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 496: 
                    case 497: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 512: 
                    case 513: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 517: 
                    case 533: 
                    case 534: {
                        String tmp = tok.getNextQuotedString();
                        if (ether == null) continue block18;
                        ether.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 191: 
                    case 192: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("on")) {
                            ether.setField(Integer.toString(attribute), "enable");
                            break;
                        }
                        ether.setField(Integer.toString(attribute), "disable");
                        break;
                    }
                    case 187: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("on")) {
                            rip_broad = true;
                            break;
                        }
                        rip_broad = false;
                        break;
                    }
                    case 188: {
                        String tmp = tok.getNextQuotedString();
                        rip_listen = tmp.equals("on");
                        if (ether == null) continue block18;
                        if (!rip_broad && !rip_listen) {
                            ether.setField("rip", "off");
                            break;
                        }
                        if (rip_broad && rip_listen) {
                            ether.setField("rip", "on");
                            break;
                        }
                        if (rip_broad && !rip_listen) {
                            ether.setField("rip", "broadcast");
                            break;
                        }
                        if (!rip_broad && rip_listen) {
                            ether.setField("rip", "listen");
                            break;
                        }
                        ether.setField("rip", "off");
                        break;
                    }
                    case 535: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("broadcast")) {
                            rip2_broad = true;
                            rip2_multi = false;
                            break;
                        }
                        if (tmp.equals("multicast")) {
                            rip2_broad = false;
                            rip2_multi = true;
                            break;
                        }
                        if (!tmp.equals("off")) continue block18;
                        rip2_broad = false;
                        rip2_multi = false;
                        break;
                    }
                    case 536: {
                        String tmp = tok.getNextQuotedString();
                        rip2_listen = tmp.equals("on");
                        if (ether == null) continue block18;
                        if (rip2_broad || rip2_multi || rip2_listen) {
                            ether.setField("rip", "v2 enabled");
                        }
                        if (rip2_multi && rip2_listen) {
                            ether.setField("rip_v2", "on");
                            break;
                        }
                        if (rip2_multi && !rip2_listen) {
                            ether.setField("rip_v2", "multicast");
                            break;
                        }
                        if (rip2_broad && rip2_listen) {
                            ether.setField("rip_v2", "v1-compatability");
                            break;
                        }
                        if (rip2_broad && !rip2_listen) {
                            ether.setField("rip_v2", "broadcast");
                            break;
                        }
                        if (rip2_listen) {
                            ether.setField("rip_v2", "listen");
                            break;
                        }
                        ether.setField("rip_v2", "on");
                        break;
                    }
                    case 518: 
                    case 519: {
                        String tmp = tok.getNextQuotedString();
                        if (ether == null) continue block18;
                        if (tmp.equals(MCPU_EMPTY)) {
                            tmp = MCPU_PRESENT;
                        }
                        ether.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 520: {
                        String tmp = tok.getNextQuotedString();
                        if (ether == null) continue block18;
                        if (tmp.equals(MCPU_EMPTY)) {
                            tmp = "60";
                        }
                        ether.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 72: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("")) {
                            tmp = "0.0.0.0";
                        }
                        if (ether == null) continue block18;
                        ether.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block18;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Ethernets", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseUsers(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig net_users = config.getConfig("netuser");
            LEConfig db_net_users = config.getConfig("netdialback");
            LEConfig login_users = config.getConfig("user");
            LEConfig db_login_users = config.getConfig("logindialback");
            LEConfig user = null;
            String name = null;
            String service = null;
            boolean rip_broad = false;
            boolean rip_listen = false;
            boolean rip2_broad = false;
            boolean rip2_multi = false;
            boolean rip2_listen = false;
            boolean done = false;
            block19: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x1C0000: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() > 8) {
                            name = tmp.substring(0, 8).trim();
                            break;
                        }
                        name = tmp.trim();
                        break;
                    }
                    case 78: {
                        String tmp = tok.getNextQuotedString();
                        user = null;
                        if (config == null || name == null) continue block19;
                        if (tmp.equals("network")) {
                            user = net_users.getConfig(name);
                            user.setField("password", "");
                            break;
                        }
                        if (tmp.equals("dialback_network")) {
                            user = db_net_users.getConfig(name);
                            user.setField("password", "");
                            break;
                        }
                        if (tmp.equals("login")) {
                            user = login_users.getConfig(name);
                            user.setField("password", "");
                            break;
                        }
                        if (!tmp.equals("dialback_login")) continue block19;
                        user = db_login_users.getConfig(name);
                        break;
                    }
                    case 300: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 173: {
                        String tmp = tok.getNextQuotedString();
                        if (user == null) continue block19;
                        if (tmp.equals("0.0.0.0")) {
                            user.setField("host", "default");
                        } else if (tmp.equals("255.255.255.255")) {
                            user.setField("host", "prompt");
                        } else {
                            user.setField("host", "specified");
                        }
                        user.setField("HostAddress", tmp);
                        break;
                    }
                    case 74: {
                        String tmp = tok.getNextQuotedString();
                        if (user == null) continue block19;
                        if (tmp.equals("255.255.255.255")) {
                            user.setField("destination", "negotiated");
                        } else if (tmp.equals("255.255.255.254")) {
                            user.setField("destination", "assigned");
                        } else {
                            user.setField("destination", "specified");
                        }
                        user.setField("IPAddress", tmp);
                        break;
                    }
                    case 369: {
                        service = tok.getNextQuotedString();
                        break;
                    }
                    case 370: {
                        String tmp = tok.getNextQuotedString();
                        if (user == null || service == null) continue block19;
                        if ((service.equals("netdata") || service.equals("telnet")) && tmp.length() > 0) {
                            service = String.valueOf(service) + "@" + tmp;
                        }
                        user.setField("service", service);
                        service = null;
                        break;
                    }
                    case 15: 
                    case 177: 
                    case 189: 
                    case 193: 
                    case 194: 
                    case 198: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 289: 
                    case 290: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 299: 
                    case 301: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 368: 
                    case 371: 
                    case 496: 
                    case 497: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 533: 
                    case 534: {
                        String tmp = tok.getNextQuotedString();
                        if (user == null) continue block19;
                        user.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 187: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("on")) {
                            rip_broad = true;
                            break;
                        }
                        rip_broad = false;
                        break;
                    }
                    case 188: {
                        String tmp = tok.getNextQuotedString();
                        rip_listen = tmp.equals("on");
                        if (user == null) continue block19;
                        if (!rip_broad && !rip_listen) {
                            user.setField("rip", "off");
                            break;
                        }
                        if (rip_broad && rip_listen) {
                            user.setField("rip", "on");
                            break;
                        }
                        if (rip_broad && !rip_listen) {
                            user.setField("rip", "broadcast");
                            break;
                        }
                        if (!rip_broad && rip_listen) {
                            user.setField("rip", "listen");
                            break;
                        }
                        user.setField("rip", "off");
                        break;
                    }
                    case 535: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("broadcast")) {
                            rip2_broad = true;
                            rip2_multi = false;
                            break;
                        }
                        if (tmp.equals("multicast")) {
                            rip2_broad = false;
                            rip2_multi = true;
                            break;
                        }
                        if (!tmp.equals("off")) continue block19;
                        rip2_broad = false;
                        rip2_multi = false;
                        break;
                    }
                    case 536: {
                        String tmp = tok.getNextQuotedString();
                        rip2_listen = tmp.equals("on");
                        if (user == null) continue block19;
                        if (rip2_broad || rip2_multi || rip2_listen) {
                            user.setField("rip", "v2 enabled");
                        }
                        if (rip2_multi && rip2_listen) {
                            user.setField("rip_v2", "on");
                            break;
                        }
                        if (rip2_multi && !rip2_listen) {
                            user.setField("rip_v2", "multicast");
                            break;
                        }
                        if (rip2_broad && rip2_listen) {
                            user.setField("rip_v2", "v1-compatability");
                            break;
                        }
                        if (rip2_broad && !rip2_listen) {
                            user.setField("rip_v2", "broadcast");
                            break;
                        }
                        if (rip2_listen) {
                            user.setField("rip_v2", "listen");
                            break;
                        }
                        user.setField("rip_v2", "on");
                        break;
                    }
                    case 72: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals("")) {
                            tmp = "0.0.0.0";
                        }
                        if (user == null) continue block19;
                        user.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block19;
                        more = true;
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("User", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseUserPasswords(LEConfig config, LETokenizer tok) {
        if (!(config instanceof LEUsers)) {
            return false;
        }
        LEUsers users = (LEUsers)config;
        boolean more = false;
        try {
            boolean done = false;
            String name = null;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x310000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        String tmp = tok.getNextQuotedString();
                        name = tmp.trim();
                        break;
                    }
                    case 300: {
                        String tmp = tok.getNextQuotedString();
                        if (name != null && tmp.length() > 0) {
                            LEConfig user = (LEConfig)users.getUser(name);
                            if (user instanceof LELoginUser) {
                                ((LELoginUser)user).setPassword(tmp);
                            } else if (user instanceof LENetUser) {
                                ((LENetUser)user).setPassword(tmp);
                            } else if (user instanceof LEDBNetUser) {
                                ((LEDBNetUser)user).setPassword(tmp);
                            }
                        }
                        name = null;
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("User Passwords", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseSecrets(LEConfig config, LETokenizer tok) {
        LERadius radius = (LERadius)config.get("2228224");
        LEChoicenet choicenet = (LEChoicenet)config.get("1507328");
        LEGlobal global = (LEGlobal)config.get("2162688");
        LEL2TP l2tp = (LEL2TP)config.get("3473408");
        boolean more = false;
        try {
            boolean done = false;
            block10: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x320000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 64: {
                        String tmp = tok.getNextQuotedString();
                        if (radius == null) continue block10;
                        radius.setSecret(tmp);
                        break;
                    }
                    case 65: {
                        String tmp = tok.getNextQuotedString();
                        if (choicenet == null) continue block10;
                        choicenet.setSecret(tmp);
                        break;
                    }
                    case 199: {
                        String tmp = tok.getNextQuotedString();
                        if (global == null) continue block10;
                        global.setRIPPassword(tmp);
                        break;
                    }
                    case 134: {
                        String tmp = tok.getNextQuotedString();
                        if (global == null) continue block10;
                        global.setCallCheckPassword(tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block10;
                        more = true;
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Secrets", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseBGP(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 589824: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 9: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: {
                        String tmp = tok.getNextQuotedString();
                        if (config == null) continue block8;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 106: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.equals(MCPU_EMPTY)) {
                            tmp = MCPU_PRESENT;
                        }
                        if (config == null) continue block8;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("BGP", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseBGPPeers(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig peer = null;
            boolean done = false;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x160000: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 9: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0 || config == null) continue block8;
                        peer = (LEBGPPeer)config.getConfig(tmp);
                        break;
                    }
                    case 96: 
                    case 106: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 118: 
                    case 119: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 177: {
                        String tmp = tok.getNextQuotedString();
                        if (peer == null) continue block8;
                        peer.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("BGPPeers", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseATMPVCs(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig pvc = null;
            LEPVCs pvcs = null;
            boolean done = false;
            String vpi = "";
            block10: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x400007: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 275: {
                        LEBoard board;
                        String tmp = tok.getNextQuotedString();
                        if (!(config instanceof LEBoards) || (board = (LEBoard)config.get(tmp)) == null) continue block10;
                        pvcs = (LEPVCs)board.get("4194311");
                        break;
                    }
                    case 562: {
                        vpi = tok.getNextQuotedString();
                        break;
                    }
                    case 563: {
                        String vci = tok.getNextQuotedString();
                        if (vci.length() <= 0 || vpi.length() <= 0 || config == null) continue block10;
                        StringBuffer buf = new StringBuffer();
                        buf.append(vpi);
                        buf.append(".");
                        buf.append(vci);
                        if (pvcs == null) continue block10;
                        pvc = (LEPVC)pvcs.getConfig(buf.toString());
                        break;
                    }
                    case 370: {
                        String tmp = tok.getNextQuotedString();
                        if (pvc == null) continue block10;
                        pvc.setField(Integer.toString(attribute), "S" + tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block10;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("PVCs", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseSAs(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig ipsec_sas = config.getConfig("ipsec");
            LEConfig ipip_sas = config.getConfig("ipip");
            LEConfig proxy_sas = config.getConfig("proxy");
            LEConfig sa = null;
            String name = null;
            boolean done = false;
            block12: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x250000: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        name = tok.getNextQuotedString();
                        break;
                    }
                    case 289: {
                        String tmp = tok.getNextQuotedString();
                        sa = null;
                        if (config == null || name == null) continue block12;
                        if (tmp.equals("IPSEC")) {
                            sa = ipsec_sas.getConfig(name);
                            break;
                        }
                        if (tmp.equals("IPIP")) {
                            sa = ipip_sas.getConfig(name);
                            break;
                        }
                        if (!tmp.equals("PROXY")) continue block12;
                        sa = proxy_sas.getConfig(name);
                        sa.setField("secret", "");
                        break;
                    }
                    case 74: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 238: 
                    case 239: {
                        String tmp = tok.getNextQuotedString();
                        if (sa == null) continue block12;
                        sa.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 226: 
                    case 227: {
                        String tmp = tok.getNextQuotedString();
                        if (sa == null) continue block12;
                        sa.setField(Integer.toString(attribute), tmp.toLowerCase());
                        break;
                    }
                    case 228: 
                    case 229: 
                    case 230: 
                    case 231: {
                        String tmp = tok.getNextQuotedString();
                        if (sa == null) continue block12;
                        if (tmp.equals(MCPU_EMPTY)) {
                            tmp = "";
                        }
                        sa.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 240: {
                        String tmp = tok.getNextQuotedString();
                        if (sa == null) continue block12;
                        sa.setField("secret", tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block12;
                        more = true;
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("SA", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseIPSecProfiles(LEConfig config, LETokenizer tok) {
        boolean more = false;
        boolean done = false;
        try {
            LEIPSecProfiles profs = (LEIPSecProfiles)config;
            LEIPSecProfile prof = null;
            LEIPSecProfileRule rule = null;
            block10: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x390000: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block10;
                        prof = (LEIPSecProfile)profs.getConfig(tmp);
                        break;
                    }
                    case 237: {
                        String tmp = tok.getNextQuotedString();
                        prof = (LEIPSecProfile)profs.getConfig(tmp);
                        break;
                    }
                    case 12: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 504: {
                        String tmp = tok.getNextQuotedString();
                        if (prof != null) {
                            rule = (LEIPSecProfileRule)prof.getConfig(tmp);
                            break;
                        }
                        rule = null;
                        break;
                    }
                    case 505: 
                    case 506: {
                        String tmp = tok.getNextQuotedString();
                        if (rule == null) continue block10;
                        rule.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block10;
                        more = true;
                        break;
                    }
                    default: {
                        String tmp = tok.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("IPSecProfiles", attribute, tmp);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseBGPPolicies(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LETable policy = null;
            LEConfig rule = null;
            boolean done = false;
            block9: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x300000: {
                        String tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0 || config == null) continue block9;
                        policy = (LEBGPPolicy)config.getConfig(tmp);
                        break;
                    }
                    case 416: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0 || policy == null) continue block9;
                        rule = (LEBGPPolicyRule)policy.getConfig(tmp);
                        break;
                    }
                    case 417: 
                    case 418: 
                    case 419: 
                    case 420: 
                    case 421: 
                    case 422: 
                    case 423: 
                    case 424: 
                    case 425: 
                    case 426: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 431: {
                        String tmp = tok.getNextQuotedString();
                        if (rule == null) continue block9;
                        rule.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block9;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("BGPPolicies", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseIMT(LEConfig config, LETokenizer tok) {
        more = false;
        done = false;
        imt = null;
        try {
            block8: while (true) lbl-1000:
            // 9 sources

            {
                if (done) {
                    return more;
                }
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 3670022: {
                        tmp = tok.getNextQuotedString();
                        ** break;
                    }
                    case 75: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 370: 
                    case 523: 
                    case 526: {
                        tmp = tok.getNextQuotedString();
                        config.setField(Integer.toString(attribute), tmp);
                        ** break;
                    }
                    case 275: {
                        tmp = tok.getNextQuotedString();
                        if (!(config instanceof LEBoards)) continue block8;
                        board = (LEBoard)config.get(tmp);
                        if (board != null) {
                            imt = (LEIMT)board.get("3670022");
                        }
                        if (imt == null) continue block8;
                        config = imt;
                        ** break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("IMT", attribute, tok.getNextQuotedString());
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseLocalIPAddresses(LEConfig config, LETokenizer tok) {
        more = false;
        done = false;
        local_ip = null;
        try {
            block8: while (true) lbl-1000:
            // 8 sources

            {
                if (done) {
                    return more;
                }
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 3670023: {
                        tmp = tok.getNextQuotedString();
                        ** break;
                    }
                    case 416: {
                        num = tok.getNextQuotedString();
                        local_ip = (LELocalIPAddress)config.getConfig(num);
                        ** break;
                    }
                    case 9: {
                        tmp = tok.getNextQuotedString();
                        if (local_ip == null) continue block8;
                        local_ip.setField("9", tmp);
                        ** break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("Local IP Addresses", attribute, tok.getNextQuotedString());
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseL2TP(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            LEL2TP l2tp = null;
            if (config instanceof LEL2TP) {
                l2tp = (LEL2TP)config;
            }
            block9: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 275: {
                        LEBoard board;
                        String tmp = tok.getNextQuotedString();
                        if (!(config instanceof LEBoards) || (board = (LEBoard)config.get(tmp)) == null || l2tp == null) continue block9;
                        l2tp = (LEL2TP)board.get(LEBoard.L2TP);
                        break;
                    }
                    case 0x350000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 479: 
                    case 495: 
                    case 507: 
                    case 508: {
                        String tmp = tok.getNextQuotedString();
                        if (l2tp == null) continue block9;
                        l2tp.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 480: {
                        String tmp = tok.getNextQuotedString();
                        if (l2tp == null) continue block9;
                        l2tp.setField("l2tp-secret", tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block9;
                        more = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("L2TP", attribute, tok.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    static void LogBadAttribute(String section, int attr, String value) {
        LEDebug.getLog().log(30, "Bad ");
        LEDebug.getLog().log(30, section);
        LEDebug.getLog().log(30, " Attribute: ", attr);
        LEDebug.getLog().log(30, ", ");
        LEDebug.getLog().logln(30, value);
    }
}

