/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEDSS;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEAsyncPort;
import com.lucent.ra.nms.model.LEBGP;
import com.lucent.ra.nms.model.LEBGPPeers;
import com.lucent.ra.nms.model.LEBGPPolicies;
import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEBoards;
import com.lucent.ra.nms.model.LEChoicenet;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDHCP;
import com.lucent.ra.nms.model.LEDataSpecFactory;
import com.lucent.ra.nms.model.LEEthernets;
import com.lucent.ra.nms.model.LEFilters;
import com.lucent.ra.nms.model.LEGateway;
import com.lucent.ra.nms.model.LEGlobal;
import com.lucent.ra.nms.model.LEHosts;
import com.lucent.ra.nms.model.LEIMT;
import com.lucent.ra.nms.model.LEIPPools;
import com.lucent.ra.nms.model.LEIPSecProfiles;
import com.lucent.ra.nms.model.LEISDNPort;
import com.lucent.ra.nms.model.LEISDNSwitch;
import com.lucent.ra.nms.model.LEL2TP;
import com.lucent.ra.nms.model.LELines;
import com.lucent.ra.nms.model.LELocalIPAddresses;
import com.lucent.ra.nms.model.LELocations;
import com.lucent.ra.nms.model.LEModemTable;
import com.lucent.ra.nms.model.LEModems;
import com.lucent.ra.nms.model.LENATMaps;
import com.lucent.ra.nms.model.LENumberingPlan;
import com.lucent.ra.nms.model.LEOSPF;
import com.lucent.ra.nms.model.LEOSPFAreas;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPMFactory;
import com.lucent.ra.nms.model.LEPort;
import com.lucent.ra.nms.model.LEPorts;
import com.lucent.ra.nms.model.LERadius;
import com.lucent.ra.nms.model.LERoutes;
import com.lucent.ra.nms.model.LESAs;
import com.lucent.ra.nms.model.LESNMP;
import com.lucent.ra.nms.model.LESubInterfaces;
import com.lucent.ra.nms.model.LESyncPort;
import com.lucent.ra.nms.model.LESyslog;
import com.lucent.ra.nms.model.LEUsers;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEStatusManager;
import com.lucent.ra.nms.util.LEThreadStatus;
import com.lucent.ra.nms.util.LEUpTimeCompare;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.util.LEVersionCompare;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class LEPortMaster
extends LEConfig {
    public static final String BGP = "589824";
    public static final String BGP_PEERS = "1441792";
    public static final String BGP_POLICIES = "3145728";
    public static final String BOARDS = "2555904";
    public static final String CHOICENET = "1507328";
    public static final String DHCP = "3670032";
    public static final String ETHERNETS = "720896";
    public static final String FILTERS = "filter";
    public static final String GLOBAL = "2162688";
    public static final String HOSTS = "1245184";
    public static final String IMT = "3670022";
    public static final String IP_POOLS = "3670021";
    public static final String LINES = "131072";
    public static final String LOCAL_IP_ADDRS = "3670023";
    public static final String LOCATIONS = "1703936";
    public static final String MODEMS = "196608";
    public static final String MODEM_TABLE = "5242880";
    public static final String NAT_MAPS = "2686976";
    public static final String OSPF = "1048576";
    public static final String OSPF_AREAS = "524288";
    public static final String PORTS = "262144";
    public static final String RADIUS = "2228224";
    public static final String ROUTES = "1310720";
    public static final String SEC_ASSNS = "2424832";
    public static final String SNMP = "1376256";
    public static final String SUB_IS = "2490368";
    public static final String SYSLOG = "327680";
    public static final String USERS = "1835008";
    public static final String IPSEC_PROFILES = "3735552";
    public static final String L2TP = "3473408";
    public static final String NUMPLAN = "1048577";
    public static final String GATEWAY = "1048578";
    public static final String DOM_CUST_PLANS = "1048580";
    public static final String INTL_CUST_PLANS = "1048581";
    public static final String PRIVATE_CUST_PLANS = "1048582";
    public static final int KEY_COUNT = 34;
    public static final String DEFAULT_USER = "!root";
    public static final String MOD_IRX_111 = "IRX-111";
    public static final String MOD_IRX_112 = "IRX-112";
    public static final String MOD_IRX_114 = "IRX-114";
    public static final String MOD_IRX_211 = "IRX-211";
    public static final String MOD_LEGEND = "INA";
    public static final String MOD_MSM_RAC = "MSM-RAC";
    public static final String MOD_OR = "OR";
    public static final String MOD_OR_AP = "OR-AP";
    public static final String MOD_OR_HS = "OR-HS";
    public static final String MOD_OR_LS = "OR-LS";
    public static final String MOD_OR_M = "OR-M";
    public static final String MOD_OR_ST = "OR-ST";
    public static final String MOD_OR_U = "OR-U";
    public static final String MOD_PM2 = "PM-2";
    public static final String MOD_PM25 = "PM-25";
    public static final String MOD_PM2E = "PM-2e";
    public static final String MOD_PM2EI = "PM-2ei";
    public static final String MOD_PM2ER = "PM-2er";
    public static final String MOD_PM2I = "PM-2i";
    public static final String MOD_PM2R = "PM-2r";
    public static final String MOD_PM3 = "PM-3";
    public static final String MOD_PM3VT = "PM-3VT";
    public static final String MOD_PM4 = "PM-4";
    public static final String MOD_GW1000 = "1000";
    public static final String MOD_SIM = "Simulator";
    public static final String MOD_UNKNOWN = "";
    static final String SET_PASSWORD = "set pas";
    static final String PM4 = "7.";
    static final String PM3 = "6.";
    static final String IRX = "4.";
    static final String OR = "5.";
    static final String PM25 = "2.5";
    static final String PM2 = "2.2";
    static final String MSM_RAC = "msm-rac";
    static final String LEGEND = "legend";
    static final String PM3VT = "pm3vt";
    static final String GW1000_NAME = "PacketStar IP Gateway 1000";
    static final String ROUTES_VER = "4.2b1";
    public static final String PORTMASTER = "PortMaster";
    public static final String ITS = "Gateway";
    public static final String RTX = "Legend";
    public static final String PORTMASTER_KEY = "pm";
    public static final String ITS_KEY = "its";
    public static final String RTX_KEY = "rtx";
    static String[] s_keys = null;
    Vector m_retrieved = new Vector();
    LEVector m_toc;
    LEPMConnectionFacade m_smm;
    String m_primary;
    String m_secondary;
    String m_software = "";
    String m_hardware;
    String m_uptime = "";
    String m_hardwareName = "";
    String m_platform = "PortMaster";

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[33];
            int i = 0;
            LEPortMaster.s_keys[i++] = BGP;
            LEPortMaster.s_keys[i++] = BGP_PEERS;
            LEPortMaster.s_keys[i++] = BGP_POLICIES;
            LEPortMaster.s_keys[i++] = BOARDS;
            LEPortMaster.s_keys[i++] = CHOICENET;
            LEPortMaster.s_keys[i++] = DHCP;
            LEPortMaster.s_keys[i++] = ETHERNETS;
            LEPortMaster.s_keys[i++] = FILTERS;
            LEPortMaster.s_keys[i++] = GLOBAL;
            LEPortMaster.s_keys[i++] = HOSTS;
            LEPortMaster.s_keys[i++] = IMT;
            LEPortMaster.s_keys[i++] = IP_POOLS;
            LEPortMaster.s_keys[i++] = LINES;
            LEPortMaster.s_keys[i++] = LOCAL_IP_ADDRS;
            LEPortMaster.s_keys[i++] = LOCATIONS;
            LEPortMaster.s_keys[i++] = MODEMS;
            LEPortMaster.s_keys[i++] = NAT_MAPS;
            LEPortMaster.s_keys[i++] = OSPF;
            LEPortMaster.s_keys[i++] = OSPF_AREAS;
            LEPortMaster.s_keys[i++] = PORTS;
            LEPortMaster.s_keys[i++] = RADIUS;
            LEPortMaster.s_keys[i++] = SEC_ASSNS;
            LEPortMaster.s_keys[i++] = SNMP;
            LEPortMaster.s_keys[i++] = SUB_IS;
            LEPortMaster.s_keys[i++] = SYSLOG;
            LEPortMaster.s_keys[i++] = USERS;
            LEPortMaster.s_keys[i++] = IPSEC_PROFILES;
            LEPortMaster.s_keys[i++] = L2TP;
            LEPortMaster.s_keys[i++] = NUMPLAN;
            LEPortMaster.s_keys[i++] = GATEWAY;
            LEPortMaster.s_keys[i++] = DOM_CUST_PLANS;
            LEPortMaster.s_keys[i++] = INTL_CUST_PLANS;
            LEPortMaster.s_keys[i++] = PRIVATE_CUST_PLANS;
        }
        return s_keys;
    }

    public LEPortMaster() {
        super(null);
    }

    public void setConnectionFacade(LEConnectionFacade facade) {
        this.m_facade = facade;
        this.ping();
        try {
            this.setSpec(LEDataSpecFactory.GetSpec(this.getPlatformKey()));
        }
        catch (IOException e) {
            LEDebug.getLog().logln(20, e);
        }
        this.checkSMM();
    }

    public boolean isConnected() {
        return this.m_facade.isConnected();
    }

    public void disconnect() {
        this.m_facade.disconnect();
        if (this.m_smm != null) {
            this.m_smm.disconnect();
            this.m_smm = null;
        }
    }

    public boolean reconnect() {
        boolean success = this.m_facade.reconnect();
        if (success) {
            this.checkSMM();
        }
        return success;
    }

    public void reboot() {
        this.m_facade.execute("reboot");
    }

    public String getResourceID() {
        return this.m_facade.getResourceID();
    }

    public String getDescription() {
        return this.m_facade.getDescription();
    }

    public String getUpTime() {
        return this.m_uptime;
    }

    public String getSoftwareVersion() {
        return this.m_software;
    }

    public String getHardwareType() {
        return this.m_hardware;
    }

    public String getHardwareName() {
        return this.m_hardwareName;
    }

    public String getPlatformKey() {
        if (this.m_platform.equals(PORTMASTER)) {
            return PORTMASTER_KEY;
        }
        if (this.m_platform.equals(ITS)) {
            return ITS_KEY;
        }
        if (this.m_platform.equals(RTX)) {
            return RTX_KEY;
        }
        return null;
    }

    public LEConnectionFacade getFacade() {
        return this.m_facade;
    }

    public LEDSS getDSS() {
        return this.m_facade.getDSS();
    }

    public LEDSS getSecondaryDSS() {
        if (this.m_smm == null) {
            return null;
        }
        return this.m_smm.getDSS();
    }

    public boolean supportsSMM() {
        if (this.m_facade instanceof LEPMConnectionFacade) {
            return ((LEPMConnectionFacade)this.m_facade).supportsSMM();
        }
        return false;
    }

    public boolean hasSMM() {
        return this.m_smm != null;
    }

    public String getPrimary() {
        return this.m_primary;
    }

    public String getSecondary() {
        return this.m_secondary;
    }

    public boolean getUserPasswords() {
        boolean success = false;
        if (this.m_facade instanceof LEPMConnectionFacade) {
            LEPMConnectionFacade facade = (LEPMConnectionFacade)this.m_facade;
            success = facade.getUserPasswords();
        }
        return success;
    }

    public boolean getSecrets() {
        boolean success = false;
        if (this.m_facade instanceof LEPMConnectionFacade) {
            LEPMConnectionFacade facade = (LEPMConnectionFacade)this.m_facade;
            success = facade.getSecrets();
        }
        return success;
    }

    public Object get(String key) {
        LEVersionCompare cmp;
        if (key.equals(ROUTES) && (cmp = new LEVersionCompare()).compareStr(this.m_software, ROUTES_VER) == -1) {
            System.out.println("Routes not available for: " + this.m_software);
            return null;
        }
        Object field = this.m_fields.get(key);
        if (field == null && !this.m_retrieved.contains(key) && this.load(key)) {
            this.m_retrieved.addElement(key);
            field = this.m_fields.get(key);
        }
        return field;
    }

    public Object fetch(String key) {
        if (this.m_fields.containsKey(key)) {
            this.load(key);
        }
        return this.get(key);
    }

    public LEPMCommand execute(String command) {
        LEPMCommand ret = this.m_facade.execute(command);
        LEStatusManager.SetStatus(LEThreadStatus.NO_MESSAGE);
        return ret;
    }

    public LEPMCommand executeSMM(String command) {
        LEPMCommand ret = this.m_smm.execute(command);
        LEStatusManager.SetStatus(LEThreadStatus.NO_MESSAGE);
        return ret;
    }

    public boolean ping() {
        boolean ping = false;
        if (this.m_facade.supportsEntities()) {
            LEPMCommand cmd = this.execute("version");
            if (cmd.getStatus()) {
                ping = true;
                this.parseVersion(cmd.getResult());
            }
        } else if (this.load(GLOBAL)) {
            ping = true;
        }
        return ping;
    }

    public void purgeCache() {
        this.m_toc = null;
        this.m_retrieved.removeAllElements();
        this.fetch(GLOBAL);
    }

    public boolean getCommands(LEVector cmds) {
        String[] keys = LEPortMaster.GetAllPossibleKeys();
        int i = 0;
        while (i < keys.length) {
            this.get(keys[i]);
            ++i;
        }
        return super.getCommands(cmds);
    }

    boolean isPM4Chassis() {
        return this.m_hardware != null && (this.m_hardware.equals(MOD_PM4) || this.m_hardware.equals(MOD_GW1000) || this.m_hardware.equals(MOD_MSM_RAC));
    }

    void rebooted(LEPMConnectionFacade facade) {
        if (facade == this.m_facade) {
            this.checkSMM();
        }
    }

    void checkSMM() {
        if (!this.isPM4Chassis()) {
            return;
        }
        LEPMConnectionFacade pri_facade = (LEPMConnectionFacade)this.m_facade;
        this.purgeCache();
        boolean smm_sup = pri_facade.supportsSMM();
        this.setSMMSupport(smm_sup);
        this.m_smm = null;
        this.m_primary = null;
        this.m_secondary = null;
        LEGlobal global = (LEGlobal)this.get(GLOBAL);
        String type = (String)global.get("530");
        String id = (String)global.get("275");
        if (type == null || id == null) {
            if (type == null) {
                LEDebug.getLog().logln(40, "No manager type specified");
            }
            if (id == null) {
                LEDebug.getLog().logln(40, "No manager id specified");
            }
            ((LEPMConnectionFacade)this.m_facade).checkForBoards();
            return;
        }
        if (type.equals("Primary")) {
            this.m_primary = id;
            this.m_secondary = this.m_primary.equals("4") ? "5" : "4";
        } else {
            this.m_secondary = id;
            this.m_primary = this.m_secondary.equals("4") ? "5" : "4";
        }
        String ip = (String)global.get("529");
        if (ip == null) {
            LEDebug.getLog().logln(40, "No manager peer address specified");
            ((LEPMConnectionFacade)this.m_facade).checkForBoards();
            return;
        }
        boolean boardsChecked = false;
        LEPMConnectionFacade sec_facade = null;
        try {
            String user = pri_facade.getUsername();
            String pass = pri_facade.getPassword();
            LEStatusManager.SetStatus("Connecting to " + ip);
            sec_facade = LEPMFactory.GetFromPM(pri_facade.getConnectionManager(), this, ip, user, pass);
            if (type.equals("Primary")) {
                this.m_smm = sec_facade;
            } else {
                super.setConnectionFacade(sec_facade);
                this.m_smm = pri_facade;
            }
            this.purgeCache();
            ((LEPMConnectionFacade)this.m_facade).checkForBoards();
            boardsChecked = true;
            LEBoards boards = (LEBoards)this.get(BOARDS);
            LEBoard board = (LEBoard)boards.get(this.m_secondary);
            board.setConnectionFacade(this.m_smm);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(10, e);
        }
        if (!boardsChecked) {
            ((LEPMConnectionFacade)this.m_facade).checkForBoards();
        }
    }

    void refresh(LEConfig config) {
        String refreshKey = this.getKeyFor(config);
        if (refreshKey != null) {
            this.fetch(refreshKey);
        }
    }

    void parseVersion(String result) {
        if (result == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(result);
        boolean foundUptime = false;
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (foundUptime) {
                buf.append(' ');
                buf.append(token);
                continue;
            }
            if (token.equals("is")) {
                foundUptime = true;
                buf.append(tokenizer.nextToken());
                continue;
            }
            if (token.equals(PORTMASTER)) {
                this.m_platform = PORTMASTER;
                token = tokenizer.nextToken();
                if (this.m_hardware == null) {
                    this.m_hardware = token.equals(MOD_SIM) || token.equals(MOD_PM25) ? token : this.determineModel();
                }
                if (!this.m_hardware.equals(MOD_LEGEND)) continue;
                this.m_platform = RTX;
                continue;
            }
            if (token.equals(ITS)) {
                this.m_platform = ITS;
                token = tokenizer.nextToken();
                if (this.m_hardware != null || !token.equals(MOD_GW1000) && !token.equals("1000,")) continue;
                this.m_hardwareName = GW1000_NAME;
                this.m_hardware = MOD_GW1000;
                continue;
            }
            if (token.equals("Release")) {
                this.m_software = tokenizer.nextToken();
                continue;
            }
            if (!token.equals("ComOS")) continue;
            this.m_software = tokenizer.nextToken();
        }
        this.m_uptime = new String(buf);
        int len = this.m_uptime.length();
        if (len > 0) {
            this.m_uptime = this.m_uptime.substring(0, len - 1);
        }
    }

    boolean load(String key) {
        LEStatusManager.SetStatus("Getting " + this.getDescriptionFor(key) + " from " + this.getDescription());
        boolean success = this.m_facade.getConfig(key);
        if (success && key.equals(GLOBAL)) {
            LEGlobal global = (LEGlobal)this.get(GLOBAL);
            String tmp = (String)global.get("145");
            if (tmp != null && tmp.length() > 0) {
                this.m_software = tmp;
            }
            if (this.m_hardware == null) {
                this.m_hardware = this.determineModel();
            }
            tmp = (String)global.get("36");
            try {
                int time = Integer.parseInt(tmp);
                this.m_uptime = LEUpTimeCompare.FormatTime(time);
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
        }
        LEStatusManager.StatusComplete();
        return success;
    }

    String determineModel() {
        LEGlobal global = (LEGlobal)this.get(GLOBAL);
        if (global == null) {
            return MOD_UNKNOWN;
        }
        String hardware = (String)global.get("146");
        if (hardware == null || hardware.length() == 0) {
            return MOD_UNKNOWN;
        }
        if (hardware.startsWith(PM3)) {
            String chassis = (String)global.get("280");
            if (chassis != null && chassis.equals(LEGEND)) {
                return MOD_LEGEND;
            }
            if (chassis != null && chassis.equals(PM3VT)) {
                return MOD_PM3VT;
            }
            return MOD_PM3;
        }
        if (hardware.startsWith(PM4)) {
            String chassis = (String)global.get("280");
            if (chassis != null && chassis.equals(MSM_RAC)) {
                return MOD_MSM_RAC;
            }
            return MOD_PM4;
        }
        if (hardware.startsWith(PM25)) {
            return MOD_PM25;
        }
        LEPorts ports = (LEPorts)this.get(PORTS);
        if (ports == null) {
            return MOD_UNKNOWN;
        }
        if (hardware.startsWith(IRX)) {
            LEPort port = ports.getPort("S4");
            if (port != null) {
                return MOD_IRX_114;
            }
            port = ports.getPort("S2");
            if (port != null) {
                return MOD_IRX_112;
            }
            LEEthernets ethers = (LEEthernets)this.get(ETHERNETS);
            if (ethers != null && ethers.get("ether1") != null) {
                return MOD_IRX_211;
            }
            return MOD_IRX_111;
        }
        if (hardware.startsWith(OR)) {
            LEPort port = ports.getPort("S1");
            if (port != null) {
                if (port instanceof LEAsyncPort) {
                    return MOD_OR_M;
                }
                if (port instanceof LEISDNPort) {
                    String comver = (String)global.get("145");
                    if (comver.indexOf("AP") != -1) {
                        return MOD_OR_AP;
                    }
                    String switchtype = (String)global.get("144");
                    if (switchtype == null) {
                        return MOD_OR_U;
                    }
                    if (LEISDNSwitch.IsUSSwitch(switchtype)) {
                        return MOD_OR_U;
                    }
                    return MOD_OR_ST;
                }
            }
            if ((port = ports.getPort("W1")) instanceof LESyncPort) {
                return MOD_OR_HS;
            }
            return MOD_OR;
        }
        if (hardware.startsWith(PM2)) {
            boolean isE = false;
            LEPort port = ports.getPort("S10");
            if (port != null) {
                isE = true;
            } else {
                port = ports.getPort("S20");
                if (port != null) {
                    isE = true;
                }
            }
            port = ports.getPort("P0");
            if (port != null) {
                if (isE) {
                    return MOD_PM2E;
                }
                return MOD_PM2;
            }
            port = ports.getPort("W1");
            if (port != null) {
                if (isE) {
                    return MOD_PM2ER;
                }
                return MOD_PM2R;
            }
            port = ports.getPort("C0");
            if (port != null) {
                if (isE) {
                    return MOD_PM2EI;
                }
                return MOD_PM2I;
            }
            return MOD_PM2;
        }
        return MOD_UNKNOWN;
    }

    LEConfig createConfig(String key) {
        LEConfig config = key.equals(BGP) ? new LEBGP(this.m_facade) : (key.equals(BGP_PEERS) ? new LEBGPPeers(this.m_facade) : (key.equals(BGP_POLICIES) ? new LEBGPPolicies(this.m_facade) : (key.equals(GLOBAL) ? new LEGlobal(this.m_facade) : (key.equals(RADIUS) ? new LERadius(this.m_facade) : (key.equals(CHOICENET) ? new LEChoicenet(this.m_facade) : (key.equals(DHCP) ? new LEDHCP(this.m_facade) : (key.equals(FILTERS) ? new LEFilters(this.m_facade) : (key.equals(PORTS) ? new LEPorts(this.m_facade) : (key.equals(USERS) ? new LEUsers(this.m_facade) : (key.equals(LOCATIONS) ? new LELocations(this.m_facade) : (key.equals(ETHERNETS) ? new LEEthernets(this.m_facade) : (key.equals(SYSLOG) ? new LESyslog(this.m_facade) : (key.equals(SNMP) ? new LESNMP(this.m_facade) : (key.equals(OSPF) ? new LEOSPF(this.m_facade) : (key.equals(OSPF_AREAS) ? new LEOSPFAreas(this.m_facade) : (key.equals(ROUTES) ? new LERoutes(this.m_facade) : (key.equals(HOSTS) ? new LEHosts(this.m_facade) : (key.equals(MODEMS) ? new LEModems(this.m_facade) : (key.equals(LINES) ? new LELines(this.m_facade) : (key.equals(SUB_IS) ? new LESubInterfaces(this.m_facade) : (key.equals(BOARDS) ? new LEBoards(this.m_facade) : (key.equals(NAT_MAPS) ? new LENATMaps(this.m_facade) : (key.equals(SEC_ASSNS) ? new LESAs(this.m_facade) : (key.equals(IPSEC_PROFILES) ? new LEIPSecProfiles(this.m_facade) : (key.equals(IP_POOLS) ? new LEIPPools(this.m_facade) : (key.equals(IMT) ? new LEIMT(this.m_facade) : (key.equals(LOCAL_IP_ADDRS) ? new LELocalIPAddresses(this.m_facade) : (key.equals(L2TP) ? new LEL2TP(this.m_facade) : (key.equals(NUMPLAN) ? new LENumberingPlan(this.m_facade) : (key.equals(GATEWAY) ? new LEGateway(this.m_facade) : (key.equals(MODEM_TABLE) ? new LEModemTable(this.m_facade) : new LEConfig(this.m_facade))))))))))))))))))))))))))))))));
        return config;
    }
}

