/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LERoute;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LERoutes
extends LETable {
    public LERoutes(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LERoutes config = new LERoutes(this.m_facade);
        config.copy(this);
        return config;
    }

    public LEVector add(String dest, String gateway, String metric) {
        LEVector errors = null;
        StringBuffer buf = new StringBuffer("add ");
        buf.append("route ");
        buf.append(dest);
        buf.append(" ");
        buf.append(gateway);
        buf.append(" ");
        buf.append(metric);
        LEPMCommand ret = this.m_facade.execute(new String(buf));
        if (ret.getStatus()) {
            ret = this.m_facade.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String dest) {
        LERoute route = (LERoute)this.get(dest);
        if (route == null) {
            return null;
        }
        String gateway = (String)route.get(LERoute.GATEWAY);
        if (gateway == null) {
            return null;
        }
        LEVector errors = null;
        StringBuffer buf = new StringBuffer("delete ");
        buf.append("route ");
        buf.append(dest);
        buf.append(" ");
        buf.append(gateway);
        LEPMCommand ret = this.m_facade.execute(new String(buf));
        if (ret.getStatus()) {
            this.m_fields.remove(dest);
            ret = this.m_facade.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LERoute(this.m_facade, key);
    }
}

