/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.backend;

import COM.livingston.amf.LEAMManager;
import COM.livingston.backend.LEAlarmFactory;
import COM.livingston.backend.LECmdFailedFactory;
import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPMAuthFailureException;
import COM.livingston.backend.LEDSSPMOpFailureException;
import COM.livingston.backend.LEDebugFactory;
import COM.livingston.backend.LEDeltaFactory;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.backend.LEPMListen;
import COM.livingston.backend.LEPortIOFactory;
import COM.livingston.backend.LESendBuf;
import COM.livingston.backend.LESendResponse;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEFifo;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEObserver;
import COM.livingston.util.LETokenizer;
import COM.livingston.util.LEVector;
import COM.livingston.util.MD5;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;

public class LEDSSPortMaster
extends LEObservable
implements LEObserver {
    public static final byte NC_INIT = 2;
    public static final byte NC_DISC = 3;
    public static final byte NC_COMMAND = 4;
    public static final byte NC_DOWNLOAD = 5;
    public static final byte NC_DOWNDATA = 6;
    public static final byte NC_RENAME = 7;
    public static final byte NC_STATUS = 8;
    public static final byte NC_REPLY = 9;
    public static final byte NC_RAW_WRITE = 10;
    public static final byte NC_IOSTAT = 11;
    public static final byte NC_UPLOAD = 12;
    public static final byte NC_UPDATA = 13;
    public static final byte NC_CDATA = 14;
    public static final byte NC_RESET = 15;
    public static final byte NC_NETSTATUS = 16;
    public static final byte NC_TABLE = 17;
    public static final byte NC_CHALLENGE = 18;
    public static final byte NC_MD5_PASS = 19;
    public static final byte NC_USER_PASS = 20;
    public static final byte NC_BK = 21;
    public static final byte NC_TOC = 22;
    public static final byte NC_MONITOR = 23;
    public static final byte NC_DEBUG = 24;
    public static final byte NC_DELTA = 25;
    public static final byte NC_MONMESSAGE = 26;
    public static final byte NC_DBGMESSAGE = 27;
    public static final byte NC_DELTAMSG = 28;
    public static final byte NC_ALARMS = 29;
    public static final byte NC_ALARMMSG = 30;
    public static final byte NC_ENTITY = 31;
    public static final byte NC_ENTITYMSG = 32;
    public static final byte NC_NEWCOMMAND = 33;
    public static final byte NC_NEWCMDMSG = 34;
    public static final byte NC_SUCCESS = 115;
    public static final byte NC_FAIL = 102;
    public static final byte NC_ID = 101;
    public static final int CONTROL_PORT = 1643;
    public static final String REQ_TIMEOUT = "Request timedout";
    public static final String UNEXPLAINED = "Unexplained error";
    protected static final String TEST_COMMAND = "version";
    protected static final String NC_MORE = "-- Press Return for More -- ";
    protected static FileWriter s_dbgFile;
    protected static PrintWriter s_pw;
    protected static int s_sleepTime;
    protected static int s_timeoutCount;
    protected static int TIMEOUT_MILLIS;
    protected String m_hostname;
    protected String m_username;
    protected String m_password;
    protected boolean m_oneTimePass;
    protected Socket m_pmfd;
    protected LEPMListen m_listener;
    protected OutputStream m_outStream;
    protected LESendBuf m_sbOut;
    protected boolean m_newCommand = false;
    protected LEVector m_threads = new LEVector();
    protected LEFifo m_sbInQ;

    public LEDSSPortMaster(String hostname, String username, String password) throws IOException, LEDSSException {
        this.initialize(hostname, username, password);
        this.connectUser();
    }

    public LEDSSPortMaster(String hostname, String password, boolean oneTimePass) throws IOException, LEDSSException {
        this.initialize(hostname, null, password);
        this.m_oneTimePass = oneTimePass;
        if (this.m_oneTimePass) {
            this.connectOTP();
        } else {
            this.connect();
        }
    }

    public LEDSSPortMaster(String hostname, String password) throws IOException, LEDSSException {
        this.initialize(hostname, null, password);
        this.connect();
    }

    public LEDSSPortMaster() {
        this.initialize();
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public boolean isConnected() {
        return this.m_pmfd != null;
    }

    public LEPMCommand execute(String command) {
        return this.execute(command, TIMEOUT_MILLIS);
    }

    public LEPMCommand execute(String command, int timeout) {
        LEPMCommand cmd = new LEPMCommand(command);
        int len = 0;
        if (command != null) {
            len = command.length();
        }
        if (len == 0) {
            cmd.setStatus(false);
            return cmd;
        }
        LEDebug.getLog().logln(40, "Executing: " + command);
        if (LEPMCommand.IsReboot(command)) {
            return this.reboot(cmd);
        }
        return this.execute(cmd, timeout);
    }

    public long debug(int entity, int context) throws LEDSSException {
        StringBuffer buf = new StringBuffer();
        buf.append(entity);
        buf.append(' ');
        buf.append(context);
        buf.append(" 1");
        String command = new String(buf);
        LESendResponse resp = this.send((byte)24, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
        try {
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public void killDebug(long req) throws LEDSSException {
        String command = new String(String.valueOf(Long.toString(req)) + " 0");
        LESendResponse resp = this.send((byte)24, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
    }

    public long delta(int entity, int interval) throws LEDSSException {
        StringBuffer buf = new StringBuffer();
        buf.append(entity);
        buf.append(' ');
        buf.append(interval);
        String command = new String(buf);
        try {
            LESendResponse resp = this.send((byte)25, (short)command.length(), command, false);
            if (!resp.successful()) {
                throw this.getLEDSSException(resp);
            }
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public void killDelta(long req) throws LEDSSException {
        String command = new String(String.valueOf(Long.toString(req)) + " 0");
        LESendResponse resp = this.send((byte)25, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
    }

    public long alarm(int entity) throws LEDSSException {
        StringBuffer buf = new StringBuffer();
        buf.append(entity);
        buf.append(" 1");
        String command = new String(buf);
        LESendResponse resp = this.send((byte)29, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
        try {
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public void clearAlarm(long req) throws LEDSSException {
        String command = new String(String.valueOf(Long.toString(req)) + " 2");
        LESendResponse resp = this.send((byte)29, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
    }

    public void killAlarm(long req) throws LEDSSException {
        String command = new String(String.valueOf(Long.toString(req)) + " 0");
        LESendResponse resp = this.send((byte)29, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
    }

    public long monitor(int entity, int interval) throws LEDSSException {
        StringBuffer buf = new StringBuffer();
        buf.append(entity);
        buf.append(' ');
        buf.append(interval);
        String command = new String(buf);
        LESendResponse resp = this.send((byte)23, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
        try {
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public void killMonitor(long req) throws LEDSSException {
        String command = new String(String.valueOf(Long.toString(req)) + " 0");
        LESendResponse resp = this.send((byte)23, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
    }

    public void connectUser() throws IOException, LEDSSException {
        this.preConnect();
        try {
            if (this.m_username.equals("!root")) {
                this.connect();
                return;
            }
            byte[] buf = new byte[this.m_password.length() + 65];
            byte[] tmp = this.m_username.getBytes();
            System.arraycopy(tmp, 0, buf, 0, tmp.length);
            tmp = this.m_password.getBytes();
            System.arraycopy(tmp, 0, buf, 64, tmp.length);
            LESendResponse resp = this.send((byte)20, (short)buf.length, buf, false);
            if (!resp.successful()) {
                this.disconnect();
                throw new LEDSSPMAuthFailureException("");
            }
            this.postConnect();
        }
        catch (UnknownHostException unknownHostException) {
            String msg = "Unknown host: " + this.m_hostname;
            this.disconnect();
            throw new UnknownHostException(msg);
        }
        catch (LEDSSPMOpFailureException xc) {
            String msg = xc.getMessage();
            this.disconnect();
            throw new LEDSSPMAuthFailureException(msg);
        }
    }

    public void connectOTP() throws IOException, LEDSSException {
        this.preConnect();
        LESendResponse resp = this.send((byte)2, (short)this.m_password.length(), this.m_password, false);
        if (!resp.successful()) {
            this.disconnect();
            throw new LEDSSPMAuthFailureException("");
        }
        this.postConnect();
    }

    public void connect() throws IOException, LEDSSException {
        this.preConnect();
        byte[] data = new byte[]{0};
        LESendResponse resp = this.send((byte)18, (short)1, data, false);
        if (!resp.successful()) {
            this.connectOTP();
            return;
        }
        MD5 md5 = new MD5();
        byte[] buf = new byte[50];
        LETokenizer _streamTok = resp.getStreamTok();
        _streamTok.getNextRawBytes(1);
        byte[] digest = _streamTok.getNextRawBytes(16);
        md5.update(this.m_password);
        md5.update(digest);
        md5.update("Command> ");
        digest = md5.digest();
        resp = this.send((byte)19, (short)16, digest, false);
        if (!resp.successful()) {
            this.disconnect();
            throw new LEDSSPMAuthFailureException("");
        }
        this.postConnect();
    }

    public void disconnect() {
        this.disconnect(2);
    }

    public boolean reconnect() {
        if (this.isConnected()) {
            return true;
        }
        boolean success = true;
        try {
            if (this.m_oneTimePass) {
                this.connectOTP();
            } else if (this.m_username != null) {
                this.connectUser();
            } else {
                this.connect();
            }
        }
        catch (LEDSSException lEDSSException) {
            success = false;
        }
        catch (Exception e) {
            success = false;
            LEDebug.getLog().logln(20, e);
        }
        return success;
    }

    LEPMCommand reboot(LEPMCommand cmd) {
        LEDebug.getLog().logln(40, "** REBOOTING **");
        boolean fail = false;
        cmd = this.execute(cmd);
        if (!cmd.getStatus()) {
            return cmd;
        }
        this.disconnect(4);
        if (!this.waitAndReconnect() && !this.waitAndReconnect()) {
            fail = true;
        }
        if (fail) {
            LEStatusMessage stat = new LEStatusMessage(2);
            LEAMManager.Process(this.m_hostname, "STATUS", stat);
        }
        return cmd;
    }

    boolean waitAndReconnect() {
        boolean success = false;
        try {
            Thread.currentThread();
            Thread.sleep(20000L);
            if (this.m_oneTimePass) {
                this.connectOTP();
            } else if (this.m_username != null) {
                this.connectUser();
            } else {
                this.connect();
            }
            success = this.isConnected();
        }
        catch (LEDSSException lEDSSException) {
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return success;
    }

    void disconnect(int status) {
        try {
            if (this.m_pmfd != null) {
                if (this.m_listener != null) {
                    this.m_listener.shutdown();
                }
                this.m_listener = null;
                LEStatusMessage stat = new LEStatusMessage(status);
                LEAMManager.Process(this.m_hostname, "STATUS", stat);
                this.m_outStream.close();
                this.m_pmfd.close();
            }
        }
        catch (Exception exception) {}
        this.m_outStream = null;
        this.m_pmfd = null;
    }

    public synchronized void update(LEObservable obs, Object obj) {
        this.m_sbInQ.add(obj);
        this.notifyAll();
        if (obj instanceof IOException) {
            this.disconnect();
            Exception xc = (Exception)obj;
            LEStatusMessage stat = new LEStatusMessage(3, xc);
            LEAMManager.Process(this.m_hostname, "STATUS", stat);
        } else if (obj instanceof Exception) {
            this.disconnect();
            Exception e = (Exception)obj;
            LEDSSException xc = new LEDSSException(e.getMessage());
            LEStatusMessage stat = new LEStatusMessage(3, xc);
            LEAMManager.Process(this.m_hostname, "STATUS", stat);
        }
    }

    public synchronized void finalize() {
        this.disconnect();
    }

    public boolean supportsEntities() {
        return this.m_newCommand;
    }

    protected void postConnect() throws LEDSSException {
        this.testNewCommand();
        LEStatusMessage stat = new LEStatusMessage(1);
        LEAMManager.Process(this.m_hostname, "STATUS", stat);
    }

    protected void testNewCommand() {
        try {
            LESendResponse resp = this.send((byte)33, (short)TEST_COMMAND.length(), TEST_COMMAND, true);
            if (resp.successful()) {
                this.recv(true);
                this.m_newCommand = true;
            } else {
                this.m_newCommand = false;
            }
            this.done();
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    protected LEPMCommand execute(LEPMCommand command) {
        return this.execute(command, TIMEOUT_MILLIS);
    }

    protected LEPMCommand execute(LEPMCommand command, int timeout) {
        LESendResponse resp;
        boolean failure = false;
        String cmd = command.getCommand();
        StringBuffer result = new StringBuffer();
        if (this.m_newCommand) {
            resp = this.send((byte)33, (short)cmd.length(), cmd, true, timeout);
            if (resp.successful()) {
                while (!failure && resp.m_opCode != 9) {
                    String data = new String(resp.m_data, 0, (int)resp.m_sendLength);
                    int index = data.indexOf(NC_MORE);
                    if (index > -1) {
                        data = data.substring(0, index);
                    }
                    result.append(data);
                    resp = this.recv(true, timeout);
                    if (resp.successful()) continue;
                    failure = true;
                }
            } else {
                failure = true;
            }
            this.done();
        } else {
            resp = this.send((byte)4, (short)cmd.length(), cmd, false, timeout);
            if (!resp.successful()) {
                failure = true;
            }
        }
        if (resp.timedout()) {
            command.setResult("Connection lost");
        } else if (resp.getException() != null) {
            command.setResult("Connection lost");
        } else {
            command.setResult(new String(result));
        }
        if (failure) {
            command.setStatus(false);
            LEAMManager.Process(this.m_hostname, "CMD_FAILED", command);
        }
        return command;
    }

    public LESendResponse send(byte opCode, short length, String data, boolean multiPacket) {
        return this.send(opCode, length, data, multiPacket, TIMEOUT_MILLIS);
    }

    public LESendResponse send(byte opCode, short length, String data, boolean multiPacket, int timeout) {
        byte[] tmp = data.getBytes();
        byte[] dst = new byte[length + 1];
        System.arraycopy(tmp, 0, dst, 0, length);
        short s = length;
        length = (short)(s + 1);
        dst[s] = 0;
        return this.send(opCode, length, dst, multiPacket, timeout);
    }

    public LESendResponse send(byte opCode, short length, byte[] data, boolean multiPacket) {
        return this.send(opCode, length, data, multiPacket, TIMEOUT_MILLIS);
    }

    public LESendResponse send(byte opCode, short length, byte[] data, boolean multiPacket, int timeout) {
        this.send(opCode, length, data);
        return this.recv(multiPacket, timeout);
    }

    public synchronized void send(byte opCode, short length, byte[] data) {
        Thread thread = Thread.currentThread();
        this.m_threads.addElement(thread);
        while (thread != (Thread)this.m_threads.firstElement()) {
            try {
                this.wait();
            }
            catch (Exception xc) {
                LEDebug.getLog().logln(20, xc);
            }
        }
        this.m_sbInQ.removeAllElements();
        this.m_sbOut.reset();
        this.m_sbOut.m_idByte = (byte)101;
        this.m_sbOut.m_opCode = opCode;
        this.m_sbOut.m_sendLength = length;
        System.arraycopy(data, 0, this.m_sbOut.m_data, 0, length);
        try {
            this.m_outStream.write(this.m_sbOut.getBytes(), 0, length + 4);
            this.m_outStream.flush();
            this.dumpLogV("Sent: " + LEDSSPortMaster.GetOpCodeString(this.m_sbOut.m_opCode));
            LEDSSPortMaster.dumpSRMsg("Sent: " + LEDSSPortMaster.GetOpCodeString(this.m_sbOut.m_opCode));
            LEDSSPortMaster.dumpSRMsg(this.m_sbOut.toString());
            LEDSSPortMaster.dumpSRMsg("End send");
            LEDSSPortMaster.dumpSRMsg("");
        }
        catch (Exception xc) {
            LEDebug.getLog().logln(20, xc);
            this.update(this, xc);
        }
    }

    public LESendResponse recv(boolean multiPacket) {
        return this.recv(multiPacket, TIMEOUT_MILLIS);
    }

    public synchronized LESendResponse recv(boolean multiPacket, long timeout) {
        long millis = System.currentTimeMillis();
        long diff = 0L;
        boolean timedout = false;
        while (!timedout && this.m_sbInQ.size() == 0) {
            diff = System.currentTimeMillis() - millis;
            try {
                this.wait(timeout - diff);
            }
            catch (Exception xc) {
                LEDebug.getLog().logln(20, xc);
            }
            if (System.currentTimeMillis() - millis < timeout) continue;
            timedout = true;
        }
        LESendResponse resp = null;
        if (this.m_sbInQ.size() > 0) {
            Object obj = this.m_sbInQ.removeElementAt(0);
            if (obj instanceof LESendResponse) {
                resp = (LESendResponse)obj;
            } else if (obj instanceof Exception) {
                resp = new LESendResponse((Exception)obj);
            }
        } else {
            resp = new LESendResponse();
            resp.setTimeout(true);
        }
        resp.checkSuccess();
        if (resp.successful()) {
            this.dumpLogV("Received: " + LEDSSPortMaster.GetOpCodeString(resp.m_opCode));
            LEDSSPortMaster.dumpSRMsg("Received: " + LEDSSPortMaster.GetOpCodeString(resp.m_opCode));
            LEDSSPortMaster.dumpSRMsg(resp.toString());
            LEDSSPortMaster.dumpSRMsg("End Receive");
            LEDSSPortMaster.dumpSRMsg("");
        } else if (resp.timedout()) {
            this.dumpLogV("Received: TIMEOUT");
            LEDSSPortMaster.dumpSRMsg("Received: TIMEOUT");
            this.disconnect();
        } else if (resp.getException() != null) {
            this.dumpLogV("Received: EXCEPTION " + resp.getException().toString());
            LEDSSPortMaster.dumpSRMsg("Received: EXCEPTION " + resp.getException().toString());
        }
        if (!multiPacket) {
            this.done();
        }
        return resp;
    }

    public synchronized void done() {
        Thread cur = Thread.currentThread();
        if (this.m_threads.size() == 0) {
            this.dumpLogV("Done called on empty queue: " + cur.getName() + ", " + this.m_threads.toString());
            return;
        }
        if (cur.equals(this.m_threads.firstElement())) {
            this.m_threads.removeElementAt(0);
        } else {
            this.dumpLogV("Done called by wrong thread: " + cur.getName() + ", " + this.m_threads.toString());
        }
        this.notifyAll();
    }

    private void preConnect() throws IOException {
        if (this.m_pmfd == null) {
            try {
                this.m_pmfd = new Socket(this.m_hostname, 1643);
            }
            catch (UnknownHostException unknownHostException) {
                String msg = "Unknown host: " + this.m_hostname;
                this.disconnect();
                throw new UnknownHostException(msg);
            }
            this.m_listener = new LEPMListen(new DataInputStream(this.m_pmfd.getInputStream()), this.m_hostname);
            this.m_listener.addObserver(this);
            this.m_listener.start();
            this.m_outStream = this.m_pmfd.getOutputStream();
        }
    }

    protected static String GetOpCodeString(int opCode) {
        String opcode;
        switch (opCode) {
            case 2: {
                opcode = "NC_INIT";
                break;
            }
            case 3: {
                opcode = "NC_DISC";
                break;
            }
            case 4: {
                opcode = "NC_COMMAND";
                break;
            }
            case 5: {
                opcode = "NC_DOWNLOAD";
                break;
            }
            case 6: {
                opcode = "NC_DOWNDATA";
                break;
            }
            case 7: {
                opcode = "NC_RENAME";
                break;
            }
            case 8: {
                opcode = "NC_STATUS";
                break;
            }
            case 9: {
                opcode = "NC_REPLY";
                break;
            }
            case 10: {
                opcode = "NC_RAW_WRITE";
                break;
            }
            case 11: {
                opcode = "NC_IOSTAT";
                break;
            }
            case 12: {
                opcode = "NC_UPLOAD";
                break;
            }
            case 13: {
                opcode = "NC_UPDATA";
                break;
            }
            case 14: {
                opcode = "NC_CDATA";
                break;
            }
            case 15: {
                opcode = "NC_RESET";
                break;
            }
            case 16: {
                opcode = "NC_NETSTATUS";
                break;
            }
            case 17: {
                opcode = "NC_TABLE";
                break;
            }
            case 18: {
                opcode = "NC_CHALLENGE";
                break;
            }
            case 19: {
                opcode = "NC_MD5_PASS";
                break;
            }
            case 20: {
                opcode = "NC_USER_PASS";
                break;
            }
            case 21: {
                opcode = "NC_BK";
                break;
            }
            case 22: {
                opcode = "NC_TOC";
                break;
            }
            case 23: {
                opcode = "NC_MONITOR";
                break;
            }
            case 25: {
                opcode = "NC_DELTA";
                break;
            }
            case 29: {
                opcode = "NC_ALARMS";
                break;
            }
            case 30: {
                opcode = "NC_ALARMMSG";
                break;
            }
            case 24: {
                opcode = "NC_DEBUG";
                break;
            }
            case 26: {
                opcode = "NC_MONMESSAGE";
                break;
            }
            case 27: {
                opcode = "NC_DBGMESSAGE";
                break;
            }
            case 28: {
                opcode = "NC_DELTAMSG";
                break;
            }
            case 31: {
                opcode = "NC_ENTITY";
                break;
            }
            case 32: {
                opcode = "NC_ENTITYMSG";
                break;
            }
            case 33: {
                opcode = "NC_NEWCOMMAND";
                break;
            }
            case 34: {
                opcode = "NC_NEWCMDMSG";
                break;
            }
            default: {
                opcode = "Unknown";
            }
        }
        return opcode;
    }

    protected void dumpLogV(String msg) {
        LEDebug.getLog().logln(40, msg);
    }

    protected void dumpLog(int level, String msg) {
        LEDebug.getLog().logln(level, msg);
    }

    public static void dumpSRMsg(String str) {
        block2: {
            if (s_pw == null || !LEDebug.getLog().shouldLog(30)) break block2;
            try {
                s_pw.println(str);
            }
            catch (Exception xc) {
                LEDebug.getLog().logln(20, xc);
            }
        }
    }

    protected synchronized void initialize() {
        this.m_sbOut = new LESendBuf();
        this.m_sbOut.setSize(2048);
        this.m_sbInQ = new LEFifo();
        if (s_dbgFile == null) {
            try {
                String path = LEAppInfo.getUserAppDirPath("sendrecv.txt");
                File file = new File(path);
                s_dbgFile = new FileWriter(file);
                s_pw = new PrintWriter((Writer)s_dbgFile, true);
            }
            catch (Exception exception) {
                s_dbgFile = null;
                s_pw = null;
            }
        }
        LEAlarmFactory.Register();
        LECmdFailedFactory.Register();
        LEDebugFactory.Register();
        LEDeltaFactory.Register();
        LEMonitorFactory.Register();
        LEPortIOFactory.Register();
        LEStatusFactory.Register();
    }

    protected synchronized void initialize(String hostname, String username, String password) {
        this.initialize();
        this.m_hostname = hostname;
        this.m_username = username;
        this.m_password = password;
    }

    LEDSSException getLEDSSException(LESendResponse resp) {
        if (resp.timedout()) {
            return new LEDSSPMOpFailureException(REQ_TIMEOUT);
        }
        Exception xc = resp.getException();
        if (xc != null) {
            return new LEDSSPMOpFailureException(xc.getMessage());
        }
        return new LEDSSPMOpFailureException(UNEXPLAINED);
    }

    static {
        s_sleepTime = 100;
        s_timeoutCount = 900;
        TIMEOUT_MILLIS = 10000;
    }
}

