/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.backend;

import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAsyncMessage;
import COM.livingston.backend.LEDebugMessage;
import COM.livingston.backend.LEPPPDebugMessage;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LETokenizer;
import COM.livingston.util.LEVector;
import java.io.IOException;
import java.util.StringTokenizer;

public class LEDebugFactory
extends LEAMFactory {
    public static final String DEBUG = "DEBUG";
    public static final String TYPE_PPP = "PPP";
    public static final String TYPE_ISDN_DCHANNEL = "ISDN_DCHANNEL";
    public static final String TYPE_MISC = "MISC";
    static LEDebugFactory s_factory = null;

    public static LEAMFactory GetFactory() {
        if (s_factory == null) {
            s_factory = new LEDebugFactory();
        }
        return s_factory;
    }

    public static void Register() {
        LEDebugFactory.GetFactory();
    }

    LEDebugFactory() {
        LEAMFactory.GetFactory().register(DEBUG, this);
    }

    protected void produce(LEAsyncMessage msg, LEVector observers) {
        if (observers == null) {
            return;
        }
        LETokenizer tok = (LETokenizer)msg.getData();
        if (tok == null) {
            return;
        }
        int request = -1;
        try {
            request = tok.getNextInt();
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
            LEDebug.getLog().logln(20, e);
            return;
        }
        String host = msg.getHost();
        long timestamp = msg.getTimestamp();
        try {
            while (true) {
                int tmp = tok.getNextInt();
                String value = tok.getNextQuotedString();
                if (tmp != 120) continue;
                String type = LEDebugFactory.determineType(value);
                if (type.equals(TYPE_PPP)) {
                    StringTokenizer st = new StringTokenizer(value, "\t\r\n", false);
                    StringBuffer data = new StringBuffer(st.nextToken());
                    while (st.hasMoreElements()) {
                        String tempstring = st.nextToken();
                        StringTokenizer strtok = new StringTokenizer(tempstring);
                        try {
                            Integer.parseInt(strtok.nextToken(), 16);
                            data.append(tempstring);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.notify(observers, host, new LEPPPDebugMessage(request, timestamp, data.toString()));
                            data = new StringBuffer(tempstring);
                        }
                    }
                    this.notify(observers, host, new LEPPPDebugMessage(request, timestamp, data.toString()));
                    continue;
                }
                this.notify(observers, host, new LEDebugMessage(request, timestamp, value));
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    private static String determineType(String stringtoprocess) {
        if (stringtoprocess.indexOf("LCP") != -1) {
            return TYPE_PPP;
        }
        if (stringtoprocess.indexOf("PAP_") != -1) {
            return TYPE_PPP;
        }
        if (stringtoprocess.indexOf("CHAP_") != -1) {
            return TYPE_PPP;
        }
        if (stringtoprocess.indexOf("IPCP") != -1) {
            return TYPE_PPP;
        }
        if (stringtoprocess.indexOf("IPXCP_") != -1) {
            return TYPE_PPP;
        }
        if (stringtoprocess.indexOf("CCP") != -1) {
            return TYPE_PPP;
        }
        if (stringtoprocess.indexOf("Connection") != -1) {
            return TYPE_PPP;
        }
        return TYPE_MISC;
    }
}

