/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.backend;

import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAsyncMessage;
import COM.livingston.backend.LEEntityMessage;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LETokenizer;
import COM.livingston.util.LEVector;
import java.io.IOException;

public abstract class LEEntityFactory
extends LEAMFactory {
    protected void produce(LEAsyncMessage msg, LEVector observers) {
        if (observers == null) {
            return;
        }
        Object obj = msg.getData();
        if (!(obj instanceof LETokenizer)) {
            return;
        }
        LETokenizer tok = (LETokenizer)obj;
        int request = -1;
        try {
            request = tok.getNextInt();
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return;
        }
        String host = msg.getHost();
        long timestamp = msg.getTimestamp();
        LEEntityMessage emsg = null;
        String name = null;
        boolean more = true;
        while (more) {
            try {
                int tmp = tok.getNextInt();
                String value = tok.getNextQuotedString();
                if (tmp >= 65536) {
                    if (value.equals(name)) continue;
                    if (emsg != null) {
                        this.notify(observers, host, emsg);
                    }
                    if ((emsg = this.createMessage(request, tmp, value)) != null) {
                        emsg.setTimestamp(timestamp);
                    }
                    name = value;
                    continue;
                }
                if (emsg == null) continue;
                emsg.setAttribute(tmp, value);
            }
            catch (IOException iOException) {
                more = false;
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
                more = false;
            }
        }
        if (emsg != null) {
            this.notify(observers, host, emsg);
        }
    }

    abstract LEEntityMessage createMessage(int var1, int var2, String var3);
}

