/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEForm;
import COM.livingston.forms.LEModemsPanel;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LECompMatrix;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEStatusDialog;
import COM.livingston.ui.LETriStateBox;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;

public class LEModemsForm
extends Panel
implements LEForm,
ItemListener,
ActionListener {
    LEVector m_context;
    LEPortMaster[] m_pms;
    Hashtable m_panels = new Hashtable();
    Panel m_bottom;
    Panel m_buttons;
    Checkbox m_last;
    Button m_busy;
    Button m_avail;
    Button m_lastcall;

    public LEModemsForm() {
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        Label label = new Label("Legend: ");
        label.setFont(LEFont.getBoldFont());
        panel.add(label);
        LETriStateBox lETriStateBox = new LETriStateBox("Busy");
        lETriStateBox.setFrozen(true);
        panel.add(lETriStateBox);
        LETriStateBox lETriStateBox2 = new LETriStateBox("Last Call", 1);
        lETriStateBox2.setFrozen(true);
        panel.add(lETriStateBox2);
        LETriStateBox lETriStateBox3 = new LETriStateBox("Available", 2);
        lETriStateBox3.setFrozen(true);
        panel.add(lETriStateBox3);
        this.m_bottom = new Panel(new BorderLayout());
        this.m_bottom.add("West", panel);
        this.m_buttons = new Panel();
        this.m_buttons.setLayout(new FlowLayout(1));
        this.m_buttons.add(new Label("Set all modems on selected card: "));
        this.m_busy = new Button("Busy");
        this.m_buttons.add(this.m_busy);
        this.m_busy.addActionListener(this);
        this.m_lastcall = new Button("Last Call");
        this.m_buttons.add(this.m_lastcall);
        this.m_lastcall.addActionListener(this);
        this.m_avail = new Button("Available");
        this.m_buttons.add(this.m_avail);
        this.m_avail.addActionListener(this);
        this.m_bottom.add("Center", this.m_buttons);
        this.m_bottom.add("East", panel);
    }

    public void setContext(LEVector lEVector) {
        this.m_context = lEVector;
    }

    public void setPortMasters(LEPortMaster[] lEPortMasterArray) {
        Object object;
        int n;
        boolean bl = false;
        if (this.m_pms != null) {
            int n2 = 0;
            while (n2 < this.m_pms.length) {
                n = 0;
                int n3 = 0;
                while (n == 0 && n3 < lEPortMasterArray.length) {
                    if (this.m_pms[n2] == lEPortMasterArray[n3]) {
                        n = 1;
                    }
                    ++n3;
                }
                if (n == 0) {
                    object = (LEModemsPanel)this.m_panels.remove(this.m_pms[n2].getHostname());
                    ((LEModemsPanel)object).gone();
                    bl = true;
                }
                ++n2;
            }
        }
        n = 0;
        while (n < lEPortMasterArray.length) {
            object = lEPortMasterArray[n].getHostname();
            if (this.m_panels.get(object) == null) {
                this.m_panels.put(object, new LEModemsPanel(lEPortMasterArray[n], this.m_context, this));
                bl = true;
            }
            ++n;
        }
        this.m_pms = lEPortMasterArray;
        if (bl) {
            this.removeAll();
            CheckboxGroup checkboxGroup = new CheckboxGroup();
            String[] stringArray = this.getRowTitles();
            String[] stringArray2 = this.getColumnTitles();
            Component[][] componentArray = this.getFormComponents(checkboxGroup);
            LECompMatrix lECompMatrix = new LECompMatrix(stringArray, stringArray2, componentArray, true);
            LEBorderPanel lEBorderPanel = new LEBorderPanel(1);
            lEBorderPanel.setLayout(new BorderLayout());
            lEBorderPanel.add("Center", new LEScrollPanel(lECompMatrix));
            this.add("Center", lEBorderPanel);
            this.add("South", this.m_bottom);
            this.selectFirstSlot(checkboxGroup);
            this.invalidate();
            this.validate();
        }
    }

    public void save(Frame frame) {
        LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        int n = 0;
        while (n < this.m_pms.length) {
            LEModemsPanel lEModemsPanel = (LEModemsPanel)this.m_panels.get(this.m_pms[n].getHostname());
            lEModemsPanel.save();
            ++n;
        }
        lEStatusDialog.hideStatus();
    }

    public void refresh() {
        LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        int n = 0;
        while (n < this.m_pms.length) {
            LEModemsPanel lEModemsPanel = (LEModemsPanel)this.m_panels.get(this.m_pms[n].getHostname());
            lEModemsPanel.refresh();
            ++n;
        }
        lEStatusDialog.hideStatus();
    }

    public void gone() {
        int n = 0;
        while (n < this.m_pms.length) {
            LEModemsPanel lEModemsPanel = (LEModemsPanel)this.m_panels.remove(this.m_pms[n].getHostname());
            lEModemsPanel.gone();
            ++n;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.select((Checkbox)itemEvent.getSource());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_busy) {
            int n = 0;
            while (n < this.m_pms.length) {
                String string = this.m_pms[n].getHostname();
                LEModemsPanel lEModemsPanel = (LEModemsPanel)this.m_panels.get(string);
                lEModemsPanel.busyAllModems();
                ++n;
            }
            return;
        }
        if (actionEvent.getSource() == this.m_avail) {
            int n = 0;
            while (n < this.m_pms.length) {
                String string = this.m_pms[n].getHostname();
                LEModemsPanel lEModemsPanel = (LEModemsPanel)this.m_panels.get(string);
                lEModemsPanel.enableAllModems();
                ++n;
            }
            return;
        }
        int n = 0;
        while (n < this.m_pms.length) {
            String string = this.m_pms[n].getHostname();
            LEModemsPanel lEModemsPanel = (LEModemsPanel)this.m_panels.get(string);
            lEModemsPanel.lastCallAllModems();
            ++n;
        }
    }

    String[] getRowTitles() {
        String[] stringArray = new String[]{"Modems"};
        return stringArray;
    }

    String[] getColumnTitles() {
        String[] stringArray = new String[this.m_pms.length];
        int n = 0;
        while (n < this.m_pms.length) {
            stringArray[n] = this.m_pms[n].getHostname();
            ++n;
        }
        return stringArray;
    }

    Component[][] getFormComponents(CheckboxGroup checkboxGroup) {
        Component[][] componentArray = new Component[1][this.m_pms.length];
        int n = 0;
        while (n < this.m_pms.length) {
            String string = this.m_pms[n].getHostname();
            LEModemsPanel lEModemsPanel = (LEModemsPanel)this.m_panels.get(string);
            lEModemsPanel.setCheckboxGroup(checkboxGroup);
            componentArray[0][n] = lEModemsPanel;
            ++n;
        }
        return componentArray;
    }

    void select(Checkbox checkbox) {
        if (this.m_last != null) {
            this.m_last.setBackground(this.getBackground());
            this.m_last.setForeground(this.getForeground());
        }
        this.m_last = checkbox;
        this.m_last.setBackground(LEColor.getSelectBackground());
        this.m_last.setForeground(LEColor.getSelectForeground());
    }

    void selectFirstSlot(CheckboxGroup checkboxGroup) {
        Checkbox checkbox = null;
        int n = 0;
        while (checkbox == null && n < this.m_pms.length) {
            String string = this.m_pms[n].getHostname();
            LEModemsPanel lEModemsPanel = (LEModemsPanel)this.m_panels.get(string);
            checkbox = lEModemsPanel.getFirstSlot();
            ++n;
        }
        if (checkbox != null) {
            checkboxGroup.setSelectedCheckbox(checkbox);
            this.select(checkbox);
        }
    }
}

