/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEDBNetUser;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LEDBNetUsers
extends LETable {
    public LEDBNetUsers(LEPortMaster pm) {
        super(pm);
    }

    public Object clone() {
        LEDBNetUsers config = new LEDBNetUsers(this.m_pm);
        this.copyTo(config);
        return config;
    }

    public LEVector add(String name, String location) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("netuser", name);
        LEPMCommand ret = this.m_pm.execute(cmd);
        if (ret.getStatus()) {
            cmd = this.makeSetCommand("user", name, "dialback", location);
            ret = this.m_pm.execute(cmd);
        }
        if (ret.getStatus()) {
            ret = this.m_pm.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("user", name);
        LEPMCommand ret = this.m_pm.execute(cmd);
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_pm.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LEDBNetUser(this.m_pm, key);
    }

    boolean getChildCommands(LEConfig child, LEVector cmds) {
        LEDBNetUser user = (LEDBNetUser)child;
        StringBuffer buf = new StringBuffer("add ");
        buf.append("netuser ");
        buf.append(user.getName());
        cmds.addElement(new String(buf));
        child.getAllCommands(cmds);
        return true;
    }
}

