/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;

public class LEEthernet
extends LEConfig {
    public static final String ADDRESS = "address";
    public static final String BROADCAST = "broadcast";
    public static final String INPUT_FILTER = "ifilter";
    public static final String IP_STATUS = "ip";
    public static final String IPX_FRAME = "ipxframe";
    public static final String IPX_NETWORK = "ipxnet";
    public static final String IPX_STATUS = "ipx";
    public static final String MAC_ADDRESS = "macaddress";
    public static final String NETMASK = "netmask";
    public static final String OSPF = "ospf";
    public static final String OUTPUT_FILTER = "ofilter";
    public static final String RIP_BROAD = "RIPBroadcast";
    public static final String RIP_LISTEN = "RIPListen";
    public static final int KEY_COUNT = 13;
    public static final String HIGH = "high";
    public static final String LOW = "low";
    public static final String ETHERNET_802_2 = "ethernet_802.2";
    public static final String ETHERNET_802_2_II = "ethernet_802.2_ii";
    public static final String ETHERNET_802_3 = "ethernet_802.3";
    public static final String ETHERNET_II = "ethernet_ii";
    static String[] s_keys = null;
    String m_name;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[13];
            int i = 0;
            LEEthernet.s_keys[i++] = ADDRESS;
            LEEthernet.s_keys[i++] = BROADCAST;
            LEEthernet.s_keys[i++] = INPUT_FILTER;
            LEEthernet.s_keys[i++] = IP_STATUS;
            LEEthernet.s_keys[i++] = IPX_FRAME;
            LEEthernet.s_keys[i++] = IPX_NETWORK;
            LEEthernet.s_keys[i++] = IPX_STATUS;
            LEEthernet.s_keys[i++] = MAC_ADDRESS;
            LEEthernet.s_keys[i++] = NETMASK;
            LEEthernet.s_keys[i++] = OSPF;
            LEEthernet.s_keys[i++] = OUTPUT_FILTER;
            LEEthernet.s_keys[i++] = RIP_BROAD;
            LEEthernet.s_keys[i++] = RIP_LISTEN;
        }
        return s_keys;
    }

    public LEEthernet(LEPortMaster pm, String name) {
        super(pm);
        this.m_name = name;
    }

    public Object clone() {
        LEEthernet config = new LEEthernet(this.m_pm, this.m_name);
        this.copyTo(config);
        return config;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(ADDRESS)) {
            this.makeSetCommand(cmds, this.m_name, ADDRESS, ADDRESS);
        }
        if (allCmds || keys.contains(BROADCAST)) {
            this.makeSetCommand(cmds, this.m_name, BROADCAST, BROADCAST);
        }
        if (allCmds || keys.contains(INPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_name, INPUT_FILTER, INPUT_FILTER);
        }
        if (allCmds || keys.contains(IP_STATUS)) {
            this.makeSetCommand(cmds, this.m_name, IP_STATUS, IP_STATUS);
        }
        if (allCmds || keys.contains(IPX_FRAME)) {
            this.makeSetCommand(cmds, this.m_name, IPX_FRAME, IPX_FRAME);
        }
        if (allCmds || keys.contains(IPX_NETWORK)) {
            this.makeSetCommand(cmds, this.m_name, IPX_NETWORK, IPX_NETWORK);
        }
        if (allCmds || keys.contains(IPX_STATUS)) {
            this.makeSetCommand(cmds, this.m_name, IPX_STATUS, IPX_STATUS);
        }
        if (allCmds || keys.contains(NETMASK)) {
            this.makeSetCommand(cmds, this.m_name, NETMASK, NETMASK);
        }
        if (allCmds || keys.contains(OSPF)) {
            this.makeSetCommand(cmds, this.m_name, OSPF, OSPF);
        }
        if (allCmds || keys.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_name, OUTPUT_FILTER, OUTPUT_FILTER);
        }
        if (allCmds || keys.contains(RIP_BROAD) || keys.contains(RIP_LISTEN)) {
            this.makeRIPCommand(cmds, this.m_name, "rip", (String)this.get(RIP_BROAD), (String)this.get(RIP_LISTEN));
        }
        return cmds.size() > start;
    }
}

