/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEGroup;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LEGroups
extends LETable {
    String m_line;

    public LEGroups(LEPortMaster pm, String line) {
        super(pm);
        this.m_line = line;
    }

    public Object clone() {
        LEGroups config = new LEGroups(this.m_pm, this.m_line);
        this.copyTo(config);
        return config;
    }

    public String getLine() {
        return this.m_line;
    }

    public LEVector add(String cgroup, String channels, String rate) {
        LEGroup group = (LEGroup)this.getConfig(cgroup);
        group.set("132", channels);
        group.set("130", rate);
        LEVector errors = group.saveChanges();
        this.refresh();
        return errors;
    }

    public LEVector delete(String cgroup) {
        LEVector cmds;
        LEPMCommand ret;
        LEVector errors = null;
        this.m_fields.remove(cgroup);
        if (this.m_pm != null) {
            StringBuffer buf = new StringBuffer("set ");
            buf.append(this.m_line);
            buf.append(" group none");
            ret = this.m_pm.execute(buf.toString());
            if (!ret.getStatus()) {
                errors = new LEVector();
                errors.addElement(ret);
            }
        }
        if (errors == null && this.m_pm != null && this.getCommands(cmds = new LEVector())) {
            int len = cmds.size();
            int i = 0;
            while (i < len) {
                ret = this.m_pm.execute((String)cmds.elementAt(i));
                if (!ret.getStatus()) {
                    if (errors == null) {
                        errors = new LEVector();
                    }
                    errors.addElement(ret);
                }
                ++i;
            }
        }
        if (errors != null) {
            this.refresh();
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LEGroup(this.m_pm, this.m_line, key);
    }
}

