/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEHost;
import COM.livingston.model.LEOrderedList;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;

public class LEHosts
extends LEOrderedList {
    public LEHosts(LEPortMaster pm) {
        super(pm);
    }

    public Object clone() {
        LEHosts config = new LEHosts(this.m_pm);
        this.copyTo(config);
        return config;
    }

    public LEVector add(String ip, String host) {
        LEVector errors = null;
        StringBuffer buf = new StringBuffer("add ");
        buf.append("host ");
        buf.append(ip);
        buf.append(" ");
        buf.append(host);
        LEPMCommand ret = this.m_pm.execute(buf.toString());
        if (ret.getStatus()) {
            ret = this.m_pm.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String host) {
        LEVector errors = null;
        StringBuffer buf = new StringBuffer("delete ");
        buf.append("host ");
        buf.append(host);
        LEPMCommand ret = this.m_pm.execute(buf.toString());
        if (ret.getStatus()) {
            ret = this.m_pm.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig() {
        return new LEHost(this.m_pm);
    }

    boolean getChildCommands(LEConfig child, LEVector cmds) {
        int start = cmds.size();
        LEHost host = (LEHost)child;
        String ip = (String)host.get("address");
        String name = (String)host.get("hostname");
        if (ip != null && ip.length() > 0 && name != null && name.length() > 0) {
            StringBuffer buf = new StringBuffer("add ");
            buf.append("host ");
            buf.append(ip);
            buf.append(" ");
            buf.append(name);
            cmds.addElement(buf.toString());
        }
        child.getAllCommands(cmds);
        return cmds.size() > start;
    }
}

