/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;

public class LELoginUser
extends LEConfig {
    public static final String HOST = "host";
    public static final String HOST_ADDRESS = "HostAddress";
    public static final String IDLE_TIMEOUT = "idle";
    public static final String INPUT_FILTER = "ifilter";
    public static final String LOGIN_SERVICE = "service";
    public static final String PASSWORD = "password";
    public static final int KEY_COUNT = 6;
    public static final String DEFAULT = "default";
    public static final String PROMPT = "prompt";
    public static final String SPECIFIED = "specified";
    public static final String PORTMASTER = "portmaster";
    public static final String RLOGIN = "rlogin";
    public static final String TELNET = "telnet";
    public static final String NETDATA = "netdata";
    static String[] s_keys = null;
    String m_name;
    String m_tag;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[6];
            int i = 0;
            LELoginUser.s_keys[i++] = HOST;
            LELoginUser.s_keys[i++] = HOST_ADDRESS;
            LELoginUser.s_keys[i++] = IDLE_TIMEOUT;
            LELoginUser.s_keys[i++] = INPUT_FILTER;
            LELoginUser.s_keys[i++] = LOGIN_SERVICE;
            LELoginUser.s_keys[i++] = PASSWORD;
        }
        return s_keys;
    }

    public LELoginUser(LEPortMaster pm, String name) {
        super(pm);
        this.m_name = name;
        this.m_tag = "user " + this.m_name;
    }

    public Object clone() {
        LELoginUser config = new LELoginUser(this.m_pm, this.m_name);
        this.copyTo(config);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(HOST) || keys.contains(HOST_ADDRESS)) {
            String host = (String)this.get(HOST);
            if (host != null && host.equals(SPECIFIED)) {
                this.makeSetCommand(cmds, this.m_tag, HOST_ADDRESS, HOST);
            } else {
                this.makeSetCommand(cmds, this.m_tag, HOST, HOST);
            }
        }
        if (allCmds || keys.contains(IDLE_TIMEOUT)) {
            this.makeSetCommand(cmds, this.m_tag, IDLE_TIMEOUT, IDLE_TIMEOUT);
        }
        if (allCmds || keys.contains(INPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_tag, INPUT_FILTER, INPUT_FILTER);
        }
        if (allCmds || keys.contains(LOGIN_SERVICE)) {
            this.makeServiceCommand(cmds, this.m_tag, LOGIN_SERVICE, LOGIN_SERVICE);
        }
        if (!allCmds && keys.contains(PASSWORD)) {
            this.makeSetCommand(cmds, this.m_tag, PASSWORD, PASSWORD);
        }
        return cmds.size() > start;
    }
}

