/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LENetUser;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LENetUsers
extends LETable {
    public LENetUsers(LEPortMaster pm) {
        super(pm);
    }

    public Object clone() {
        LENetUsers config = new LENetUsers(this.m_pm);
        this.copyTo(config);
        return config;
    }

    public LEVector add(String name) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("netuser", name);
        LEPMCommand ret = this.m_pm.execute(cmd);
        if (ret.getStatus()) {
            ret = this.m_pm.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("user", name);
        LEPMCommand ret = this.m_pm.execute(cmd);
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_pm.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LENetUser(this.m_pm, key);
    }

    boolean getChildCommands(LEConfig child, LEVector cmds) {
        LENetUser user = (LENetUser)child;
        StringBuffer buf = new StringBuffer("add ");
        buf.append("netuser ");
        buf.append(user.getName());
        cmds.addElement(new String(buf));
        child.getAllCommands(cmds);
        return true;
    }
}

