/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LENetworkRanges
extends LETable {
    public static final String RANGE_TAG = "range";
    public static final String ADVERTISE = "advertise";
    public static final String OFF = "off";
    public static final String QUIET = "quiet";
    String m_tag;

    public LENetworkRanges(LEPortMaster pm, String tag) {
        super(pm);
        this.m_tag = String.valueOf(tag) + " " + RANGE_TAG + " ";
    }

    public Object clone() {
        LENetworkRanges config = new LENetworkRanges(this.m_pm, this.m_tag);
        this.copyTo(config);
        return config;
    }

    public LEVector add(String range, String type) {
        LEVector errors = null;
        StringBuffer buf = new StringBuffer("set ");
        buf.append(this.m_tag);
        buf.append(range);
        buf.append(" ");
        buf.append(type);
        LEPMCommand ret = this.m_pm.execute(buf.toString());
        if (ret.getStatus()) {
            ret = this.m_pm.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String range) {
        LEVector errors = null;
        StringBuffer buf = new StringBuffer("set ");
        buf.append(this.m_tag);
        buf.append(range);
        buf.append(" off");
        LEPMCommand ret = this.m_pm.execute(buf.toString());
        if (ret.getStatus()) {
            this.remove(range);
            ret = this.m_pm.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        if (keys == null) {
            keys = this.getKeys();
        }
        int len = keys.size();
        int i = 0;
        while (i < len) {
            String key = (String)keys.elementAt(i);
            StringBuffer buf = new StringBuffer("set ");
            buf.append(this.m_tag);
            buf.append(key);
            buf.append(" ");
            buf.append((String)this.get(key));
            cmds.addElement(new String(buf));
            ++i;
        }
        return len > 0;
    }
}

