/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LESendResponse;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEGroup;
import COM.livingston.model.LEGroups;
import COM.livingston.model.LEHost;
import COM.livingston.model.LEHosts;
import COM.livingston.model.LELine;
import COM.livingston.model.LENetworkRanges;
import COM.livingston.model.LEOSPFArea;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LERoute;
import COM.livingston.model.LESNMPHosts;
import COM.livingston.model.LESubInterface;
import COM.livingston.model.LESubInterfaces;
import COM.livingston.model.LETable;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LETokenizer;
import java.util.StringTokenizer;

public class LEPMEntityParser {
    public static boolean Parse(String key, LEDSSPortMaster dss, LEPortMaster pm) {
        boolean success = true;
        try {
            LEConfig config = pm.getConfig(key);
            LESendResponse resp = dss.send((byte)31, (short)key.length(), key, true);
            if (!resp.successful()) {
                success = false;
            }
            while (success && LEPMEntityParser.Parse(key, config, resp.getStreamTok())) {
                resp = dss.recv(true);
                if (resp.successful()) continue;
                success = false;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            success = false;
        }
        dss.done();
        return success;
    }

    public static boolean Parse(String key, LEConfig config, LETokenizer tok) {
        if (key.equals("327680")) {
            return LEPMEntityParser.ParseSyslog(config, tok);
        }
        if (key.equals("1376256")) {
            return LEPMEntityParser.ParseSNMP(config, tok);
        }
        if (key.equals("1048576")) {
            return LEPMEntityParser.ParseOSPF(config, tok);
        }
        if (key.equals("524288")) {
            return LEPMEntityParser.ParseOSPFAreas(config, tok);
        }
        if (key.equals("1310720")) {
            return LEPMEntityParser.ParseRoutes(config, tok);
        }
        if (key.equals("1245184")) {
            return LEPMEntityParser.ParseHosts(config, tok);
        }
        if (key.equals("196608")) {
            return LEPMEntityParser.ParseModems(config, tok);
        }
        if (key.equals("131072")) {
            return LEPMEntityParser.ParseLines(config, tok);
        }
        if (key.equals("2490368")) {
            return LEPMEntityParser.ParseSubInterface(config, tok);
        }
        return false;
    }

    public static boolean ParseRoutes(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig route = null;
            boolean done = false;
            String destination = null;
            String gateway = null;
            String source = null;
            String type = null;
            block12: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x140000: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block12;
                        destination = tmp;
                        break;
                    }
                    case 74: {
                        destination = tok.getNextQuotedString();
                        break;
                    }
                    case 75: {
                        gateway = tok.getNextQuotedString();
                        break;
                    }
                    case 77: {
                        source = tok.getNextQuotedString().toLowerCase();
                        break;
                    }
                    case 78: {
                        type = tok.getNextQuotedString().toLowerCase();
                        break;
                    }
                    case 82: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        route = null;
                        if (source != null && source.equals("local") && tmp != null && tmp.equals("static") && destination != null) {
                            route = (LERoute)config.getConfig(destination);
                            if (gateway != null) {
                                route.setField("75", gateway);
                            }
                            if (type != null) {
                                route.setField("78", type);
                            }
                            route.setField("77", source);
                            route.setField("82", tmp);
                        }
                        destination = null;
                        gateway = null;
                        source = null;
                        type = null;
                        break;
                    }
                    case 79: 
                    case 81: 
                    case 83: 
                    case 84: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        if (route == null) continue block12;
                        route.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block12;
                        more = true;
                        break;
                    }
                    default: {
                        tok.getNextQuotedString();
                        LEDebug.getLog().logln(20, "Bad Routes attribute: " + attribute);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseSyslog(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            String log = null;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 327680: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block8;
                        log = tmp;
                        break;
                    }
                    case 91: {
                        log = tok.getNextQuotedString();
                        break;
                    }
                    case 90: {
                        String facility = tok.getNextQuotedString();
                        if (log == null) continue block8;
                        config.setField(log, facility);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        tok.getNextQuotedString();
                        LEDebug.getLog().logln(20, "Bad SYSLOG attribute: " + attribute);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseSNMP(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LESNMPHosts hosts = null;
            boolean done = false;
            String key = null;
            block16: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x150000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 17: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 87: {
                        config.setField("sysname", tok.getNextQuotedString());
                        break;
                    }
                    case 85: {
                        config.setField("read", tok.getNextQuotedString());
                        hosts = (LESNMPHosts)config.getConfig("readhost");
                        hosts.clearList();
                        key = "readtype";
                        break;
                    }
                    case 86: {
                        config.setField("write", tok.getNextQuotedString());
                        hosts = (LESNMPHosts)config.getConfig("writehost");
                        hosts.clearList();
                        key = "writetype";
                        break;
                    }
                    case 12: {
                        int count = tok.getNextInt();
                        switch (count) {
                            case -1: {
                                if (key != null) {
                                    config.setField(key, "any");
                                }
                                if (hosts == null) continue block16;
                                hosts.setType(0);
                                break;
                            }
                            case 0: {
                                if (key != null) {
                                    config.setField(key, "none");
                                }
                                if (hosts == null) continue block16;
                                hosts.setType(1);
                                break;
                            }
                            default: {
                                if (key != null) {
                                    config.setField(key, "specified");
                                }
                                if (hosts == null) continue block16;
                                hosts.setType(2);
                                break;
                            }
                        }
                        continue block16;
                    }
                    case 3: {
                        String name = tok.getNextQuotedString();
                        if (name.endsWith(".in-addr.arpa")) {
                            name = LEPMEntityParser.fixHostname(name);
                        }
                        if (hosts == null) continue block16;
                        hosts.addField(name);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block16;
                        more = true;
                        break;
                    }
                    default: {
                        tok.getNextQuotedString();
                        LEDebug.getLog().logln(20, "Bad SNMP attribute: " + attribute);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    static String fixHostname(String name) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tz = new StringTokenizer(name, ".");
        buf.insert(0, tz.nextToken());
        buf.insert(0, '.');
        buf.insert(0, tz.nextToken());
        buf.insert(0, '.');
        buf.insert(0, tz.nextToken());
        buf.insert(0, '.');
        buf.insert(0, tz.nextToken());
        return buf.toString();
    }

    public static boolean ParseOSPF(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            boolean done = false;
            block7: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x100000: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 97: 
                    case 100: {
                        String tmp = tok.getNextQuotedString();
                        if (config == null) continue block7;
                        config.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block7;
                        more = true;
                        break;
                    }
                    default: {
                        tok.getNextQuotedString();
                        LEDebug.getLog().logln(20, "Bad OSPF attribute: " + attribute);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseOSPFAreas(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEOSPFArea area = null;
            LETable ranges = null;
            boolean done = false;
            String advertise = null;
            block14: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 524288: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0 || tmp.equals("0")) continue block14;
                        area = (LEOSPFArea)config.getConfig(tmp);
                        ranges = (LENetworkRanges)area.getConfig("range");
                        break;
                    }
                    case 9: {
                        String tmp = tok.getNextQuotedString();
                        area = (LEOSPFArea)config.getConfig(tmp);
                        ranges = (LENetworkRanges)area.getConfig("range");
                        break;
                    }
                    case 12: {
                        String tmp = tok.getNextQuotedString();
                        int count = Integer.parseInt(tmp);
                        break;
                    }
                    case 101: {
                        String tmp = tok.getNextQuotedString();
                        if (area == null) continue block14;
                        if (tmp.equalsIgnoreCase("md5")) {
                            area.setField("AuthType", "md5");
                        } else if (tmp.equalsIgnoreCase("none")) {
                            area.setField("AuthType", "none");
                        } else {
                            area.setField("AuthType", "password");
                        }
                        if (!tmp.equalsIgnoreCase("md5")) {
                            area.setField("AuthID", "");
                            area.setField("AuthKey", "");
                        }
                        area.setField("password", "");
                        break;
                    }
                    case 99: {
                        String tmp = tok.getNextQuotedString();
                        if (area == null) continue block14;
                        area.setField("AuthID", tmp);
                        break;
                    }
                    case 102: {
                        String tmp = tok.getNextQuotedString();
                        if (area == null) continue block14;
                        area.setField("AuthKey", tmp);
                        break;
                    }
                    case 103: {
                        String tmp = tok.getNextQuotedString();
                        if (area == null) continue block14;
                        if (tmp.equalsIgnoreCase("external")) {
                            area.setField("AreaType", "external");
                            break;
                        }
                        if (tmp.equalsIgnoreCase("stub")) {
                            area.setField("AreaType", "stub");
                            break;
                        }
                        area.setField("AreaType", "nssa");
                        break;
                    }
                    case 117: {
                        String tmp;
                        advertise = tmp = tok.getNextQuotedString();
                        break;
                    }
                    case 104: {
                        String tmp = tok.getNextQuotedString();
                        if (ranges == null || advertise == null) continue block14;
                        ranges.setField(tmp, advertise);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block14;
                        more = true;
                        break;
                    }
                    default: {
                        tok.getNextQuotedString();
                        LEDebug.getLog().logln(20, "Bad OSPF Area attribute: " + attribute);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseHosts(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEHosts hosts = (LEHosts)config;
            hosts.clearList();
            String ipaddress = null;
            boolean done = false;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x130000: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block8;
                        ipaddress = tmp;
                        break;
                    }
                    case 9: {
                        ipaddress = tok.getNextQuotedString();
                        break;
                    }
                    case 3: {
                        String hostname = tok.getNextQuotedString();
                        if (ipaddress == null) continue block8;
                        LEHost host = (LEHost)hosts.addConfig();
                        host.setField("address", ipaddress);
                        host.setField("hostname", hostname);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        tok.getNextQuotedString();
                        LEDebug.getLog().logln(20, "Bad Hosts attribute: " + attribute);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseModems(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            String name = null;
            boolean done = false;
            block8: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 196608: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block8;
                        name = "M" + tmp;
                        break;
                    }
                    case 40: {
                        name = "M" + tok.getNextQuotedString();
                        break;
                    }
                    case 41: {
                        String state = tok.getNextQuotedString();
                        if (name == null) continue block8;
                        config.setField(name, state);
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block8;
                        more = true;
                        break;
                    }
                    default: {
                        tok.getNextQuotedString();
                        LEDebug.getLog().logln(20, "Bad Modems attribute: " + attribute);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    public static boolean ParseLines(LEConfig config, LETokenizer tok) {
        boolean more = false;
        try {
            LEConfig line = null;
            LETable groups = null;
            LEGroup group = null;
            boolean done = false;
            block11: while (!done) {
                int attribute = tok.getNextInt();
                switch (attribute) {
                    case 131072: {
                        String tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block11;
                        line = (LELine)config.getConfig("line" + tmp);
                        groups = (LEGroups)line.getConfig("groups");
                        break;
                    }
                    case 11: {
                        String tmp = "line" + tok.getNextQuotedString();
                        line = (LELine)config.getConfig(tmp);
                        groups = (LEGroups)line.getConfig("groups");
                        break;
                    }
                    case 17: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 37: 
                    case 38: 
                    case 39: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        if (line == null) continue block11;
                        line.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 129: {
                        String tmp = tok.getNextQuotedString();
                        if (groups == null) continue block11;
                        group = (LEGroup)groups.getConfig(tmp);
                        break;
                    }
                    case 130: 
                    case 131: 
                    case 132: {
                        String tmp = tok.getNextQuotedString().toLowerCase();
                        if (group == null) continue block11;
                        group.setField(Integer.toString(attribute), tmp);
                        break;
                    }
                    case 128: {
                        tok.getNextQuotedString();
                        break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block11;
                        more = true;
                        break;
                    }
                    default: {
                        tok.getNextQuotedString();
                        LEDebug.getLog().logln(20, "Bad Lines attribute: " + attribute);
                    }
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseSubInterface(LEConfig config, LETokenizer tok) {
        more = false;
        sub_is = (LESubInterfaces)config;
        sub = null;
        done = false;
        try {
            block11: while (true) lbl-1000:
            // 15 sources

            {
                if (done) {
                    return more;
                }
                attribute = tok.getNextInt();
                switch (attribute) {
                    case 0x260000: {
                        tmp = tok.getNextQuotedString();
                        if (tmp.length() <= 0) continue block11;
                        sub = (LESubInterface)sub_is.getConfig(tmp);
                        ** break;
                    }
                    case 237: {
                        tmp = tok.getNextQuotedString();
                        sub = (LESubInterface)sub_is.getConfig(tmp);
                        ** break;
                    }
                    case 9: {
                        tmp = tok.getNextQuotedString();
                        if (sub == null) continue block11;
                        sub.setField("ipaddress", tmp);
                        ** break;
                    }
                    case 15: {
                        tmp = tok.getNextQuotedString();
                        if (sub == null) continue block11;
                        sub.setField("netmask", tmp);
                        ** break;
                    }
                    case 186: {
                        tmp = tok.getNextQuotedString();
                        if (sub == null) continue block11;
                        sub.setField("broadcast", tmp);
                        ** break;
                    }
                    case 260: {
                        tmp = tok.getNextQuotedString();
                        if (sub == null) continue block11;
                        sub.setField("portname", tmp);
                        ** break;
                    }
                    case 65535: {
                        done = true;
                        if (tok.getNextInt() != 1) continue block11;
                        more = true;
                        ** break;
                    }
                }
                tok.getNextQuotedString();
                LEDebug.getLog().logln(20, "Bad Lines attribute: " + attribute);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return more;
    }
}

