/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEPort;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;

public class LEParallelPort
extends LEPort {
    public static final String DEVICE = "device";
    public static final String HARDWARE_TYPE = "PortHardwareType";
    public static final String HOST = "host";
    public static final String SERVICE = "service_device";
    public static final int KEY_COUNT = 4;
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[4];
            int i = 0;
            LEParallelPort.s_keys[i++] = DEVICE;
            LEParallelPort.s_keys[i++] = HARDWARE_TYPE;
            LEParallelPort.s_keys[i++] = HOST;
            LEParallelPort.s_keys[i++] = SERVICE;
        }
        return s_keys;
    }

    public LEParallelPort(LEPortMaster pm, String name) {
        super(pm, name);
    }

    public Object clone() {
        LEParallelPort config = new LEParallelPort(this.m_pm, this.m_name);
        this.copyTo(config);
        return config;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(DEVICE)) {
            String device = (String)this.get(DEVICE);
            if (device.length() == 0 || device.equals("/")) {
                StringBuffer buf = new StringBuffer(16);
                buf.append("set ");
                buf.append(this.m_name);
                buf.append(" disabled");
                cmds.addElement(buf.toString());
            } else if (device != null) {
                StringBuffer buf = new StringBuffer(25);
                buf.append("set ");
                buf.append(this.m_name);
                buf.append(" device ");
                buf.append(device);
                cmds.addElement(buf.toString());
            }
        }
        if (allCmds || keys.contains(HOST)) {
            this.makeSetCommand(cmds, this.m_name, HOST, HOST);
        }
        if (allCmds || keys.contains(SERVICE)) {
            this.makeServiceCommand(cmds, this.m_name, SERVICE, SERVICE);
        }
        return cmds.size() > start;
    }
}

