/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;

public class LESubInterface
extends LEConfig {
    public static final String IPADDRESS = "ipaddress";
    public static final String NETMASK = "netmask";
    public static final String BROADCAST = "broadcast";
    public static final String PORTNAME = "portname";
    public static final int KEY_COUNT = 4;
    public static final String HIGH = "high";
    public static final String LOW = "low";
    private static final String SUB = "subinterface";
    static String[] s_keys = null;
    String m_name;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[4];
            int i = 0;
            LESubInterface.s_keys[i++] = IPADDRESS;
            LESubInterface.s_keys[i++] = NETMASK;
            LESubInterface.s_keys[i++] = BROADCAST;
            LESubInterface.s_keys[i++] = PORTNAME;
        }
        return s_keys;
    }

    public LESubInterface(LEPortMaster pm, String name) {
        super(pm);
        this.m_name = name;
    }

    public Object clone() {
        LESubInterface config = new LESubInterface(this.m_pm, this.m_name);
        this.copyTo(config);
        return config;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String portname;
        boolean allCmds = keys == null;
        int start = cmds.size();
        String subnname = "subinterface " + this.m_name;
        if (allCmds || keys.contains(IPADDRESS)) {
            this.makeSetCommand(cmds, subnname, IPADDRESS, "address");
        }
        if (allCmds || keys.contains(NETMASK)) {
            this.makeSetCommand(cmds, subnname, NETMASK, NETMASK);
        }
        if (allCmds || keys.contains(BROADCAST)) {
            this.makeSetCommand(cmds, subnname, BROADCAST, BROADCAST);
        }
        if ((allCmds || keys.contains(PORTNAME)) && (portname = (String)this.get(PORTNAME)) != null && portname.length() > 0) {
            this.makeSetCommand(cmds, subnname, PORTNAME, "port-name");
        }
        return cmds.size() > start;
    }
}

