/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LESNMP;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEConfirmDialog;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LETextArea;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class LECommandPanel
extends Panel
implements LEConfirmClient,
LEAMObserver,
ActionListener,
ItemListener {
    static final String BROWSE = new String("Browse...");
    static final String REBOOT = new String("reb");
    static final String SUCCESS = new String("Command succeded");
    static final String FAILURE = new String("Command failed");
    static final String DEFAULT_SYSNAME = new String("Command");
    static final String SEPARATOR = new String("> ");
    static final String SYSTEM_NAME = new String("set sys");
    static final char CR = '\r';
    static final char REPLACEMENT = ' ';
    static String[] s_invalidCmds = null;
    LETextArea m_screen;
    Checkbox m_ignore;
    Checkbox m_echo;
    TextField m_path;
    Button m_browse;
    LEPortMaster m_pm;
    String m_prompt;
    File m_file;
    PrintWriter m_prw;
    boolean m_ignoring;

    static void initInvalidCmds() {
        s_invalidCmds = new String[11];
        LECommandPanel.s_invalidCmds[0] = new String("at");
        LECommandPanel.s_invalidCmds[1] = new String("tr");
        LECommandPanel.s_invalidCmds[2] = new String("pi");
        LECommandPanel.s_invalidCmds[3] = new String("te");
        LECommandPanel.s_invalidCmds[4] = new String("rl");
        LECommandPanel.s_invalidCmds[5] = new String("pm");
        LECommandPanel.s_invalidCmds[6] = new String("pt");
        LECommandPanel.s_invalidCmds[7] = new String("set deb");
        LECommandPanel.s_invalidCmds[8] = new String("se deb");
        LECommandPanel.s_invalidCmds[9] = new String("di");
        LECommandPanel.s_invalidCmds[10] = new String("tf");
    }

    static boolean validCommand(String string) {
        boolean bl = true;
        int n = s_invalidCmds.length;
        int n2 = 0;
        while (bl && n2 < n) {
            String string2;
            if (string.length() >= s_invalidCmds[n2].length() && (string2 = string.substring(0, s_invalidCmds[n2].length())).equalsIgnoreCase(s_invalidCmds[n2])) {
                bl = false;
            }
            ++n2;
        }
        return bl;
    }

    public LECommandPanel(LEPortMaster lEPortMaster) {
        if (s_invalidCmds == null) {
            LECommandPanel.initInvalidCmds();
        }
        this.m_pm = lEPortMaster;
        this.setLayout(new BorderLayout(0, 0));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(3, 1));
        Label label = new Label(this.m_pm.getHostname(), 1);
        label.setFont(LEFont.getBoldFont());
        panel.add(label);
        this.m_ignore = new Checkbox("Ignore Commands", null, false);
        panel.add(this.m_ignore);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(0, 0));
        this.m_echo = new Checkbox("Echo to file:", null, false);
        this.m_echo.addItemListener(this);
        panel2.add("West", this.m_echo);
        this.m_path = new TextField();
        ((Component)this.m_path).setBackground(LEColor.getTextBackground());
        this.m_path.addActionListener(this);
        panel2.add("Center", this.m_path);
        this.m_browse = new Button(BROWSE);
        this.m_browse.addActionListener(this);
        panel2.add("East", this.m_browse);
        panel.add(panel2);
        this.add("North", panel);
        this.m_screen = new LETextArea(24, 80);
        this.add("Center", this.m_screen);
        this.m_screen.setEditable(false);
        this.m_screen.setFont(LEFont.getFixedFont());
        this.setPrompt();
        this.m_screen.append(this.m_prompt);
        LEStatusFactory.GetFactory().addObserver(this.m_pm.getHostname(), this);
    }

    public LEPortMaster getPortMaster() {
        return this.m_pm;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_echo.getState()) {
            this.confirmEchoFile();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(BROWSE)) {
            this.browseFile();
            return;
        }
        if (this.m_echo.getState()) {
            this.confirmEchoFile();
        }
    }

    public void processCommand(String string) {
        if (this.m_ignore.getState()) {
            return;
        }
        this.m_screen.append(string);
        this.m_screen.append("\n");
        if (this.m_echo.getState() && this.m_prw != null) {
            this.m_prw.print(this.m_prompt);
            this.m_prw.println(string);
        }
        if (LEPMCommand.IsReboot(string)) {
            new LERebootThread(this.m_pm);
            return;
        }
        if (LECommandPanel.validCommand(string)) {
            String string2;
            LEPMCommand lEPMCommand = this.m_pm.execute(string);
            if (lEPMCommand != null) {
                string2 = lEPMCommand.getResult();
                string2 = string2 != null && string2.length() > 0 ? string2.replace('\r', ' ') : (lEPMCommand.getStatus() ? SUCCESS : FAILURE);
                this.m_screen.append(string2);
                this.m_screen.append("\n");
                if (this.m_echo.getState() && this.m_prw != null) {
                    this.m_prw.println(string2);
                }
            }
            if (string.length() >= SYSTEM_NAME.length() && SYSTEM_NAME.equals(string.substring(0, SYSTEM_NAME.length()))) {
                this.setPrompt();
            }
            this.m_screen.append(this.m_prompt);
            string2 = this.m_screen.getText();
            this.m_screen.select(string2.length(), string2.length());
            return;
        }
        String string3 = "This command cannot be executed from within " + LEAppInfo.getAppName();
        this.m_screen.append(string3);
        this.m_screen.append("\n");
        if (this.m_echo.getState() && this.m_prw != null) {
            this.m_prw.println(string3);
        }
    }

    public void cleanup() {
        if (this.m_prw != null) {
            this.m_prw.close();
        }
        this.m_prw = null;
        this.m_file = null;
        LEStatusFactory.GetFactory().deleteObserver(this.m_pm.getHostname(), this);
        this.m_pm = null;
    }

    public void confirmAction(String string, Object object) {
        if (string.equals(LEConfirmDialog.YES)) {
            this.setEchoFile((File)object);
            return;
        }
        this.cancelAction(object);
    }

    public void cancelAction(Object object) {
        this.m_file = null;
        this.m_prw = null;
        ((TextComponent)this.m_path).setText(null);
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEStatusMessage) {
            LEStatusMessage lEStatusMessage = (LEStatusMessage)object;
            switch (lEStatusMessage.getStatus()) {
                case 1: {
                    this.m_ignore.setEnabled(true);
                    this.m_ignore.setState(this.m_ignoring);
                    this.setPrompt();
                    this.m_screen.append(this.m_prompt);
                    return;
                }
                case 2: 
                case 4: {
                    this.m_ignoring = this.m_ignore.getState();
                    this.m_ignore.setState(true);
                    this.m_ignore.setEnabled(false);
                    return;
                }
            }
        }
    }

    public void setPrompt() {
        String string = null;
        if (this.m_pm.isConnected()) {
            LESNMP lESNMP = (LESNMP)this.m_pm.get("1376256");
            if (lESNMP != null) {
                string = (String)lESNMP.get("sysname");
            }
        } else {
            this.m_ignoring = this.m_ignore.getState();
            this.m_ignore.setState(true);
            this.m_ignore.setEnabled(false);
        }
        if (string == null || string.length() == 0) {
            string = DEFAULT_SYSNAME;
        }
        this.m_prompt = new String(String.valueOf(string) + SEPARATOR);
    }

    void browseFile() {
        FileDialog fileDialog = new FileDialog(LEUiUtils.getFrame(this), "Command Echo File", 1);
        String string = LEAppInfo.getLastDirectory();
        if (string != null) {
            fileDialog.setDirectory(string);
        }
        ((Component)fileDialog).setVisible(true);
        string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 != null) {
            String string3 = LEAppInfo.createFullPath(string, string2);
            ((TextComponent)this.m_path).setText(string3);
            LEAppInfo.setLastDirectory(string);
            if (this.m_echo.getState()) {
                this.confirmEchoFile();
            }
        }
    }

    void confirmEchoFile() {
        String string = this.m_path.getText();
        if (string.length() == 0) {
            this.m_file = null;
            this.m_prw = null;
            return;
        }
        File file = new File(string);
        if (this.m_file == null || !file.getAbsolutePath().equals(this.m_file.getAbsolutePath())) {
            if (file.exists()) {
                String[] stringArray = new String[]{LEConfirmDialog.YES, LEConfirmDialog.NO};
                LEConfirmDialog lEConfirmDialog = new LEConfirmDialog(LEUiUtils.getFrame(this), (LEConfirmClient)this, String.valueOf(file.getAbsolutePath()) + " already exists. Overwrite it?", stringArray, (Object)file);
                ((Component)lEConfirmDialog).setVisible(true);
                return;
            }
            this.setEchoFile(file);
        }
    }

    void setEchoFile(File file) {
        this.m_file = file;
        ((TextComponent)this.m_path).setText(this.m_file.getAbsolutePath());
        if (this.m_prw != null) {
            this.m_prw.close();
        }
        try {
            FileWriter fileWriter = new FileWriter(this.m_file);
            this.m_prw = new PrintWriter((Writer)fileWriter, true);
            return;
        }
        catch (IOException iOException) {
            this.m_file = null;
            this.m_prw = null;
            ((TextComponent)this.m_path).setText(null);
            LEDebug.getLog().logln(20, iOException);
            new LEErrorDialog(LEUiUtils.getFrame(this), iOException.getMessage());
            return;
        }
    }
}

