/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.tabPanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.layout.NamelessCardLayout;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.tabBar.TabBar;
import oracle.ewt.tabBar.TabBarItem;
import oracle.ewt.tabPanel.TabPanel;

class TabPanelSheet
extends LWComponent {
    private int _orientation = 0;
    private TabPanel _parent;
    private boolean _drawBorder;
    private static final int _INSET_WIDTH = 5;

    public TabPanelSheet(TabPanel tabPanel, boolean bl) {
        this._drawBorder = bl;
        this.setLayout(NamelessCardLayout.getLayoutManager());
        this._parent = tabPanel;
    }

    public void setOrientation(int n) {
        if (this._orientation != n) {
            this._orientation = n;
            this.repaint();
        }
    }

    public void setTabPanel(TabPanel tabPanel) {
        this._parent = tabPanel;
    }

    public TabPanel getTabPanel() {
        return this._parent;
    }

    public void repaintAllItems() {
        Dimension dimension = this.getSize();
        if (this._orientation == 0) {
            this.repaint(0, 0, dimension.width, 2);
            return;
        }
        this.repaint(0, dimension.height - 2, dimension.width, 2);
    }

    public void repaintItemBorder(TabBarItem tabBarItem) {
        if (tabBarItem != null) {
            int n = this._orientation == 0 ? 0 : this.getSize().height - 2;
            Rectangle rectangle = tabBarItem.getOuterBounds();
            rectangle.x += this.getTabPanel().getTabBar().getLocation().x;
            this.repaint(rectangle.x - 2, n - 2, rectangle.width + 4, 4);
        }
    }

    public void paintInterior(Graphics graphics) {
        Color color;
        Color color2;
        int n;
        int n2;
        int n3;
        Dimension dimension = this.getSize();
        TabBar tabBar = this.getTabPanel().getTabBar();
        int n4 = dimension.height;
        int n5 = dimension.width;
        if (!this.getTabPanel().isTabsVisible()) {
            return;
        }
        TabBarItem tabBarItem = tabBar.getSelectedItem();
        Rectangle rectangle = tabBarItem != null ? tabBarItem.getOuterBounds() : null;
        Color color3 = this.getBackground();
        Color color4 = ColorUtils.lighterShadeColor(color3);
        Color color5 = ColorUtils.darkerShadeColor(color3);
        if (this._orientation == 0) {
            n3 = -1;
            n2 = 0;
            n = n4 - 1;
            color2 = color5;
            color = color4;
        } else {
            n3 = 1;
            n2 = n4 - 1;
            n = 0;
            color2 = color4;
            color = color5;
        }
        if (this._drawBorder) {
            graphics.setColor(color4);
            graphics.drawLine(1, 0, 1, n4);
            graphics.setColor(color5);
            graphics.drawLine(n5 - 2, n4 - 1, n5 - 2, 1);
            graphics.setColor(Color.black);
            graphics.drawLine(n5 - 1, n4, n5 - 1, 1);
            graphics.drawLine(0, 0, 0, n4);
            graphics.drawLine(0, n, n5, n);
            graphics.setColor(color2);
            graphics.drawLine(1, n + n3, n5 - 2, n + n3);
        }
        if (tabBarItem != null) {
            rectangle.x += tabBar.getLocation().x;
            graphics.setColor(Color.black);
            graphics.drawLine(0, n2, rectangle.x - 1, n2);
            graphics.drawLine(rectangle.x + rectangle.width + 1, n2, n5, n2);
            graphics.setColor(color);
            int n6 = rectangle.x - 2;
            if (n6 > 1) {
                graphics.drawLine(1, n2 - n3, n6, n2 - n3);
            }
            if ((n6 = rectangle.x + rectangle.width + 2) <= n5 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width + 2, n2 - n3, n5 - 2, n2 - n3);
                return;
            }
        } else if (this._drawBorder) {
            graphics.setColor(Color.black);
            graphics.drawLine(0, n2, n5, n2);
            graphics.setColor(color);
            graphics.drawLine(1, n2 - n3, n5 - 2, n2 - n3);
        }
    }

    public Insets getInsets() {
        if (this.getTabPanel().isTabsVisible()) {
            return new Insets(5, 5, 5, 5);
        }
        return super.getInsets();
    }

    public void displayContents(Component component) {
        NamelessCardLayout.flipToComponent(component);
    }

    protected void validateTree() {
        super.validateTree();
        this.repaint();
    }
}

