/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.htmlBrowser;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Enumeration;
import oracle.ewt.event.ListenerManager;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.PopupEvent;
import oracle.help.htmlBrowser.PopupListener;
import oracle.help.htmlBrowser.URLEvent;
import oracle.help.htmlBrowser.URLListener;
import sunw.hotjava.bean.HotJavaBrowserBean;
import sunw.hotjava.doc.ElementInfo;

public class HotJavaBrowser
extends HotJavaBrowserBean
implements HTMLBrowser,
PropertyChangeListener {
    private boolean _wasLink = false;
    private ListenerManager _urlListeners;
    private ListenerManager _popupListeners;
    private static String ELEMENTINFO = "indicatedElement";
    private static String CURRENTDOCUMENT = "currentDocument";

    public HotJavaBrowser() {
        this.addPropertyChangeListener(this);
    }

    public void setURL(URL uRL) {
        this.setDocumentURL(uRL);
        URLEvent uRLEvent = new URLEvent(uRL);
        this._dispatchURLEvent(uRLEvent);
    }

    public void reloadURL() {
    }

    public URL getURL() {
        return this.getDocumentURL();
    }

    public void print() {
        super.print();
    }

    public void printURL(URL uRL) {
    }

    public boolean isPrintingSupported() {
        return true;
    }

    public void addURLListener(URLListener uRLListener) {
        if (this._urlListeners == null) {
            this._urlListeners = new ListenerManager();
        }
        this._urlListeners.addListener(uRLListener);
    }

    public void removeURLListener(URLListener uRLListener) {
        this._urlListeners.removeListener(uRLListener);
    }

    public void addPopupListener(PopupListener popupListener) {
        if (this._popupListeners == null) {
            this._popupListeners = new ListenerManager();
        }
        this._popupListeners.addListener(popupListener);
    }

    public void removePopupListener(PopupListener popupListener) {
        this._popupListeners.removeListener(popupListener);
    }

    public void setCharset(String string) {
        super.setCharset(string);
    }

    public String getCharset() {
        return super.getCharset();
    }

    private void _dispatchPopupEvent(PopupEvent popupEvent) {
        Enumeration enumeration;
        if (this._popupListeners != null && (enumeration = this._popupListeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                PopupListener popupListener = (PopupListener)enumeration.nextElement();
                popupListener.showPopup(popupEvent);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(ELEMENTINFO)) {
            ElementInfo elementInfo = (ElementInfo)propertyChangeEvent.getNewValue();
            if (elementInfo != null) {
                if (elementInfo.event != null && elementInfo.event.getID() == 501) {
                    MouseEvent mouseEvent = elementInfo.event;
                    this._dispatchPopupEvent(new PopupEvent((Component)mouseEvent.getSource(), mouseEvent));
                }
                if (!this._wasLink && elementInfo.hrefURL != null) {
                    this._wasLink = true;
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                if (this._wasLink && elementInfo.hrefURL == null) {
                    this._wasLink = false;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
            }
        } else if (propertyChangeEvent.getPropertyName().equals(CURRENTDOCUMENT)) {
            URLEvent uRLEvent = new URLEvent(this.getURL());
            this._dispatchURLEvent(uRLEvent);
        }
    }

    private void _dispatchURLEvent(URLEvent uRLEvent) {
        Enumeration enumeration;
        if (this._urlListeners != null && (enumeration = this._urlListeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                URLListener uRLListener = (URLListener)enumeration.nextElement();
                uRLListener.urlChanged(uRLEvent);
            }
        }
    }
}

