/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEAlarmFactory;
import COM.livingston.backend.LEAlarmMessage;
import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;

public class LEAlarmFacility
implements LEAMObserver {
    LEPortMaster m_pm;
    LEVector m_alarms = new LEVector();
    long m_req;

    public LEAlarmFacility(LEPortMaster lEPortMaster) {
        this.m_pm = lEPortMaster;
        if (lEPortMaster.isConnected()) {
            this.startAlarms();
        }
        String string = lEPortMaster.getHostname();
        LEStatusFactory.GetFactory().addObserver(string, this);
    }

    public LEVector getAlarms() {
        return this.m_alarms;
    }

    public void shutdown() {
        this.stopAlarms();
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEAlarmMessage) {
            this.updateAlarm((LEAlarmMessage)object);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus((LEStatusMessage)object);
        }
    }

    void updateAlarm(LEAlarmMessage lEAlarmMessage) {
        String string = lEAlarmMessage.getName();
        int n = this.m_alarms.size();
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < n) {
            LEAlarmMessage lEAlarmMessage2 = (LEAlarmMessage)this.m_alarms.elementAt(n2);
            if (string.equals(lEAlarmMessage2.getName())) {
                bl = true;
                this.m_alarms.setElementAt(lEAlarmMessage, n2);
            }
            ++n2;
        }
        if (!bl) {
            this.m_alarms.addElement(lEAlarmMessage);
        }
    }

    void updateStatus(LEStatusMessage lEStatusMessage) {
        switch (lEStatusMessage.getStatus()) {
            case 1: {
                if (this.m_req != 0L) break;
                this.startAlarms();
                return;
            }
            case 2: 
            case 4: {
                this.m_alarms.removeAllElements();
                this.m_req = 0L;
                return;
            }
        }
    }

    void startAlarms() {
        LEAlarmFactory.GetFactory().addObserver(this.m_pm.getHostname(), this);
        try {
            LEDSSPortMaster lEDSSPortMaster = this.m_pm.getDSS();
            this.m_req = lEDSSPortMaster.alarm(655360);
            return;
        }
        catch (LEDSSException lEDSSException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void stopAlarms() {
        LEAlarmFactory.GetFactory().deleteObserver(this.m_pm.getHostname(), this);
        this.m_alarms.removeAllElements();
        try {
            LEDSSPortMaster lEDSSPortMaster = this.m_pm.getDSS();
            if (this.m_req > 0L && lEDSSPortMaster.isConnected()) {
                lEDSSPortMaster.killAlarm(this.m_req);
                return;
            }
        }
        catch (LEDSSException lEDSSException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }
}

