/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.forms.LEPortsForm;
import COM.livingston.model.LEPort;
import COM.livingston.ui.LEClipboard;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.util.LEVector;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;

public class LEPortsView
extends LETableView {
    public static final String ACTION_RESET = "reset";
    Button m_reset;

    public LEPortsView() {
        this.m_form = new LEPortsForm();
    }

    public void setContext(LEVector lEVector) {
        this.m_form.setContext(lEVector);
        this.m_form.addListener(this);
        this.m_panel = new LEScrollPanel(this.m_form);
        this.m_buttons = new Panel();
        this.m_buttons.setLayout(new FlowLayout(1));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3, 10, 10));
        this.m_edit = new Button("Edit...");
        panel.add(this.m_edit);
        this.m_edit.setActionCommand("edit");
        this.m_edit.addActionListener(this);
        this.m_edit.setEnabled(false);
        this.m_reset = new Button("Reset");
        panel.add(this.m_reset);
        this.m_reset.setActionCommand(ACTION_RESET);
        this.m_reset.addActionListener(this);
        this.m_reset.setEnabled(false);
        Button button = new Button("Refresh");
        panel.add(button);
        button.setActionCommand("refresh");
        button.addActionListener(this);
        this.m_buttons.add(panel);
        this.checkClipboard();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTION_RESET)) {
            this.dispatch(ACTION_RESET);
            return;
        }
        super.actionPerformed(actionEvent);
    }

    public void handleAction(String string) {
        if (string.equals(ACTION_RESET)) {
            this.resetPorts();
            return;
        }
        super.handleAction(string);
    }

    void setState() {
        int n = this.m_form.getSelectSize();
        if (n > 0) {
            this.m_reset.setEnabled(true);
        } else {
            this.m_reset.setEnabled(false);
        }
        super.setState();
    }

    void checkClipboard() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = this.m_form.getSelectSize();
        LEClipboard lEClipboard = LEClipboard.GetClipboard();
        Object object = lEClipboard.getContents();
        if (n > 0 && this.pasteable(object)) {
            bl3 = true;
        }
        if (n == 1) {
            bl2 = true;
        }
        lEClipboard.setState(bl, bl2, bl3, bl4);
    }

    boolean pasteable(Object object) {
        LEVector lEVector;
        if (object instanceof LEVector && (lEVector = (LEVector)object).size() > 0) {
            object = lEVector.elementAt(0);
        }
        return object instanceof LEPort;
    }

    void resetPorts() {
        ((LEPortsForm)this.m_form).resetPorts();
    }

    void paste() {
        LEClipboard lEClipboard = LEClipboard.GetClipboard();
        this.m_form.clone(lEClipboard.getContents());
    }

    void cut() {
    }

    void delete() {
    }
}

